package abstractSyntax;

public class PostfixPrinter implements AstVisitor
{
    public int visit( IdentifierExp exp )
    {
        System.out.print( exp.content() );
        return 0;
    }

    public int visit( AdditionExp exp )
    {
        exp.leftOperand().accept( this );
        System.out.print( " " );
        exp.rightOperand().accept( this );
        System.out.print( " +" );
        return 0;
    }

    public int visit( MultiplicationExp exp )
    {
        exp.leftOperand().accept( this );
        System.out.print( " " );
        exp.rightOperand().accept( this );
        System.out.print( " *" );
        return 0;
    }
}
