package abstractSyntax;

public class MultiplicationExp implements Expression
{
    private Expression leftOperand;
    private Expression rightOperand;

    public MultiplicationExp( Expression left, Expression right )
    {
        leftOperand  = left;
        rightOperand = right;
    }

    protected Expression leftOperand () { return leftOperand; }
    protected Expression rightOperand() { return rightOperand; }

    public String toString()
    {
         return "(" + leftOperand + " * " + rightOperand + ")";
    }

    public int accept( AstVisitor v )
    {
        return v.visit( this );
    }
}
