package abstractSyntax;

public class EvaluateVisitor implements AstVisitor
{
    // These IVs will stand in for an environment.
    private String[] identifiers = { "x", "y", "z" };
    private int   [] values      = {  14,  23,  17 };

    public int visit( IdentifierExp exp )
    {
        String id = exp.content();
        for (int i = 0; i < identifiers.length; i++)
            if ( id.equals(identifiers[i]) )
                return values[i];
        throw new RuntimeException( "no such variable: " + id );
    }

    public int visit( AdditionExp exp )
    {
        int leftValue  = exp.leftOperand().accept( this );
        int rightValue = exp.rightOperand().accept( this );
        return leftValue + rightValue;
    }

    public int visit( MultiplicationExp exp )
    {
        int leftValue  = exp.leftOperand().accept( this );
        int rightValue = exp.rightOperand().accept( this );
        return leftValue * rightValue;
    }
}
