class DrawingNode():
    def __init__(self, list_of_rows):
        self.rows = list_of_rows
    def __str__(self):
        drawing_str = ''
        for r in self.rows:
            drawing_str += (str(r) + '\n')
        return drawing_str
    def value(self):
        return self.rows

class RowNode():
    def __init__(self, repeat_node, list_of_chunks):
        self.count  = repeat_node
        self.chunks = list_of_chunks
    def __str__(self):
        chunk_str = ''
        for c in self.chunks:
            chunk_str += (' ' + str(c))
        return '{}{};'.format(str(self.count), chunk_str)
    def value(self):
        return (self.count, self.chunks)

class RepeatNode():
    def __init__(self, an_integer):
        self.value = an_integer
    def __str__(self):
        return str(self.value)
    def value(self):
        return self.value

class ChunkNode():
    def __init__(self, an_integer, a_char):
        self.count = an_integer
        self.char  = a_char
    def __str__(self):
        return '{} {}'.format(self.count, self.char)
    def value(self):
        return (self.count, self.char)

if __name__ == "__main__":
    horizontal = RowNode( RepeatNode(3), \
                          [ ChunkNode(9, 'x') ] )
    vertical   = RowNode( RepeatNode(6), \
                          [ ChunkNode(3, 'b'), \
                            ChunkNode(3, 'x'), \
                            ChunkNode(3, 'b') ] )
    ex = DrawingNode( [horizontal, vertical, horizontal] )
    print(ex, end='')
