public class ParserDemo
{
    public static void main( String[] args )
    {
        parseAndPrint(   legalExample, "1" );
        parseAndPrint( illegalExample, "2" );
    }

    public static void parseAndPrint( Token[] tokens, String n )
    {
        Scanner   s;
        Parser    p;
        Statement ast;

        try {
            System.out.print( "EXAMPLE " + n + ": " );
            s   = new Scanner( tokens );
            p   = new Parser ( s );
            ast = p.parse();

            if ( ast != null )
                System.out.println( "legal" );
            else
                System.out.println( "program passed, but no AST" );
        } catch (Exception e) {
            System.out.println( "illegal -- " + e );
        }
    }

    private static Token[] legalExample = {
        Token.repeat,
        Token.print,
        Token.identifier,
        Token.until,
        Token.identifier,
        Token.equals,
        Token.zeroPredicate,
        Token.number
    };

    private static Token[] illegalExample = {
        Token.identifier,
        Token.assign,
        Token.print,
        Token.identifier
    };
}
