//
// A barebones recursive-descent parser for the simple grammar
// from Session 9's opening exercise:
//    statement  := repeat statement until expression
//                | print identifier
//                | identifier <- expression
//    expression := identifier = expression
//                | zero? expression
//                | number
//

public class Parser
{
    private Scanner scanner;

    public Parser( Scanner s )
    {
        scanner = s;
    }

    public boolean parse()
    {
        return statement();
    }

    public boolean statement()
    {
        Token next = scanner.peek();
        if ( next.equals(Token.repeat) )
            return match(Token.repeat) && statement() &&
                   match(Token.until)  && expression();
        else if ( next.equals(Token.print) )
            return match(Token.print) && match(Token.identifier);
        else if ( next.equals(Token.identifier) )
            return match(Token.identifier) &&
                   match(Token.assign)     && expression();
        else
            return false;
    }

    public boolean expression()
    {
        Token next = scanner.peek();
        if ( next.equals(Token.identifier) )
            return match(Token.identifier) &&
                   match(Token.equals)     && expression();
        else if ( next.equals(Token.zeroPredicate) )
            return match(Token.zeroPredicate) && expression();
        else if ( next.equals(Token.number) )
            return match(Token.number);
        else
            return false;
    }

    public boolean match( Token expected )
    {
        Token next = scanner.next();
        if ( expected == next )
            return true;
        else
        {
            System.err.println( "Parser expected " + expected +
                                " but saw "        + next     + "." );
            return false;
        }
    }
}