#lang racket

;; This file generates strings based on the following grammar, from
;; the exercise in Session 8:
;;
;;    S := ( L )
;;       | a
;;    L := L , S
;;       | S
;;
;; It produces comma-separated parenthesized lists of comma-separated
;; parenthesized a's, nested arbitrarily deeply.  You can adjust the
;; output by modifying the odds of choosing each branch in the grammar.

(define *prob-nested-S* 0.55)
(define *prob-nested-L* 0.50)

(define make-S
  (lambda ()
    (if (< (random) *prob-nested-S*)
        (string-append "(" (make-L) ")")
        "a")))

(define make-L
  (lambda ()
    (if (< (random) *prob-nested-L*)
        (string-append (make-L) "," (make-S))
        (make-S))))

(make-S)

; --------------------------------------------------------------------
