"""The recursive binary search algorithm
Code from
   Problem Solving with Algorithms and Data Structures using Python
   3rd Edition
   Miller, Ranum, and Yasinovskyy
"""

def binary_search_rec(a_list, item):
    #Is this the base case?
    if len(a_list) == 0:
        return False
    
    #Consider the 'middle' item
    midpoint = len(a_list) // 2
    if a_list[midpoint] == item:
        return True
    
    #If you haven't found it, recursively call the function again with "half" the data
    elif item < a_list[midpoint]:
        return binary_search_rec(a_list[:midpoint], item)
    else:
        return binary_search_rec(a_list[midpoint + 1 :], item)
    
    
    
test_list = [2,4,6,8,10,12,14,16,18,20]

result = binary_search_rec(test_list,6)
print(result)