// ==============================================================
//#+ This module generated by Mumps Compiler 
//#+ Tue Dec 23 15:14:27 2025
//#+ Portions of this code are part of the Mumps Compiler
//#+ 
//#+ Copyright (C) 2000, 2001, 2002, 2003, 2004, 2005, 
//#+ 2010, 2017, 2020, 2022, 2024 by Kevin C. O'Kane  
//#+ 
//#+ Kevin C. O'Kane, Ph.D.
//#+ Professor Emeritus
//#+ Computer Science Department
//#+ University of Northern Iowa
//#+ Cedar Falls, IA 50614-0507
//#+ kc.okane@gmail.com
//#+ okane@uni.edu
//#+ https://threadsafebooks.com
//#+ https://www.cs.uni.edu/~okane
//#+ -----------------------------------
//#+ 
//#+ Consult individual modules for copyright details
//#+ The runtime libraries are covered by the following license:
//#+  
//#+ This library is free software; you can redistribute it and/or
//#+ modify it under the terms of the GNU Lesser General Public
//#+ License as published by the Free Software Foundation; either
//#+ version 2.1 of the License, or (at your option) any later version.
//#+ 
//#+ This library is distributed in the hope that it will be useful,
//#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
//#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//#+ Lesser General Public License for more details.
//#+ 
//#+ You should have received a copy of the GNU Lesser General Public
//#+ License along with this library; if not, write to the Free Software
//#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//#+ 
//#+ This code is unverified - use at your own risk 
//#+==============================================================

#undef _MDH_
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <setjmp.h>
#include <unistd.h>
#include <signal.h>
#include <sys/time.h>
#include <mumpsc/inline.h>
#include <mumpsc/defines.h>
#include <mumpsc/strmax.h>
#include <mumpsc/libmpscpp.h>
#include <mumpsc/sym.h>
#include <mumpsc/builtin.h>
#include <mumpsc/compiler.h>
#define FORPARM STR_MAX  /* Size of For loop parameter */
#define CSTR (char *)
#define UNS unsigned char *
#define uns unsigned char *
#define CCHR const char *
#include <mumpsc/keyfix.h>
#include <mumpsc/globalOrder.h>
#include <mumpsc/stateVector.h>
int (*__label_lookup)(char *);
const char * (*__text_function)(int);
void fcn(MSV *);
void zfcn(unsigned char *, unsigned char *, struct MSV *); /* z functions */
char * sym_(int, unsigned char *, unsigned char *, struct MSV *); /* symbol table */
char * makeLock(char *, char *, char *, char, char *); /* global array lock service */
char * cleanLocks(char *); /* global array lock service */
char * releaseLock(char *, char *, char *); /* global array lock service */
char * eraseLocks(char *); /* global array lock service */
void add(const char *a,const char *b,char *c); /* math function */
void sub(const char *a,const char *b,char *c); /* math function */
void mult(const char *a,const char *b,char *c); /* math function */
void divx(const char *a,const char *b,char *c); /* math function */
void divi(const char *a,const char *b,char *c); /* math function */
void _fnumber(unsigned char *,unsigned char *,
       unsigned char *,unsigned char *, MSV *); /* math function */
int DBSem = 0; /* deadlock prevention */

static inline int floatstring(const char * p) { 
 int f=0;  
 for (; *p!=0; p++) {  
	 if (    isdigit(*p) || 
	 	*p == '-' ||  
		*p == '+' ) continue;  
 	if (    *p=='.' ||  
		tolower(*p)=='e' ) { 
		f=1;  
		continue;  
		} 
	return 0; 
	}  
 return f;  
 } 
 
inline int numcomp2(unsigned char *aa) { 
 if (floatstring((char *) aa)) return (atof( (char *) aa) != 0.0);  
 return atoi((char *) aa);  
 }

inline char * strxcat(char * a, char *b)  
{ while (*a) a++; while( (*(a) = *(b)) ) { a++; b++; } return a; }

inline char * strcatz(char * out, char *in)  
{ while (*out) out++; while (*(out) = *(in)) { out++; in++; } *(out++) = '';  
*out = 0; return (char *) out; } 

void SyncClock() {
    DBSem = 1;
    }

unsigned int set_alarm (unsigned int seconds) {
    struct itimerval old, xnew;
    xnew.it_interval.tv_usec = 0;
    xnew.it_interval.tv_sec = 0 ; // interval between alarms
    xnew.it_value.tv_usec = 0;
    xnew.it_value.tv_sec = (long int) 0;
    if (setitimer (ITIMER_REAL, &xnew, &old) < 0)
        return 0;
    else
        return old.it_value.tv_sec;
    }

#include <mumpsc/global.h>  /* Global array definitions */
  /* Interface to Mglobal(): */
  /* g = command */
  /* key = key sought or stored */
  /* bd = value returned or stored */
  /* svPtr = address of state vector */
#ifndef SUB
#include <mumpsc/fcns.h>  /* System support functions */
#include <mumpsc/sysfunc.h>  /* Many common global variables */
#endif

// !/usr/bin/mumps

//  Copyright 2014, 2022, 2023 Kevin C. O'Kane

//  Feb 28, 2022

//================================================================================= 
//  zmain 
//================================================================================= 

int main(int argc, char *argv[]) {

//#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//#+ Intermediate temporary variables used during execution of string expressions
//#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

char * catx; // intermediate concat ptr
char *_ftmp = new char[STR_MAX]; /* intermediate temp */
/*** Temporary variables */
char for1_incr[FORPARM], for1_lim[FORPARM], for1_init[FORPARM];
int for1F; int for1T; 
char for2_incr[FORPARM], for2_lim[FORPARM], for2_init[FORPARM];
int for2F; int for2T; 
char for3_incr[FORPARM], for3_lim[FORPARM], for3_init[FORPARM];
int for3F; int for3T; 
char for4_incr[FORPARM], for4_lim[FORPARM], for4_init[FORPARM];
int for4F; int for4T; 
char for5_incr[FORPARM], for5_lim[FORPARM], for5_init[FORPARM];
int for5F; int for5T; 
char for6_incr[FORPARM], for6_lim[FORPARM], for6_init[FORPARM];
int for6F; int for6T; 
char for7_incr[FORPARM], for7_lim[FORPARM], for7_init[FORPARM];
int for7F; int for7T; 
char for8_incr[FORPARM], for8_lim[FORPARM], for8_init[FORPARM];
int for8F; int for8T; 
char for9_incr[FORPARM], for9_lim[FORPARM], for9_init[FORPARM];
int for9F; int for9T; 
char for10_incr[FORPARM], for10_lim[FORPARM], for10_init[FORPARM];
int for10F; int for10T; 
char for11_incr[FORPARM], for11_lim[FORPARM], for11_init[FORPARM];
int for11F; int for11T; 
char for12_incr[FORPARM], for12_lim[FORPARM], for12_init[FORPARM];
int for12F; int for12T; 
char for13_incr[FORPARM], for13_lim[FORPARM], for13_init[FORPARM];
int for13F; int for13T; 
char for14_incr[FORPARM], for14_lim[FORPARM], for14_init[FORPARM];
int for14F; int for14T; 
char for15_incr[FORPARM], for15_lim[FORPARM], for15_init[FORPARM];
int for15F; int for15T; 
char for16_incr[FORPARM], for16_lim[FORPARM], for16_init[FORPARM];
int for16F; int for16T; 
jmp_buf for0J;
jmp_buf for1J;
jmp_buf for2J;
jmp_buf for3J;
jmp_buf for4J;
jmp_buf for5J;
jmp_buf for6J;
jmp_buf for7J;
jmp_buf for8J;
jmp_buf for9J;
jmp_buf for10J;
jmp_buf for11J;
jmp_buf for12J;
jmp_buf for13J;
jmp_buf for14J;
jmp_buf for15J;
jmp_buf for16J;
char *__Arg0 = new char[STR_MAX];
jmp_buf Efor0J;
int tpx0;
jmp_buf Efor1J;
int tpx1;
jmp_buf Efor2J;
int tpx2;
jmp_buf Efor3J;
int tpx3;
jmp_buf Efor4J;
int tpx4;
jmp_buf Efor5J;
int tpx5;
jmp_buf Efor6J;
int tpx6;
jmp_buf Efor7J;
int tpx7;
jmp_buf Efor8J;
int tpx8;
unsigned char *tmp0 = new unsigned char[STR_MAX];
unsigned char *tmp1 = new unsigned char[STR_MAX];
unsigned char *tmp2 = new unsigned char[STR_MAX];
unsigned char *tmp3 = new unsigned char[STR_MAX];
unsigned char *tmp4 = new unsigned char[STR_MAX];
unsigned char *tmp5 = new unsigned char[STR_MAX];
unsigned char *tmp6 = new unsigned char[STR_MAX];
unsigned char *tmp7 = new unsigned char[STR_MAX];
unsigned char *_dummy = new unsigned char[STR_MAX]; /* temporary variable */
unsigned char *atmp =new unsigned char[STR_MAX]; /* temporary variable */
unsigned char *xgtmp = new unsigned char [STR_MAX]; /* temporary variable */
unsigned char *gtmpL = new unsigned char[STR_MAX]; /* temporary variable */
unsigned char *tmp = new unsigned char[STR_MAX]; /* temporary variable */
unsigned char *gtmp = new unsigned char [2*STR_MAX]; /* temporary variable */
int _label_lookup(char *); /* resolution of labels */
const char * _text_function(int);
static unsigned char _ReturnVal[STR_MAX]; /* function returns */
int _ArgCount=0; /* Nbr of args to extrinsic */
long _i,_jj,_j,_k,_new;
int _SymPush=0,f=0;
int g=0;
jmp_buf _doStack[128]; /* <do> return stack mechanism */
short   _doStackN[128]={0}; /* <do> return stack mechanism */
static int     _doStx=0; /* <do> return stack mechanism */
char _Refs[10][32];
int _Refsx=0;

if (svPtr == NULL) svPtr = AllocSV();

_SymPush=0; // zap pushed tables 

svPtr->in_file[5]=stdin; // console default/
svPtr->out_file[5]=stdout; // console default

strcpy(svPtr->UDAT,"data.dat");
strcpy(svPtr->UKEY,"key.dat");

if ( 0) { // no alarm if slice is zero
	signal(SIGALRM, SyncClock);
	set_alarm(1);
	}

__label_lookup = _label_lookup;
__text_function = _text_function;

$SymPut("%",argv[0]); 

if (argc > 0) { 
	for (int i = 0; i < argc; i++) { 
		char t[STR_MAX]; 
		sprintf(t,"%%%d", i); 
		$SymPut(t, argv[i]); 
		} 
	} 

try { 

//================================================================================= 
svPtr->LineNumber=7; //  kill ^query 
//================================================================================= 

//--------------
//       Kill
//--------------

	strmove( (UNS) gtmp, (UNS) "");
	strcat((char *) gtmp,(char *) "^query"); 
	{ 
	unsigned char tmp14[STR_MAX], tmp15[STR_MAX]; 
	keyfix(gtmp);
	_k = strlen((const char *) gtmp); 
	strmove((UNS) tmp14, (UNS) gtmp); 
	Mglobal(GKILL, gtmp, tmp15, svPtr); 
	while(1) { 
		_j = Mglobal(XNEXT, gtmp, tmp15, svPtr); 
		if (_j && strncmp( (CCHR) tmp14, (CCHR) gtmp,_k) == 0) { 
			Mglobal(GKILL, gtmp, tmp15, svPtr); 
			continue; 
			} 
		break; 
		} 
	}

//================================================================================= 
svPtr->LineNumber=8; //  kill ^ans 
//================================================================================= 

//--------------
//       Kill
//--------------

	strmove( (UNS) gtmp, (UNS) "");
	strcat((char *) gtmp,(char *) "^ans"); 
	{ 
	unsigned char tmp14[STR_MAX], tmp15[STR_MAX]; 
	keyfix(gtmp);
	_k = strlen((const char *) gtmp); 
	strmove((UNS) tmp14, (UNS) gtmp); 
	Mglobal(GKILL, gtmp, tmp15, svPtr); 
	while(1) { 
		_j = Mglobal(XNEXT, gtmp, tmp15, svPtr); 
		if (_j && strncmp( (CCHR) tmp14, (CCHR) gtmp,_k) == 0) { 
			Mglobal(GKILL, gtmp, tmp15, svPtr); 
			continue; 
			} 
		break; 
		} 
	}

//================================================================================= 
svPtr->LineNumber=9; //  kill ^tmp 
//================================================================================= 

//--------------
//       Kill
//--------------

	strmove( (UNS) gtmp, (UNS) "");
	strcat((char *) gtmp,(char *) "^tmp"); 
	{ 
	unsigned char tmp14[STR_MAX], tmp15[STR_MAX]; 
	keyfix(gtmp);
	_k = strlen((const char *) gtmp); 
	strmove((UNS) tmp14, (UNS) gtmp); 
	Mglobal(GKILL, gtmp, tmp15, svPtr); 
	while(1) { 
		_j = Mglobal(XNEXT, gtmp, tmp15, svPtr); 
		if (_j && strncmp( (CCHR) tmp14, (CCHR) gtmp,_k) == 0) { 
			Mglobal(GKILL, gtmp, tmp15, svPtr); 
			continue; 
			} 
		break; 
		} 
	}

//================================================================================= 
svPtr->LineNumber=11; //  read raw 
//================================================================================= 

//--------------
//       Read
//--------------

	if (svPtr->in_file[svPtr->io] == NULL) 
		ErrorMessage("Read from input file", svPtr->LineNumber); 
	svPtr->tpx = getstr1(svPtr->in_file[svPtr->io], &gtmp); // Read string into gtmp
	if (svPtr->tpx >= 0) svPtr->tpx = 1; else svPtr->tpx = 0; // Set $Test
	sym_(SYMSTORE, (UNS) "raw", (UNS) gtmp, svPtr); // Store result s274 

//================================================================================= 
svPtr->LineNumber=12; //  set tmp="" 
//================================================================================= 

//--------------
//       Set
//--------------

	sym_(SYMSTORE, (UNS) "tmp", (UNS) "", svPtr); // Store result s274 

//================================================================================= 
svPtr->LineNumber=13; //  set query="" 
//================================================================================= 

//--------------
//       Set
//--------------

	sym_(SYMSTORE, (UNS) "query", (UNS) "", svPtr); // Store result s274 

//================================================================================= 
svPtr->LineNumber=15; //  for i=1:1:$l(raw) do 
//================================================================================= 

//--------------
//       For
//--------------

	strcpy(for1_lim, "");
	strmove((UNS) for1_init, (UNS) "1"); // init value m2534
	strmove( (UNS) for1_incr, (UNS) "1"); // inc/dec m2575
	if (sym_(SYMGET, (UNS) "raw", (UNS) tmp0, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "raw"); // not found
	_length((UNS) tmp1, (UNS) tmp0, (UNS) "");
	strmove((UNS) for1_lim, (UNS) tmp1); // limit value

	if (strchr((char *) for1_incr, '.')) // inc/dec is float
		for1F = atof(for1_incr) < 0.0 ? 1 : 0; // incr or decr?
	else // inc/dec is integer
		for1F = atol(for1_incr) < 0 ? 1 : 0; // incr or decr?

	for ( sym_(SYMSTORE, (UNS) "i", (UNS) for1_init, svPtr); // init 2618

		for1F ? // loop limit test direction
			numcomp((UNS) sym_(11, (UNS) "i", 
				 _dummy, svPtr),
				(UNS) for1_lim) >= 0 // GE limit value?
			: // ternary operator
			numcomp((UNS) sym_(11, (UNS) "i", 
				_dummy,svPtr),
				(UNS) for1_lim) <= 0; // LE limit value

		add( sym_(11, (UNS) "i", _dummy, svPtr), // inc/dec loop var
			for1_incr, (char *) _dummy),
		sym_(SYMSTORE, (UNS) "i", (UNS) _dummy, svPtr) ) // store rslt

		if ((_i = setjmp(for1J)) == 0) goto For1; // else continue

	else if (_i == 100) goto For1Exit; // f273

	goto For1Exit; // bypass block 

For1: // for loop body entry point B

	do { // for loop body
		svPtr->LineNumber = 15; 

//--------------
//       Do
//--------------

		tpx0 = svPtr->tpx; 
		if ( (_i = setjmp(Efor0J)) == 0) goto Do_Block_Entry0; //else continue 
		else if (_i == 100) goto Do_Block_Bypass0; // IF_flg m1402
	} while (0); longjmp(for1J, _i); // FOR loop 1 close 

For1Exit: ; // exit for loop 

	goto Do_Block_Bypass0; // C3551 bypass indented group

//-------------------------------------
Do_Block_Entry0:; // Enter Do Block
//-------------------------------------

do { /* dotted indent entry */

//================================================================================= 
svPtr->LineNumber=16; //  . set x=$e(raw,i) 
//================================================================================= 

//--------------
//       Set
//--------------

	if (sym_(SYMGET, (UNS) "raw", (UNS) tmp1, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "raw"); // not found
	if (sym_(SYMGET, (UNS) "i", (UNS) tmp2, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "i"); // not found
	_extract( (UNS) tmp3,
 		(UNS) tmp1, (UNS) tmp2, (UNS) "-1"); // p2493
	sym_(SYMSTORE, (UNS) "x", (UNS) tmp3, svPtr); // Store result s274 

//================================================================================= 
svPtr->LineNumber=17; //  . if x=" " quit 
//================================================================================= 

//--------------
//       If
//--------------

	if (sym_(SYMGET, (UNS) "x", (UNS) tmp0, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "x"); // not found
	if (strcmp((const char *) tmp0,(const char *) " ")==0) 
	strmove( (UNS) tmp1, (UNS) "1");
	else strmove( (UNS) tmp1, (UNS) "0");
	svPtr->tpx = 0; //Default $Test indicator
	if (numcomp2((UNS) tmp1 )) { // Test if true 
	svPtr->tpx = 1; // $test becomes true

//--------------
//       Quit
//--------------

	break; 
	} // if block 2389

//================================================================================= 
svPtr->LineNumber=18; //  . if x?.n quit 
//================================================================================= 

//--------------
//       If
//--------------

	if (sym_(SYMGET, (UNS) "x", (UNS) tmp0, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "x"); // not found
	if (pm( (const unsigned char *) tmp0, (const unsigned char *) ".n", svPtr)) 
	strmove((UNS) tmp1, (UNS) "1"); // pattern match
	else strmove((UNS) tmp1,(UNS) "0");
	svPtr->tpx = 0; //Default $Test indicator
	if (numcomp2((UNS) tmp1 )) { // Test if true 
	svPtr->tpx = 1; // $test becomes true

//--------------
//       Quit
//--------------

	break; 
	} // if block 2389

//================================================================================= 
svPtr->LineNumber=19; //  . set tmp=tmp_x 
//================================================================================= 

//--------------
//       Set
//--------------

	if (sym_(SYMGET, (UNS) "tmp", (UNS) tmp1, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "tmp"); // not found
	if (sym_(SYMGET, (UNS) "x", (UNS) tmp2, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "x"); // not found
	if (strlen((const char *) tmp1) +
	strlen((const char *) tmp2) + 1 
	> STR_MAX)
	ErrorMessage("String too long", svPtr->LineNumber);
	strmove( (UNS) tmp3, (UNS) tmp1);
	strcat( (char *) tmp3, (char *) tmp2);
	sym_(SYMSTORE, (UNS) "tmp", (UNS) tmp3, svPtr); // Store result s274 
	} while(0); // dotted un-indent 0 
	longjmp(Efor0J,99); // return 

Do_Block_Bypass0: ; //B848 


//================================================================================= 
svPtr->LineNumber=21; //  set j=0 
//================================================================================= 

//--------------
//       Set
//--------------

	sym_(SYMSTORE, (UNS) "j", (UNS) "0", svPtr); // Store result s274 

//================================================================================= 
svPtr->LineNumber=22; //  for  do 
//================================================================================= 

//--------------
//       For
//--------------

	while(1) {  /* Argumentless FOR */

//--------------
//       Do
//--------------

		tpx1 = svPtr->tpx; 
		if ( (_i = setjmp(Efor1J)) == 0) goto Do_Block_Entry1; //else continue 
		else if (_i == 100) goto Do_Block_Bypass1; // IF_flg m1402
	} 
	goto Do_Block_Bypass1; // C3551 bypass indented group

//-------------------------------------
Do_Block_Entry1:; // Enter Do Block
//-------------------------------------

do { /* dotted indent entry */

//================================================================================= 
svPtr->LineNumber=23; //  . set j=$zShredQuery(tmp,11) 
//================================================================================= 

//--------------
//       Set
//--------------

	strmove( (UNS) &gtmp[1], (UNS) "");
	catx = strxcat((char *) &gtmp[1],"$zShredQuery\xce");
	if (sym_(SYMGET, (UNS) "tmp", (UNS) tmp1, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "tmp"); // not found
	strxcat((char *) catx ,(char *) tmp1);
	strxcat((char *) catx,"\xd0");
	strxcat((char *) catx ,(char *) "11");
	strxcat((char *) catx,"\xcf");
	zfcn(gtmp,tmp2,svPtr);
	sym_(SYMSTORE, (UNS) "j", (UNS) tmp2, svPtr); // Store result s274 

//================================================================================= 
svPtr->LineNumber=24; //  . if j="" break 
//================================================================================= 

//--------------
//       If
//--------------

	if (sym_(SYMGET, (UNS) "j", (UNS) tmp0, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "j"); // not found
	if (strcmp((const char *) tmp0,(const char *) "")==0) 
	strmove( (UNS) tmp1, (UNS) "1");
	else strmove( (UNS) tmp1, (UNS) "0");
	svPtr->tpx = 0; //Default $Test indicator
	if (numcomp2((UNS) tmp1 )) { // Test if true 
	svPtr->tpx = 1; // $test becomes true

//--------------
//       Break
//--------------

     svPtr->tpx=tpx1; // break code: restore $test
  longjmp(Efor1J,100); 
	} 

//================================================================================= 
svPtr->LineNumber=25; //  . set query=query_" "_j 
//================================================================================= 

//--------------
//       Set
//--------------

	if (sym_(SYMGET, (UNS) "query", (UNS) tmp1, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "query"); // not found
	if (strlen((const char *) tmp1) +
	strlen((const char *) " ") + 1 
	> STR_MAX)
	ErrorMessage("String too long", svPtr->LineNumber);
	strmove( (UNS) tmp2, (UNS) tmp1);
	strcat( (char *) tmp2, (char *) " ");
	if (sym_(SYMGET, (UNS) "j", (UNS) tmp3, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "j"); // not found
	if (strlen((const char *) tmp2) +
	strlen((const char *) tmp3) + 1 
	> STR_MAX)
	ErrorMessage("String too long", svPtr->LineNumber);
	strmove( (UNS) tmp4, (UNS) tmp2);
	strcat( (char *) tmp4, (char *) tmp3);
	sym_(SYMSTORE, (UNS) "query", (UNS) tmp4, svPtr); // Store result s274 
	} while(0); // dotted un-indent 0 
	longjmp(Efor1J,99); // return 

Do_Block_Bypass1: ; //B848 


//================================================================================= 
svPtr->LineNumber=27; //  open 1:"full.seq,new" 
//================================================================================= 

//--------------
//       Open
//--------------

	_i = atoi( CSTR "1");
	strmove((UNS) tmp0, (UNS) "full.seq,new");
	for(_j=0; tmp0[_j]!=0 && tmp0[_j]!=',';_j++);
	if (tmp0[_j]!=',') ErrorMessage("File open error",svPtr->LineNumber);
	tmp0[_j++]=0;
	strmove((UNS) gtmp, (UNS) tmp0);
	if (strcmp( (CCHR) &tmp0[_j], (CCHR) "old") == 0 || 
		strcmp( (CCHR) &tmp0[_j], (CCHR) "OLD") == 0) _new = 0; 
	else if (strcmp( (CCHR) &tmp0[_j], (CCHR) "new") == 0 || 
		strcmp((CCHR) &tmp0[_j], (CCHR) "NEW") == 0) _new = 1; 
	else if (strcmp( (CCHR) &tmp0[_j], (CCHR) "append") == 0 || 
		strcmp( (CCHR) &tmp0[_j], (const char *) "APPEND") == 0) _new=2; 
	else ErrorMessage("File open error",svPtr->LineNumber);
	if (svPtr->out_file[_i] != NULL || svPtr->in_file[_i] != NULL) 
		ErrorMessage("File already open", svPtr->LineNumber); 
	if (_new==1) { /* output */ 
		svPtr->out_file[_i] = fopen((const char *) gtmp, "w"); 
		if(svPtr->out_file[_i] == NULL) svPtr->tpx = 0; 
		else svPtr->tpx = 1; 
		} 
	else if (_new == 2) { /* append */ 
		svPtr->out_file[_i] = fopen((const char *) gtmp, "a"); 
		if(svPtr->out_file[_i] == NULL) svPtr->tpx = 0; 
		else svPtr->tpx = 1; 
		} 
	else { /* input */ 
		svPtr->in_file[_i] = fopen((const char *) gtmp, "r"); 
		if(svPtr->in_file[_i] == NULL) svPtr->tpx = 0; 
		else svPtr->tpx = 1; 
		}

//================================================================================= 
svPtr->LineNumber=28; //  use 1 
//================================================================================= 

//--------------
//       Use
//--------------

	svPtr->io=atoi( CSTR "1");

//================================================================================= 
svPtr->LineNumber=29; //  write tmp,! 
//================================================================================= 

//--------------
//       Write
//--------------

	if (svPtr->out_file[svPtr->io]==NULL) 
		ErrorMessage("Write to input file", svPtr->LineNumber); // m1944 
	if (sym_(SYMGET, (UNS) "tmp", (UNS) tmp0, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "tmp"); // not found
	svPtr->hor[svPtr->io] += fprintf(svPtr->out_file[svPtr->io], "%s", 
		tmp0);
	fprintf(svPtr->out_file[svPtr->io], "\n"); 
	svPtr->hor[svPtr->io]=0; svPtr->ver[svPtr->io]++; 

//================================================================================= 
svPtr->LineNumber=30; //  close 1 
//================================================================================= 

//--------------
//       Close
//--------------

	_i=atoi( CSTR "1");
	if (svPtr->in_file[_i] == NULL && svPtr->out_file[_i] == NULL) 
		ErrorMessage("Attempt to close unopened file", svPtr->LineNumber); 
	if (svPtr->in_file[_i]!=NULL) { 
	fclose(svPtr->in_file[_i]); svPtr->in_file[_i]=NULL; }
	else { fclose(svPtr->out_file[_i]); svPtr->out_file[_i]=NULL; }

//================================================================================= 
svPtr->LineNumber=31; //  use 5 
//================================================================================= 

//--------------
//       Use
//--------------

	svPtr->io=atoi( CSTR "5");

//================================================================================= 
svPtr->LineNumber=33; //  write ! 
//================================================================================= 

//--------------
//       Write
//--------------

	if (svPtr->out_file[svPtr->io]==NULL) 
		ErrorMessage("Write to input file", svPtr->LineNumber); // m1944 
	fprintf(svPtr->out_file[svPtr->io], "\n"); 
	svPtr->hor[svPtr->io]=0; svPtr->ver[svPtr->io]++; 

//================================================================================= 
svPtr->LineNumber=34; //  write "Query is: ",tmp,!! 
//================================================================================= 

//--------------
//       Write
//--------------

	if (svPtr->out_file[svPtr->io]==NULL) 
		ErrorMessage("Write to input file", svPtr->LineNumber); // m1944 
	svPtr->hor[svPtr->io] += fprintf(svPtr->out_file[svPtr->io], "%s", 
		"Query is: ");
	if (sym_(SYMGET, (UNS) "tmp", (UNS) tmp0, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "tmp"); // not found
	svPtr->hor[svPtr->io] += fprintf(svPtr->out_file[svPtr->io], "%s", 
		tmp0);
	fprintf(svPtr->out_file[svPtr->io], "\n"); 
	svPtr->hor[svPtr->io]=0; svPtr->ver[svPtr->io]++; 
	fprintf(svPtr->out_file[svPtr->io], "\n"); 
	svPtr->hor[svPtr->io]=0; svPtr->ver[svPtr->io]++; 

//================================================================================= 
svPtr->LineNumber=36; //  for i=2:1 do  // leading blank - start at 2 
//================================================================================= 

//--------------
//       For
//--------------

	strcpy(for4_lim, "");
	strmove((UNS) for4_init, (UNS) "2"); // init value m2534
	strmove( (UNS) for4_incr, (UNS) "1"); // inc/dec m2575

	if (strchr((char *) for4_incr, '.')) // inc/dec is float
		for4F = atof(for4_incr) < 0.0 ? 1 : 0; // incr or decr?
	else // inc/dec is integer
		for4F = atol(for4_incr) < 0 ? 1 : 0; // incr or decr?

	for ( sym_(SYMSTORE, (UNS) "i", (UNS) for4_init, svPtr); // init 2618

		1;  // limit expression - no limit

		add( sym_(11, (UNS) "i", _dummy, svPtr), // inc/dec loop var
			for4_incr, (char *) _dummy),
		sym_(SYMSTORE, (UNS) "i", (UNS) _dummy, svPtr) ) // store rslt

		if ((_i = setjmp(for4J)) == 0) goto For4; // else continue

	else if (_i == 100) goto For4Exit; // f273

	goto For4Exit; // bypass block 

For4: // for loop body entry point B

	do { // for loop body
		svPtr->LineNumber = 36; 

//--------------
//       Do
//--------------

		tpx2 = svPtr->tpx; 
		if ( (_i = setjmp(Efor2J)) == 0) goto Do_Block_Entry2; //else continue 
		else if (_i == 100) goto Do_Block_Bypass2; // IF_flg m1402
	} while (0); longjmp(for4J, _i); // FOR loop 1 close 

For4Exit: ; // exit for loop 

	goto Do_Block_Bypass2; // C3551 bypass indented group

//-------------------------------------
Do_Block_Entry2:; // Enter Do Block
//-------------------------------------

do { /* dotted indent entry */

//================================================================================= 
svPtr->LineNumber=37; //  . set w=$p(query," ",i) 
//================================================================================= 

//--------------
//       Set
//--------------

	if (sym_(SYMGET, (UNS) "query", (UNS) tmp1, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "query"); // not found
	if (sym_(SYMGET, (UNS) "i", (UNS) tmp2, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "i"); // not found
	_piece((UNS) tmp3, 
		(UNS) tmp1,(UNS) " ",(UNS) tmp2, (UNS) "-1", 
		0, (UNS) "", svPtr); // p1136
	sym_(SYMSTORE, (UNS) "w", (UNS) tmp3, svPtr); // Store result s274 

//================================================================================= 
svPtr->LineNumber=38; //  . if w="" break 
//================================================================================= 

//--------------
//       If
//--------------

	if (sym_(SYMGET, (UNS) "w", (UNS) tmp0, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "w"); // not found
	if (strcmp((const char *) tmp0,(const char *) "")==0) 
	strmove( (UNS) tmp1, (UNS) "1");
	else strmove( (UNS) tmp1, (UNS) "0");
	svPtr->tpx = 0; //Default $Test indicator
	if (numcomp2((UNS) tmp1 )) { // Test if true 
	svPtr->tpx = 1; // $test becomes true

//--------------
//       Break
//--------------

     svPtr->tpx=tpx2; // break code: restore $test
  longjmp(Efor2J,100); 
	} 

//  . if '$data(^dict(w)) quit

//================================================================================= 
svPtr->LineNumber=42; //  . write "Known query ngram: ",w,! 
//================================================================================= 

//--------------
//       Write
//--------------

	if (svPtr->out_file[svPtr->io]==NULL) 
		ErrorMessage("Write to input file", svPtr->LineNumber); // m1944 
	svPtr->hor[svPtr->io] += fprintf(svPtr->out_file[svPtr->io], "%s", 
		"Known query ngram: ");
	if (sym_(SYMGET, (UNS) "w", (UNS) tmp0, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "w"); // not found
	svPtr->hor[svPtr->io] += fprintf(svPtr->out_file[svPtr->io], "%s", 
		tmp0);
	fprintf(svPtr->out_file[svPtr->io], "\n"); 
	svPtr->hor[svPtr->io]=0; svPtr->ver[svPtr->io]++; 

//================================================================================= 
svPtr->LineNumber=44; //  . set ^query(w)=3 
//================================================================================= 

//--------------
//       Set
//--------------

	strmove((UNS) tmp1, (UNS) "query\xce"); // M3701
	if (sym_(SYMGET, (UNS) "w", (UNS) tmp0, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "w"); // not found
	catx = strxcat((char *) tmp1, (char *) tmp0); // a2926
	strcat((char *) catx, (char *) "\xcf"); //a3956

	{ 
	f = Mglobal(STORE, tmp1, "3", svPtr); 
	} 


//  Find sequences containing one or more query terms.

//================================================================================= 
svPtr->LineNumber=48; //  . for d=$order(^index(w,d)) set ^tmp(d)=""  // retain doc id 
//================================================================================= 

//--------------
//       For
//--------------

	strcpy(for6_lim, "");
	sym_(SYMSTORE, (UNS) "d", (UNS) "", svPtr); // init $ case 2518 

For_Group6: // m2522

	strmove((UNS) tmp2, (UNS) "^index\x01"); // init p674
	if (sym_(SYMGET, (UNS) "w", (UNS) tmp0, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "w"); // not found
	strcatx((UNS) tmp2, (UNS) tmp0);
	if (sym_(SYMGET, (UNS) "d", (UNS) tmp1, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "d"); // not found
	strcatx((UNS) tmp2, (UNS) tmp1);
	GlobalOrder((unsigned char *) tmp2, (unsigned char *) tmp3, 
		(unsigned char *) NULL, svPtr); // p2236
	sym_(SYMSTORE, (UNS) "d", (UNS) tmp3, svPtr); // set loop variable m2752
	if (strlen( (const char *) tmp3) == 0 ) goto For6Exit; // exit if empty 2758
	if ( setjmp( for6J ) == 0 ) goto For6; 
	goto For_Group6; // m2771
	goto For6Exit; // bypass block 

For6: // for loop body entry point B

	do { // for loop body
		svPtr->LineNumber = 48; 

//--------------
//       Set
//--------------

	strmove((UNS) tmp5, (UNS) "tmp\xce"); // M3701
	if (sym_(SYMGET, (UNS) "d", (UNS) tmp4, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "d"); // not found
	catx = strxcat((char *) tmp5, (char *) tmp4); // a2926
	strcat((char *) catx, (char *) "\xcf"); //a3956

	{ 
	f = Mglobal(STORE, tmp5, "", svPtr); 
	} 

	} while (0); longjmp(for6J, _i); // FOR loop 1 close 

For6Exit: ; // exit for loop 

	} while(0); // dotted un-indent 0 
	longjmp(Efor2J,99); // return 

Do_Block_Bypass2: ; //B848 


//================================================================================= 
svPtr->LineNumber=50; //       set time0=$zd1 
//================================================================================= 

//--------------
//       Set
//--------------

	strcpy((char *) &gtmp[1],(const char *) "$zd1");
	zfcn(gtmp,tmp1,svPtr);
	sym_(SYMSTORE, (UNS) "time0", (UNS) tmp1, svPtr); // Store result s274 

//================================================================================= 
svPtr->LineNumber=51; //       write ! 
//================================================================================= 

//--------------
//       Write
//--------------

	if (svPtr->out_file[svPtr->io]==NULL) 
		ErrorMessage("Write to input file", svPtr->LineNumber); // m1944 
	fprintf(svPtr->out_file[svPtr->io], "\n"); 
	svPtr->hor[svPtr->io]=0; svPtr->ver[svPtr->io]++; 

//================================================================================= 
svPtr->LineNumber=53; //       set file=$j_".tmp" 
//================================================================================= 

//--------------
//       Set
//--------------

	sprintf((char *) tmp1,"%d",getpid()); //$job linux
	if (strlen((const char *) tmp1) +
	strlen((const char *) ".tmp") + 1 
	> STR_MAX)
	ErrorMessage("String too long", svPtr->LineNumber);
	strmove( (UNS) tmp2, (UNS) tmp1);
	strcat( (char *) tmp2, (char *) ".tmp");
	sym_(SYMSTORE, (UNS) "file", (UNS) tmp2, svPtr); // Store result s274 

//================================================================================= 
svPtr->LineNumber=54; //       open 1:file_",new" 
//================================================================================= 

//--------------
//       Open
//--------------

	_i = atoi( CSTR "1");
	if (sym_(SYMGET, (UNS) "file", (UNS) tmp0, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "file"); // not found
	if (strlen((const char *) tmp0) +
	strlen((const char *) ",new") + 1 
	> STR_MAX)
	ErrorMessage("String too long", svPtr->LineNumber);
	strmove( (UNS) tmp1, (UNS) tmp0);
	strcat( (char *) tmp1, (char *) ",new");
	strmove((UNS) tmp0, (UNS) tmp1);
	for(_j=0; tmp0[_j]!=0 && tmp0[_j]!=',';_j++);
	if (tmp0[_j]!=',') ErrorMessage("File open error",svPtr->LineNumber);
	tmp0[_j++]=0;
	strmove((UNS) gtmp, (UNS) tmp0);
	if (strcmp( (CCHR) &tmp0[_j], (CCHR) "old") == 0 || 
		strcmp( (CCHR) &tmp0[_j], (CCHR) "OLD") == 0) _new = 0; 
	else if (strcmp( (CCHR) &tmp0[_j], (CCHR) "new") == 0 || 
		strcmp((CCHR) &tmp0[_j], (CCHR) "NEW") == 0) _new = 1; 
	else if (strcmp( (CCHR) &tmp0[_j], (CCHR) "append") == 0 || 
		strcmp( (CCHR) &tmp0[_j], (const char *) "APPEND") == 0) _new=2; 
	else ErrorMessage("File open error",svPtr->LineNumber);
	if (svPtr->out_file[_i] != NULL || svPtr->in_file[_i] != NULL) 
		ErrorMessage("File already open", svPtr->LineNumber); 
	if (_new==1) { /* output */ 
		svPtr->out_file[_i] = fopen((const char *) gtmp, "w"); 
		if(svPtr->out_file[_i] == NULL) svPtr->tpx = 0; 
		else svPtr->tpx = 1; 
		} 
	else if (_new == 2) { /* append */ 
		svPtr->out_file[_i] = fopen((const char *) gtmp, "a"); 
		if(svPtr->out_file[_i] == NULL) svPtr->tpx = 0; 
		else svPtr->tpx = 1; 
		} 
	else { /* input */ 
		svPtr->in_file[_i] = fopen((const char *) gtmp, "r"); 
		if(svPtr->in_file[_i] == NULL) svPtr->tpx = 0; 
		else svPtr->tpx = 1; 
		}

//================================================================================= 
svPtr->LineNumber=56; //       set f=0 
//================================================================================= 

//--------------
//       Set
//--------------

	sym_(SYMSTORE, (UNS) "f", (UNS) "0", svPtr); // Store result s274 

//================================================================================= 
svPtr->LineNumber=58; //       for i=$order(^tmp(i)) do  // calculate cosine between query and each doc 
//================================================================================= 

//--------------
//       For
//--------------

	strcpy(for7_lim, "");
	sym_(SYMSTORE, (UNS) "i", (UNS) "", svPtr); // init $ case 2518 

For_Group7: // m2522

	strmove((UNS) tmp1, (UNS) "^tmp\x01"); // init p674
	if (sym_(SYMGET, (UNS) "i", (UNS) tmp0, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "i"); // not found
	strcatx((UNS) tmp1, (UNS) tmp0);
	GlobalOrder((unsigned char *) tmp1, (unsigned char *) tmp2, 
		(unsigned char *) NULL, svPtr); // p2236
	sym_(SYMSTORE, (UNS) "i", (UNS) tmp2, svPtr); // set loop variable m2752
	if (strlen( (const char *) tmp2) == 0 ) goto For7Exit; // exit if empty 2758
	if ( setjmp( for7J ) == 0 ) goto For7; 
	goto For_Group7; // m2771
	goto For7Exit; // bypass block 

For7: // for loop body entry point B

	do { // for loop body
		svPtr->LineNumber = 58; 

//--------------
//       Do
//--------------

		tpx3 = svPtr->tpx; 
		if ( (_i = setjmp(Efor3J)) == 0) goto Do_Block_Entry3; //else continue 
		else if (_i == 100) goto Do_Block_Bypass3; // IF_flg m1402
	} while (0); longjmp(for7J, _i); // FOR loop 1 close 

For7Exit: ; // exit for loop 

	goto Do_Block_Bypass3; // C3551 bypass indented group

//-------------------------------------
Do_Block_Entry3:; // Enter Do Block
//-------------------------------------

do { /* dotted indent entry */

//================================================================================= 
svPtr->LineNumber=59; //       . set c=$zzcosine(^doc(i),^query)   // MDH cosine calculation 
//================================================================================= 

//--------------
//       Set
//--------------

	strmove((UNS) tmp2, (UNS) "^doc\x01"); // init p674
	if (sym_(SYMGET, (UNS) "i", (UNS) tmp1, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "i"); // not found
	strcatx((UNS) tmp2, (UNS) tmp1);
	strmove((UNS) tmp4, (UNS) "^query\x0"); // init p674
	strmove( (UNS) &gtmp[1], (UNS) "");
	catx = strxcat((char *) &gtmp[1],"$zzcosine\xce");
	strxcat((char *) catx ,(char *) tmp2);
	strxcat((char *) catx,"\xd0");
	strxcat((char *) catx ,(char *) tmp4);
	strxcat((char *) catx,"\xcf");
	zfcn(gtmp,tmp6,svPtr);
	sym_(SYMSTORE, (UNS) "c", (UNS) tmp6, svPtr); // Store result s274 

//================================================================================= 
svPtr->LineNumber=60; //       . if c>0 use 1 write $justify(c,5,3)," ",i,! set f=f+1 
//================================================================================= 

//--------------
//       If
//--------------

	if (sym_(SYMGET, (UNS) "c", (UNS) tmp0, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "c"); // not found
	if (numcomp1((UNS) tmp0, 0) > 0) strmove((UNS) tmp1, (UNS) "1");
	else strmove((UNS) tmp1, (UNS) "0");
	svPtr->tpx = 0; //Default $Test indicator
	if (numcomp2((UNS) tmp1 )) { // Test if true 
	svPtr->tpx = 1; // $test becomes true

//--------------
//       Use
//--------------

	svPtr->io=atoi( CSTR "1");

//--------------
//       Write
//--------------

	if (svPtr->out_file[svPtr->io]==NULL) 
		ErrorMessage("Write to input file", svPtr->LineNumber); // m1944 
	if (sym_(SYMGET, (UNS) "c", (UNS) tmp2, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "c"); // not found
	_justify( (UNS) tmp3, (UNS) tmp2, (UNS)"5", (UNS)"3");
	svPtr->hor[svPtr->io] += fprintf(svPtr->out_file[svPtr->io], "%s", 
		tmp3);
	svPtr->hor[svPtr->io] += fprintf(svPtr->out_file[svPtr->io], "%s", 
		" ");
	if (sym_(SYMGET, (UNS) "i", (UNS) tmp4, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "i"); // not found
	svPtr->hor[svPtr->io] += fprintf(svPtr->out_file[svPtr->io], "%s", 
		tmp4);
	fprintf(svPtr->out_file[svPtr->io], "\n"); 
	svPtr->hor[svPtr->io]=0; svPtr->ver[svPtr->io]++; 

//--------------
//       Set
//--------------

	if (sym_(SYMGET, (UNS) "f", (UNS) tmp6, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "f"); // not found
	add( (char *) tmp6, "1", (char *) tmp7 ); 
	sym_(SYMSTORE, (UNS) "f", (UNS) tmp7, svPtr); // Store result s274 
	} 
	} while(0); // dotted un-indent 0 
	longjmp(Efor3J,99); // return 

Do_Block_Bypass3: ; //B848 


//================================================================================= 
svPtr->LineNumber=62; //       close 1 
//================================================================================= 

//--------------
//       Close
//--------------

	_i=atoi( CSTR "1");
	if (svPtr->in_file[_i] == NULL && svPtr->out_file[_i] == NULL) 
		ErrorMessage("Attempt to close unopened file", svPtr->LineNumber); 
	if (svPtr->in_file[_i]!=NULL) { 
	fclose(svPtr->in_file[_i]); svPtr->in_file[_i]=NULL; }
	else { fclose(svPtr->out_file[_i]); svPtr->out_file[_i]=NULL; }

//================================================================================= 
svPtr->LineNumber=63; //       use 5 
//================================================================================= 

//--------------
//       Use
//--------------

	svPtr->io=atoi( CSTR "5");

//================================================================================= 
svPtr->LineNumber=64; //       if 'f halt 
//================================================================================= 

//--------------
//       If
//--------------

	if (sym_(SYMGET, (UNS) "f", (UNS) tmp0, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "f"); // not found
	if (numcomp1( (UNS) tmp0, 0) == 0) 
		strmove( (UNS) tmp1, (UNS) "1");
	else strmove( (UNS) tmp1, (UNS) "0");
	svPtr->tpx = 0; //Default $Test indicator
	if (numcomp2((UNS) tmp1 )) { // Test if true 
	svPtr->tpx = 1; // $test becomes true

//--------------
//       Halt
//--------------

	goto _epilogue; 
	} 

//================================================================================= 
svPtr->LineNumber=66; //       set outfile="sorted"_file 
//================================================================================= 

//--------------
//       Set
//--------------

	if (sym_(SYMGET, (UNS) "file", (UNS) tmp1, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "file"); // not found
	if (strlen((const char *) "sorted") +
	strlen((const char *) tmp1) + 1 
	> STR_MAX)
	ErrorMessage("String too long", svPtr->LineNumber);
	strmove( (UNS) tmp2, (UNS) "sorted");
	strcat( (char *) tmp2, (char *) tmp1);
	sym_(SYMSTORE, (UNS) "outfile", (UNS) tmp2, svPtr); // Store result s274 

//================================================================================= 
svPtr->LineNumber=67; //       shell sort -nr < &~file~ > &~outfile~ 
//================================================================================= 

//--------------
//       Shell
//--------------

	_jj = Interpret( (CCHR) 
		"shell sort -nr < &~file~ > &~outfile~", svPtr); 
	svPtr->ERROR = _jj; 
	if (!svPtr->NOERR && _jj < 0) 
		ErrorMessage("Indirection error", svPtr->LineNumber); 

//================================================================================= 
svPtr->LineNumber=69; //       open 1:"sorted"_file_",old" 
//================================================================================= 

//--------------
//       Open
//--------------

	_i = atoi( CSTR "1");
	if (sym_(SYMGET, (UNS) "file", (UNS) tmp0, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "file"); // not found
	if (strlen((const char *) "sorted") +
	strlen((const char *) tmp0) + 1 
	> STR_MAX)
	ErrorMessage("String too long", svPtr->LineNumber);
	strmove( (UNS) tmp1, (UNS) "sorted");
	strcat( (char *) tmp1, (char *) tmp0);
	if (strlen((const char *) tmp1) +
	strlen((const char *) ",old") + 1 
	> STR_MAX)
	ErrorMessage("String too long", svPtr->LineNumber);
	strmove( (UNS) tmp2, (UNS) tmp1);
	strcat( (char *) tmp2, (char *) ",old");
	strmove((UNS) tmp0, (UNS) tmp2);
	for(_j=0; tmp0[_j]!=0 && tmp0[_j]!=',';_j++);
	if (tmp0[_j]!=',') ErrorMessage("File open error",svPtr->LineNumber);
	tmp0[_j++]=0;
	strmove((UNS) gtmp, (UNS) tmp0);
	if (strcmp( (CCHR) &tmp0[_j], (CCHR) "old") == 0 || 
		strcmp( (CCHR) &tmp0[_j], (CCHR) "OLD") == 0) _new = 0; 
	else if (strcmp( (CCHR) &tmp0[_j], (CCHR) "new") == 0 || 
		strcmp((CCHR) &tmp0[_j], (CCHR) "NEW") == 0) _new = 1; 
	else if (strcmp( (CCHR) &tmp0[_j], (CCHR) "append") == 0 || 
		strcmp( (CCHR) &tmp0[_j], (const char *) "APPEND") == 0) _new=2; 
	else ErrorMessage("File open error",svPtr->LineNumber);
	if (svPtr->out_file[_i] != NULL || svPtr->in_file[_i] != NULL) 
		ErrorMessage("File already open", svPtr->LineNumber); 
	if (_new==1) { /* output */ 
		svPtr->out_file[_i] = fopen((const char *) gtmp, "w"); 
		if(svPtr->out_file[_i] == NULL) svPtr->tpx = 0; 
		else svPtr->tpx = 1; 
		} 
	else if (_new == 2) { /* append */ 
		svPtr->out_file[_i] = fopen((const char *) gtmp, "a"); 
		if(svPtr->out_file[_i] == NULL) svPtr->tpx = 0; 
		else svPtr->tpx = 1; 
		} 
	else { /* input */ 
		svPtr->in_file[_i] = fopen((const char *) gtmp, "r"); 
		if(svPtr->in_file[_i] == NULL) svPtr->tpx = 0; 
		else svPtr->tpx = 1; 
		}

//================================================================================= 
svPtr->LineNumber=71; //       use 5 
//================================================================================= 

//--------------
//       Use
//--------------

	svPtr->io=atoi( CSTR "5");

//================================================================================= 
svPtr->LineNumber=73; //  open 2:"full.seq,old" 
//================================================================================= 

//--------------
//       Open
//--------------

	_i = atoi( CSTR "2");
	strmove((UNS) tmp0, (UNS) "full.seq,old");
	for(_j=0; tmp0[_j]!=0 && tmp0[_j]!=',';_j++);
	if (tmp0[_j]!=',') ErrorMessage("File open error",svPtr->LineNumber);
	tmp0[_j++]=0;
	strmove((UNS) gtmp, (UNS) tmp0);
	if (strcmp( (CCHR) &tmp0[_j], (CCHR) "old") == 0 || 
		strcmp( (CCHR) &tmp0[_j], (CCHR) "OLD") == 0) _new = 0; 
	else if (strcmp( (CCHR) &tmp0[_j], (CCHR) "new") == 0 || 
		strcmp((CCHR) &tmp0[_j], (CCHR) "NEW") == 0) _new = 1; 
	else if (strcmp( (CCHR) &tmp0[_j], (CCHR) "append") == 0 || 
		strcmp( (CCHR) &tmp0[_j], (const char *) "APPEND") == 0) _new=2; 
	else ErrorMessage("File open error",svPtr->LineNumber);
	if (svPtr->out_file[_i] != NULL || svPtr->in_file[_i] != NULL) 
		ErrorMessage("File already open", svPtr->LineNumber); 
	if (_new==1) { /* output */ 
		svPtr->out_file[_i] = fopen((const char *) gtmp, "w"); 
		if(svPtr->out_file[_i] == NULL) svPtr->tpx = 0; 
		else svPtr->tpx = 1; 
		} 
	else if (_new == 2) { /* append */ 
		svPtr->out_file[_i] = fopen((const char *) gtmp, "a"); 
		if(svPtr->out_file[_i] == NULL) svPtr->tpx = 0; 
		else svPtr->tpx = 1; 
		} 
	else { /* input */ 
		svPtr->in_file[_i] = fopen((const char *) gtmp, "r"); 
		if(svPtr->in_file[_i] == NULL) svPtr->tpx = 0; 
		else svPtr->tpx = 1; 
		}

//================================================================================= 
svPtr->LineNumber=74; //  use 2 read full close 2 
//================================================================================= 

//--------------
//       Use
//--------------

	svPtr->io=atoi( CSTR "2");

//--------------
//       Read
//--------------

	if (svPtr->in_file[svPtr->io] == NULL) 
		ErrorMessage("Read from input file", svPtr->LineNumber); 
	svPtr->tpx = getstr1(svPtr->in_file[svPtr->io], &gtmp); // Read string into gtmp
	if (svPtr->tpx >= 0) svPtr->tpx = 1; else svPtr->tpx = 0; // Set $Test
	sym_(SYMSTORE, (UNS) "full", (UNS) gtmp, svPtr); // Store result s274 

//--------------
//       Close
//--------------

	_i=atoi( CSTR "2");
	if (svPtr->in_file[_i] == NULL && svPtr->out_file[_i] == NULL) 
		ErrorMessage("Attempt to close unopened file", svPtr->LineNumber); 
	if (svPtr->in_file[_i]!=NULL) { 
	fclose(svPtr->in_file[_i]); svPtr->in_file[_i]=NULL; }
	else { fclose(svPtr->out_file[_i]); svPtr->out_file[_i]=NULL; }

//================================================================================= 
svPtr->LineNumber=75; //  use 5 
//================================================================================= 

//--------------
//       Use
//--------------

	svPtr->io=atoi( CSTR "5");

//================================================================================= 
svPtr->LineNumber=77; //  open 3:"db.stemmed,old" 
//================================================================================= 

//--------------
//       Open
//--------------

	_i = atoi( CSTR "3");
	strmove((UNS) tmp0, (UNS) "db.stemmed,old");
	for(_j=0; tmp0[_j]!=0 && tmp0[_j]!=',';_j++);
	if (tmp0[_j]!=',') ErrorMessage("File open error",svPtr->LineNumber);
	tmp0[_j++]=0;
	strmove((UNS) gtmp, (UNS) tmp0);
	if (strcmp( (CCHR) &tmp0[_j], (CCHR) "old") == 0 || 
		strcmp( (CCHR) &tmp0[_j], (CCHR) "OLD") == 0) _new = 0; 
	else if (strcmp( (CCHR) &tmp0[_j], (CCHR) "new") == 0 || 
		strcmp((CCHR) &tmp0[_j], (CCHR) "NEW") == 0) _new = 1; 
	else if (strcmp( (CCHR) &tmp0[_j], (CCHR) "append") == 0 || 
		strcmp( (CCHR) &tmp0[_j], (const char *) "APPEND") == 0) _new=2; 
	else ErrorMessage("File open error",svPtr->LineNumber);
	if (svPtr->out_file[_i] != NULL || svPtr->in_file[_i] != NULL) 
		ErrorMessage("File already open", svPtr->LineNumber); 
	if (_new==1) { /* output */ 
		svPtr->out_file[_i] = fopen((const char *) gtmp, "w"); 
		if(svPtr->out_file[_i] == NULL) svPtr->tpx = 0; 
		else svPtr->tpx = 1; 
		} 
	else if (_new == 2) { /* append */ 
		svPtr->out_file[_i] = fopen((const char *) gtmp, "a"); 
		if(svPtr->out_file[_i] == NULL) svPtr->tpx = 0; 
		else svPtr->tpx = 1; 
		} 
	else { /* input */ 
		svPtr->in_file[_i] = fopen((const char *) gtmp, "r"); 
		if(svPtr->in_file[_i] == NULL) svPtr->tpx = 0; 
		else svPtr->tpx = 1; 
		}

//================================================================================= 
svPtr->LineNumber=79; //       write f," sequences found.",!! 
//================================================================================= 

//--------------
//       Write
//--------------

	if (svPtr->out_file[svPtr->io]==NULL) 
		ErrorMessage("Write to input file", svPtr->LineNumber); // m1944 
	if (sym_(SYMGET, (UNS) "f", (UNS) tmp0, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "f"); // not found
	svPtr->hor[svPtr->io] += fprintf(svPtr->out_file[svPtr->io], "%s", 
		tmp0);
	svPtr->hor[svPtr->io] += fprintf(svPtr->out_file[svPtr->io], "%s", 
		" sequences found.");
	fprintf(svPtr->out_file[svPtr->io], "\n"); 
	svPtr->hor[svPtr->io]=0; svPtr->ver[svPtr->io]++; 
	fprintf(svPtr->out_file[svPtr->io], "\n"); 
	svPtr->hor[svPtr->io]=0; svPtr->ver[svPtr->io]++; 

//================================================================================= 
svPtr->LineNumber=80; //       write "   Doc Rel   Title",! 
//================================================================================= 

//--------------
//       Write
//--------------

	if (svPtr->out_file[svPtr->io]==NULL) 
		ErrorMessage("Write to input file", svPtr->LineNumber); // m1944 
	svPtr->hor[svPtr->io] += fprintf(svPtr->out_file[svPtr->io], "%s", 
		"   Doc Rel   Title");
	fprintf(svPtr->out_file[svPtr->io], "\n"); 
	svPtr->hor[svPtr->io]=0; svPtr->ver[svPtr->io]++; 

//================================================================================= 
svPtr->LineNumber=82; //       for i=1:1:10 do   // display loop 
//================================================================================= 

//--------------
//       For
//--------------

	strcpy(for9_lim, "");
	strmove((UNS) for9_init, (UNS) "1"); // init value m2534
	strmove( (UNS) for9_incr, (UNS) "1"); // inc/dec m2575
	strmove((UNS) for9_lim, (UNS) "10"); // limit value

	if (strchr((char *) for9_incr, '.')) // inc/dec is float
		for9F = atof(for9_incr) < 0.0 ? 1 : 0; // incr or decr?
	else // inc/dec is integer
		for9F = atol(for9_incr) < 0 ? 1 : 0; // incr or decr?

	for ( sym_(SYMSTORE, (UNS) "i", (UNS) for9_init, svPtr); // init 2618

		for9F ? // loop limit test direction
			numcomp((UNS) sym_(11, (UNS) "i", 
				 _dummy, svPtr),
				(UNS) for9_lim) >= 0 // GE limit value?
			: // ternary operator
			numcomp((UNS) sym_(11, (UNS) "i", 
				_dummy,svPtr),
				(UNS) for9_lim) <= 0; // LE limit value

		add( sym_(11, (UNS) "i", _dummy, svPtr), // inc/dec loop var
			for9_incr, (char *) _dummy),
		sym_(SYMSTORE, (UNS) "i", (UNS) _dummy, svPtr) ) // store rslt

		if ((_i = setjmp(for9J)) == 0) goto For9; // else continue

	else if (_i == 100) goto For9Exit; // f273

	goto For9Exit; // bypass block 

For9: // for loop body entry point B

	do { // for loop body
		svPtr->LineNumber = 82; 

//--------------
//       Do
//--------------

		tpx4 = svPtr->tpx; 
		if ( (_i = setjmp(Efor4J)) == 0) goto Do_Block_Entry4; //else continue 
		else if (_i == 100) goto Do_Block_Bypass4; // IF_flg m1402
	} while (0); longjmp(for9J, _i); // FOR loop 1 close 

For9Exit: ; // exit for loop 

	goto Do_Block_Bypass4; // C3551 bypass indented group

//-------------------------------------
Do_Block_Entry4:; // Enter Do Block
//-------------------------------------

do { /* dotted indent entry */

//================================================================================= 
svPtr->LineNumber=83; //       . use 1 read a 
//================================================================================= 

//--------------
//       Use
//--------------

	svPtr->io=atoi( CSTR "1");

//--------------
//       Read
//--------------

	if (svPtr->in_file[svPtr->io] == NULL) 
		ErrorMessage("Read from input file", svPtr->LineNumber); 
	svPtr->tpx = getstr1(svPtr->in_file[svPtr->io], &gtmp); // Read string into gtmp
	if (svPtr->tpx >= 0) svPtr->tpx = 1; else svPtr->tpx = 0; // Set $Test
	sym_(SYMSTORE, (UNS) "a", (UNS) gtmp, svPtr); // Store result s274 

//================================================================================= 
svPtr->LineNumber=84; //       . if '$test break 
//================================================================================= 

//--------------
//       If
//--------------

	if (svPtr->tpx) tmp0[0]='1'; /* $test */
	else tmp0[0]='0';
	tmp0[1]='\0';
	if (numcomp1( (UNS) tmp0, 0) == 0) 
		strmove( (UNS) tmp1, (UNS) "1");
	else strmove( (UNS) tmp1, (UNS) "0");
	svPtr->tpx = 0; //Default $Test indicator
	if (numcomp2((UNS) tmp1 )) { // Test if true 
	svPtr->tpx = 1; // $test becomes true

//--------------
//       Break
//--------------

     svPtr->tpx=tpx4; // break code: restore $test
  longjmp(Efor4J,100); 
	} 

//================================================================================= 
svPtr->LineNumber=85; //       . set d=$piece(a," ",2) 
//================================================================================= 

//--------------
//       Set
//--------------

	if (sym_(SYMGET, (UNS) "a", (UNS) tmp1, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "a"); // not found
	_piece((UNS) tmp2, 
		(UNS) tmp1,(UNS) " ",(UNS) "2", (UNS) "-1", 
		0, (UNS) "", svPtr); // p1136
	sym_(SYMSTORE, (UNS) "d", (UNS) tmp2, svPtr); // Store result s274 

//================================================================================= 
svPtr->LineNumber=86; //  . set off=^doc(d) 
//================================================================================= 

//--------------
//       Set
//--------------

	strmove((UNS) tmp2, (UNS) "^doc\x01"); // init p674
	if (sym_(SYMGET, (UNS) "d", (UNS) tmp1, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "d"); // not found
	strcatx((UNS) tmp2, (UNS) tmp1);
	if (!Mglobal(RETRIEVE, tmp2, tmp3, svPtr)) // retrieve global
		VariableNotFound(svPtr->LineNumber, tmp2);
	sym_(SYMSTORE, (UNS) "off", (UNS) tmp3, svPtr); // Store result s274 

//================================================================================= 
svPtr->LineNumber=87; //       . set c=$piece(a," ",1) 
//================================================================================= 

//--------------
//       Set
//--------------

	if (sym_(SYMGET, (UNS) "a", (UNS) tmp1, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "a"); // not found
	_piece((UNS) tmp2, 
		(UNS) tmp1,(UNS) " ",(UNS) "1", (UNS) "-1", 
		0, (UNS) "", svPtr); // p1136
	sym_(SYMSTORE, (UNS) "c", (UNS) tmp2, svPtr); // Store result s274 

//================================================================================= 
svPtr->LineNumber=88; //       . open 4:"tmp,new" use 4 write "###",!,$justify(d,6)," ",c," ",$e(^title(d),1,70)," ...",! 
//================================================================================= 

//--------------
//       Open
//--------------

	_i = atoi( CSTR "4");
	strmove((UNS) tmp0, (UNS) "tmp,new");
	for(_j=0; tmp0[_j]!=0 && tmp0[_j]!=',';_j++);
	if (tmp0[_j]!=',') ErrorMessage("File open error",svPtr->LineNumber);
	tmp0[_j++]=0;
	strmove((UNS) gtmp, (UNS) tmp0);
	if (strcmp( (CCHR) &tmp0[_j], (CCHR) "old") == 0 || 
		strcmp( (CCHR) &tmp0[_j], (CCHR) "OLD") == 0) _new = 0; 
	else if (strcmp( (CCHR) &tmp0[_j], (CCHR) "new") == 0 || 
		strcmp((CCHR) &tmp0[_j], (CCHR) "NEW") == 0) _new = 1; 
	else if (strcmp( (CCHR) &tmp0[_j], (CCHR) "append") == 0 || 
		strcmp( (CCHR) &tmp0[_j], (const char *) "APPEND") == 0) _new=2; 
	else ErrorMessage("File open error",svPtr->LineNumber);
	if (svPtr->out_file[_i] != NULL || svPtr->in_file[_i] != NULL) 
		ErrorMessage("File already open", svPtr->LineNumber); 
	if (_new==1) { /* output */ 
		svPtr->out_file[_i] = fopen((const char *) gtmp, "w"); 
		if(svPtr->out_file[_i] == NULL) svPtr->tpx = 0; 
		else svPtr->tpx = 1; 
		} 
	else if (_new == 2) { /* append */ 
		svPtr->out_file[_i] = fopen((const char *) gtmp, "a"); 
		if(svPtr->out_file[_i] == NULL) svPtr->tpx = 0; 
		else svPtr->tpx = 1; 
		} 
	else { /* input */ 
		svPtr->in_file[_i] = fopen((const char *) gtmp, "r"); 
		if(svPtr->in_file[_i] == NULL) svPtr->tpx = 0; 
		else svPtr->tpx = 1; 
		}

//--------------
//       Use
//--------------

	svPtr->io=atoi( CSTR "4");

//--------------
//       Write
//--------------

	if (svPtr->out_file[svPtr->io]==NULL) 
		ErrorMessage("Write to input file", svPtr->LineNumber); // m1944 
	svPtr->hor[svPtr->io] += fprintf(svPtr->out_file[svPtr->io], "%s", 
		"###");
	fprintf(svPtr->out_file[svPtr->io], "\n"); 
	svPtr->hor[svPtr->io]=0; svPtr->ver[svPtr->io]++; 
	if (sym_(SYMGET, (UNS) "d", (UNS) tmp0, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "d"); // not found
	_justify( (UNS) tmp1, (UNS) tmp0, (UNS)"6", (UNS) "-1");
	svPtr->hor[svPtr->io] += fprintf(svPtr->out_file[svPtr->io], "%s", 
		tmp1);
	svPtr->hor[svPtr->io] += fprintf(svPtr->out_file[svPtr->io], "%s", 
		" ");
	if (sym_(SYMGET, (UNS) "c", (UNS) tmp2, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "c"); // not found
	svPtr->hor[svPtr->io] += fprintf(svPtr->out_file[svPtr->io], "%s", 
		tmp2);
	svPtr->hor[svPtr->io] += fprintf(svPtr->out_file[svPtr->io], "%s", 
		" ");
	strmove((UNS) tmp4, (UNS) "^title\x01"); // init p674
	if (sym_(SYMGET, (UNS) "d", (UNS) tmp3, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "d"); // not found
	strcatx((UNS) tmp4, (UNS) tmp3);
	if (!Mglobal(RETRIEVE, tmp4, tmp5, svPtr)) // retrieve global
		VariableNotFound(svPtr->LineNumber, tmp4);
	_extract( (UNS) tmp6,
 		(UNS) tmp5, (UNS) "1", (UNS) "70"); // p2493
	svPtr->hor[svPtr->io] += fprintf(svPtr->out_file[svPtr->io], "%s", 
		tmp6);
	svPtr->hor[svPtr->io] += fprintf(svPtr->out_file[svPtr->io], "%s", 
		" ...");
	fprintf(svPtr->out_file[svPtr->io], "\n"); 
	svPtr->hor[svPtr->io]=0; svPtr->ver[svPtr->io]++; 

//================================================================================= 
svPtr->LineNumber=89; //       . write ?14,"matched keys: " 
//================================================================================= 

//--------------
//       Write
//--------------

	if (svPtr->out_file[svPtr->io]==NULL) 
		ErrorMessage("Write to input file", svPtr->LineNumber); // m1944 
	 _Column(&svPtr->hor[svPtr->io], &svPtr->ver[svPtr->io], 
"14", svPtr->out_file[svPtr->io]); // tab operator
	svPtr->hor[svPtr->io] += fprintf(svPtr->out_file[svPtr->io], "%s", 
		"matched keys: ");

//================================================================================= 
svPtr->LineNumber=90; //       . for w=$order(^doc(d,w)) do 
//================================================================================= 

//--------------
//       For
//--------------

	strcpy(for11_lim, "");
	sym_(SYMSTORE, (UNS) "w", (UNS) "", svPtr); // init $ case 2518 

For_Group11: // m2522

	strmove((UNS) tmp2, (UNS) "^doc\x01"); // init p674
	if (sym_(SYMGET, (UNS) "d", (UNS) tmp0, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "d"); // not found
	strcatx((UNS) tmp2, (UNS) tmp0);
	if (sym_(SYMGET, (UNS) "w", (UNS) tmp1, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "w"); // not found
	strcatx((UNS) tmp2, (UNS) tmp1);
	GlobalOrder((unsigned char *) tmp2, (unsigned char *) tmp3, 
		(unsigned char *) NULL, svPtr); // p2236
	sym_(SYMSTORE, (UNS) "w", (UNS) tmp3, svPtr); // set loop variable m2752
	if (strlen( (const char *) tmp3) == 0 ) goto For11Exit; // exit if empty 2758
	if ( setjmp( for11J ) == 0 ) goto For11; 
	goto For_Group11; // m2771
	goto For11Exit; // bypass block 

For11: // for loop body entry point B

	do { // for loop body
		svPtr->LineNumber = 90; 

//--------------
//       Do
//--------------

		tpx5 = svPtr->tpx; 
		if ( (_i = setjmp(Efor5J)) == 0) goto Do_Block_Entry5; //else continue 
		else if (_i == 100) goto Do_Block_Bypass5; // IF_flg m1402
	} while (0); longjmp(for11J, _i); // FOR loop 1 close 

For11Exit: ; // exit for loop 

	goto Do_Block_Bypass5; // C3551 bypass indented group

//-------------------------------------
Do_Block_Entry5:; // Enter Do Block
//-------------------------------------

do { /* dotted indent entry */

//================================================================================= 
svPtr->LineNumber=91; //       .. if $data(^query(w)) do 
//================================================================================= 

//--------------
//       If
//--------------

	strmove((UNS) tmp1, (UNS) "^query\x01"); // init p674
	if (sym_(SYMGET, (UNS) "w", (UNS) tmp0, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "w"); // not found
	strcatx((UNS) tmp1, (UNS) tmp0);
	GlobalData(tmp1,tmp2,svPtr);
	svPtr->tpx = 0; //Default $Test indicator
	if (numcomp2((UNS) tmp2 )) { // Test if true 
	svPtr->tpx = 1; // $test becomes true

//--------------
//       Do
//--------------

		tpx6 = svPtr->tpx; 
		if ( (_i = setjmp(Efor6J)) == 0) goto Do_Block_Entry6; //else continue 
		else if (_i == 100) goto Do_Block_Bypass6; // IF_flg m1402
	} 
	goto Do_Block_Bypass6; // C3551 bypass indented group

//-------------------------------------
Do_Block_Entry6:; // Enter Do Block
//-------------------------------------

do { /* dotted indent entry */

//================================================================================= 
svPtr->LineNumber=92; //       ... write "*",w," " 
//================================================================================= 

//--------------
//       Write
//--------------

	if (svPtr->out_file[svPtr->io]==NULL) 
		ErrorMessage("Write to input file", svPtr->LineNumber); // m1944 
	svPtr->hor[svPtr->io] += fprintf(svPtr->out_file[svPtr->io], "%s", 
		"*");
	if (sym_(SYMGET, (UNS) "w", (UNS) tmp0, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "w"); // not found
	svPtr->hor[svPtr->io] += fprintf(svPtr->out_file[svPtr->io], "%s", 
		tmp0);
	svPtr->hor[svPtr->io] += fprintf(svPtr->out_file[svPtr->io], "%s", 
		" ");
	} while (0); /* dotted un-indent 2 */
	longjmp(Efor6J,99); /* return */

	Do_Block_Bypass6: ; // D3607 
	} while (0); /* dotted un-indent 1 */
	longjmp(Efor5J,99); /* return */

	Do_Block_Bypass5: ; // D3607 

//================================================================================= 
svPtr->LineNumber=93; //  . set gen="" 
//================================================================================= 

//--------------
//       Set
//--------------

	sym_(SYMSTORE, (UNS) "gen", (UNS) "", svPtr); // Store result s274 

//================================================================================= 
svPtr->LineNumber=94; //  . write ! 
//================================================================================= 

//--------------
//       Write
//--------------

	if (svPtr->out_file[svPtr->io]==NULL) 
		ErrorMessage("Write to input file", svPtr->LineNumber); // m1944 
	fprintf(svPtr->out_file[svPtr->io], "\n"); 
	svPtr->hor[svPtr->io]=0; svPtr->ver[svPtr->io]++; 

//================================================================================= 
svPtr->LineNumber=95; //  . use 3 
//================================================================================= 

//--------------
//       Use
//--------------

	svPtr->io=atoi( CSTR "3");

//================================================================================= 
svPtr->LineNumber=96; //  . set %=$zseek(off) 
//================================================================================= 

//--------------
//       Set
//--------------

	strmove( (UNS) &gtmp[1], (UNS) "");
	catx = strxcat((char *) &gtmp[1],"$zseek\xce");
	if (sym_(SYMGET, (UNS) "off", (UNS) tmp1, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "off"); // not found
	strxcat((char *) catx ,(char *) tmp1);
	strxcat((char *) catx,"\xcf");
	zfcn(gtmp,tmp2,svPtr);
	sym_(SYMSTORE, (UNS) "%", (UNS) tmp2, svPtr); // Store result s274 

//================================================================================= 
svPtr->LineNumber=97; //  . read seq 
//================================================================================= 

//--------------
//       Read
//--------------

	if (svPtr->in_file[svPtr->io] == NULL) 
		ErrorMessage("Read from input file", svPtr->LineNumber); 
	svPtr->tpx = getstr1(svPtr->in_file[svPtr->io], &gtmp); // Read string into gtmp
	if (svPtr->tpx >= 0) svPtr->tpx = 1; else svPtr->tpx = 0; // Set $Test
	sym_(SYMSTORE, (UNS) "seq", (UNS) gtmp, svPtr); // Store result s274 

//================================================================================= 
svPtr->LineNumber=98; //  . for ii=1:1:$l(seq) do 
//================================================================================= 

//--------------
//       For
//--------------

	strcpy(for14_lim, "");
	strmove((UNS) for14_init, (UNS) "1"); // init value m2534
	strmove( (UNS) for14_incr, (UNS) "1"); // inc/dec m2575
	if (sym_(SYMGET, (UNS) "seq", (UNS) tmp0, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "seq"); // not found
	_length((UNS) tmp1, (UNS) tmp0, (UNS) "");
	strmove((UNS) for14_lim, (UNS) tmp1); // limit value

	if (strchr((char *) for14_incr, '.')) // inc/dec is float
		for14F = atof(for14_incr) < 0.0 ? 1 : 0; // incr or decr?
	else // inc/dec is integer
		for14F = atol(for14_incr) < 0 ? 1 : 0; // incr or decr?

	for ( sym_(SYMSTORE, (UNS) "ii", (UNS) for14_init, svPtr); // init 2618

		for14F ? // loop limit test direction
			numcomp((UNS) sym_(11, (UNS) "ii", 
				 _dummy, svPtr),
				(UNS) for14_lim) >= 0 // GE limit value?
			: // ternary operator
			numcomp((UNS) sym_(11, (UNS) "ii", 
				_dummy,svPtr),
				(UNS) for14_lim) <= 0; // LE limit value

		add( sym_(11, (UNS) "ii", _dummy, svPtr), // inc/dec loop var
			for14_incr, (char *) _dummy),
		sym_(SYMSTORE, (UNS) "ii", (UNS) _dummy, svPtr) ) // store rslt

		if ((_i = setjmp(for14J)) == 0) goto For14; // else continue

	else if (_i == 100) goto For14Exit; // f273

	goto For14Exit; // bypass block 

For14: // for loop body entry point B

	do { // for loop body
		svPtr->LineNumber = 98; 

//--------------
//       Do
//--------------

		tpx7 = svPtr->tpx; 
		if ( (_i = setjmp(Efor7J)) == 0) goto Do_Block_Entry7; //else continue 
		else if (_i == 100) goto Do_Block_Bypass7; // IF_flg m1402
	} while (0); longjmp(for14J, _i); // FOR loop 1 close 

For14Exit: ; // exit for loop 

	goto Do_Block_Bypass7; // C3551 bypass indented group

//-------------------------------------
Do_Block_Entry7:; // Enter Do Block
//-------------------------------------

do { /* dotted indent entry */

//================================================================================= 
svPtr->LineNumber=99; //  .. set x=$e(seq,ii) 
//================================================================================= 

//--------------
//       Set
//--------------

	if (sym_(SYMGET, (UNS) "seq", (UNS) tmp1, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "seq"); // not found
	if (sym_(SYMGET, (UNS) "ii", (UNS) tmp2, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "ii"); // not found
	_extract( (UNS) tmp3,
 		(UNS) tmp1, (UNS) tmp2, (UNS) "-1"); // p2493
	sym_(SYMSTORE, (UNS) "x", (UNS) tmp3, svPtr); // Store result s274 

//================================================================================= 
svPtr->LineNumber=100; //  .. if x=" " quit 
//================================================================================= 

//--------------
//       If
//--------------

	if (sym_(SYMGET, (UNS) "x", (UNS) tmp0, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "x"); // not found
	if (strcmp((const char *) tmp0,(const char *) " ")==0) 
	strmove( (UNS) tmp1, (UNS) "1");
	else strmove( (UNS) tmp1, (UNS) "0");
	svPtr->tpx = 0; //Default $Test indicator
	if (numcomp2((UNS) tmp1 )) { // Test if true 
	svPtr->tpx = 1; // $test becomes true

//--------------
//       Quit
//--------------

	break; 
	} // if block 2389

//================================================================================= 
svPtr->LineNumber=101; //  .. set gen=gen_x 
//================================================================================= 

//--------------
//       Set
//--------------

	if (sym_(SYMGET, (UNS) "gen", (UNS) tmp1, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "gen"); // not found
	if (sym_(SYMGET, (UNS) "x", (UNS) tmp2, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "x"); // not found
	if (strlen((const char *) tmp1) +
	strlen((const char *) tmp2) + 1 
	> STR_MAX)
	ErrorMessage("String too long", svPtr->LineNumber);
	strmove( (UNS) tmp3, (UNS) tmp1);
	strcat( (char *) tmp3, (char *) tmp2);
	sym_(SYMSTORE, (UNS) "gen", (UNS) tmp3, svPtr); // Store result s274 
	} while (0); /* dotted un-indent 1 */
	longjmp(Efor7J,99); /* return */

	Do_Block_Bypass7: ; // D3607 

//================================================================================= 
svPtr->LineNumber=102; //  . use 4 write ! 
//================================================================================= 

//--------------
//       Use
//--------------

	svPtr->io=atoi( CSTR "4");

//--------------
//       Write
//--------------

	if (svPtr->out_file[svPtr->io]==NULL) 
		ErrorMessage("Write to input file", svPtr->LineNumber); // m1944 
	fprintf(svPtr->out_file[svPtr->io], "\n"); 
	svPtr->hor[svPtr->io]=0; svPtr->ver[svPtr->io]++; 

//================================================================================= 
svPtr->LineNumber=103; //  . set %=$zSmithWaterman(full,gen,1,0,-1,-1,2) 
//================================================================================= 

//--------------
//       Set
//--------------

	mult((char *) "1","-1",(char *) tmp3);
	mult((char *) "1","-1",(char *) tmp4);
	strmove( (UNS) &gtmp[1], (UNS) "");
	catx = strxcat((char *) &gtmp[1],"$zSmithWaterman\xce");
	if (sym_(SYMGET, (UNS) "full", (UNS) tmp1, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "full"); // not found
	strxcat((char *) catx ,(char *) tmp1);
	strxcat((char *) catx,"\xd0");
	if (sym_(SYMGET, (UNS) "gen", (UNS) tmp2, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "gen"); // not found
	strxcat((char *) catx ,(char *) tmp2);
	strxcat((char *) catx,"\xd0");
	strxcat((char *) catx ,(char *) "1");
	strxcat((char *) catx,"\xd0");
	strxcat((char *) catx ,(char *) "0");
	strxcat((char *) catx,"\xd0");
	strxcat((char *) catx ,(char *) tmp3);
	strxcat((char *) catx,"\xd0");
	strxcat((char *) catx ,(char *) tmp4);
	strxcat((char *) catx,"\xd0");
	strxcat((char *) catx ,(char *) "2");
	strxcat((char *) catx,"\xcf");
	zfcn(gtmp,tmp5,svPtr);
	sym_(SYMSTORE, (UNS) "%", (UNS) tmp5, svPtr); // Store result s274 

//================================================================================= 
svPtr->LineNumber=104; //  . write " Score = ",%,!! 
//================================================================================= 

//--------------
//       Write
//--------------

	if (svPtr->out_file[svPtr->io]==NULL) 
		ErrorMessage("Write to input file", svPtr->LineNumber); // m1944 
	svPtr->hor[svPtr->io] += fprintf(svPtr->out_file[svPtr->io], "%s", 
		" Score = ");
	if (sym_(SYMGET, (UNS) "%", (UNS) tmp0, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "%"); // not found
	svPtr->hor[svPtr->io] += fprintf(svPtr->out_file[svPtr->io], "%s", 
		tmp0);
	fprintf(svPtr->out_file[svPtr->io], "\n"); 
	svPtr->hor[svPtr->io]=0; svPtr->ver[svPtr->io]++; 
	fprintf(svPtr->out_file[svPtr->io], "\n"); 
	svPtr->hor[svPtr->io]=0; svPtr->ver[svPtr->io]++; 

//================================================================================= 
svPtr->LineNumber=105; //  . close 4 
//================================================================================= 

//--------------
//       Close
//--------------

	_i=atoi( CSTR "4");
	if (svPtr->in_file[_i] == NULL && svPtr->out_file[_i] == NULL) 
		ErrorMessage("Attempt to close unopened file", svPtr->LineNumber); 
	if (svPtr->in_file[_i]!=NULL) { 
	fclose(svPtr->in_file[_i]); svPtr->in_file[_i]=NULL; }
	else { fclose(svPtr->out_file[_i]); svPtr->out_file[_i]=NULL; }

//================================================================================= 
svPtr->LineNumber=106; //  . set %%=$zsystem("mv tmp "_(1000+%)_".rslt") 
//================================================================================= 

//--------------
//       Set
//--------------

	if (sym_(SYMGET, (UNS) "%", (UNS) tmp1, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "%"); // not found
	add((char *) "1000", (char *) tmp1, (char *) tmp2); 
	if (strlen((const char *) "mv tmp ") +
	strlen((const char *) tmp2) + 1 
	> STR_MAX)
	ErrorMessage("String too long", svPtr->LineNumber);
	strmove( (UNS) tmp3, (UNS) "mv tmp ");
	strcat( (char *) tmp3, (char *) tmp2);
	if (strlen((const char *) tmp3) +
	strlen((const char *) ".rslt") + 1 
	> STR_MAX)
	ErrorMessage("String too long", svPtr->LineNumber);
	strmove( (UNS) tmp4, (UNS) tmp3);
	strcat( (char *) tmp4, (char *) ".rslt");
	strmove( (UNS) &gtmp[1], (UNS) "");
	catx = strxcat((char *) &gtmp[1],"$zsystem\xce");
	strxcat((char *) catx ,(char *) tmp4);
	strxcat((char *) catx,"\xcf");
	zfcn(gtmp,tmp5,svPtr);
	sym_(SYMSTORE, (UNS) "%%", (UNS) tmp5, svPtr); // Store result s274 
	} while(0); // dotted un-indent 0 
	longjmp(Efor4J,99); // return 

Do_Block_Bypass4: ; //B848 


//================================================================================= 
svPtr->LineNumber=108; //       use 5 
//================================================================================= 

//--------------
//       Use
//--------------

	svPtr->io=atoi( CSTR "5");

//================================================================================= 
svPtr->LineNumber=109; //       close 1 
//================================================================================= 

//--------------
//       Close
//--------------

	_i=atoi( CSTR "1");
	if (svPtr->in_file[_i] == NULL && svPtr->out_file[_i] == NULL) 
		ErrorMessage("Attempt to close unopened file", svPtr->LineNumber); 
	if (svPtr->in_file[_i]!=NULL) { 
	fclose(svPtr->in_file[_i]); svPtr->in_file[_i]=NULL; }
	else { fclose(svPtr->out_file[_i]); svPtr->out_file[_i]=NULL; }

//       write !,"*Time used: ",$zd1-time0," seconds",!

//       shell rm *.tmp

//================================================================================= 
svPtr->LineNumber=113; //  halt 
//================================================================================= 

//--------------
//       Halt
//--------------

	goto _epilogue; 

//=================================================================================
//	Entry Point stems(ws) + + + + + + + 

//=================================================================================
stems: 
svPtr->start[svPtr->_Sym] = NULL; 
_SymPush++; 
if (svPtr->_Sym > SYM_MAX) ErrorMessage("Too many function calls",svPtr->LineNumber); 
_doStackN[_doStx-1]=1; // flag to restore namespace 
	if (__Arg0!=NULL) sym_(100, (UNS) "ws", (UNS) __Arg0,svPtr); // Store Arguments EP1003 
	strcpy (svPtr->RefParm[0], "ws" ); // EP1004 
	if (_ArgCount < 1) ErrorMessage("Bad argument count", svPtr->LineNumber); 

//================================================================================= 
svPtr->LineNumber=115; // stems(ws) 
//================================================================================= 

//================================================================================= 
svPtr->LineNumber=116; //  for w3=$order(^stem(ws,w3)) write:$x>60 ?26 write w3," " 
//================================================================================= 

//--------------
//       For
//--------------

	strcpy(for16_lim, "");
	sym_(SYMSTORE, (UNS) "w3", (UNS) "", svPtr); // init $ case 2518 

For_Group16: // m2522

	strmove((UNS) tmp2, (UNS) "^stem\x01"); // init p674
	if (sym_(SYMGET, (UNS) "ws", (UNS) tmp0, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "ws"); // not found
	strcatx((UNS) tmp2, (UNS) tmp0);
	if (sym_(SYMGET, (UNS) "w3", (UNS) tmp1, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "w3"); // not found
	strcatx((UNS) tmp2, (UNS) tmp1);
	GlobalOrder((unsigned char *) tmp2, (unsigned char *) tmp3, 
		(unsigned char *) NULL, svPtr); // p2236
	sym_(SYMSTORE, (UNS) "w3", (UNS) tmp3, svPtr); // set loop variable m2752
	if (strlen( (const char *) tmp3) == 0 ) goto For16Exit; // exit if empty 2758
	if ( setjmp( for16J ) == 0 ) goto For16; 
	goto For_Group16; // m2771
	goto For16Exit; // bypass block 

For16: // for loop body entry point B

	do { // for loop body
		svPtr->LineNumber = 116; 
	sprintf((char *) tmp4,"%d",svPtr->hor[svPtr->io]); /* $x */
	if (numcomp1((UNS) tmp4, 60) > 0) strmove((UNS) tmp5, (UNS) "1");
	else strmove((UNS) tmp5, (UNS) "0");
	if (atoi( CSTR tmp5)) { // m859 postconditional

//--------------
//       Write
//--------------

	if (svPtr->out_file[svPtr->io]==NULL) 
		ErrorMessage("Write to input file", svPtr->LineNumber); // m1944 
	 _Column(&svPtr->hor[svPtr->io], &svPtr->ver[svPtr->io], 
"26", svPtr->out_file[svPtr->io]); // tab operator
	} /* post conditional 4092*/

//--------------
//       Write
//--------------

	if (svPtr->out_file[svPtr->io]==NULL) 
		ErrorMessage("Write to input file", svPtr->LineNumber); // m1944 
	if (sym_(SYMGET, (UNS) "w3", (UNS) tmp6, svPtr) == NULL) // get value 
		VariableNotFound1(svPtr->LineNumber, (UNS) "w3"); // not found
	svPtr->hor[svPtr->io] += fprintf(svPtr->out_file[svPtr->io], "%s", 
		tmp6);
	svPtr->hor[svPtr->io] += fprintf(svPtr->out_file[svPtr->io], "%s", 
		" ");
	} while (0); longjmp(for16J, _i); // FOR loop 1 close 

For16Exit: ; // exit for loop 


//================================================================================= 
svPtr->LineNumber=117; //  quit 
//================================================================================= 

//--------------
//       Quit
//--------------

	if (svPtr->Rargsx) { // call-by-reference? 
		int i; 
		unsigned char *tmp = new unsigned char[STR_MAX]; 
		for (i = 0; i < svPtr->Rargsx; i++) { 
		sym_(1, (UNS) svPtr->RefParm[i], (UNS) tmp,svPtr); 
		sym_(SYMSTORE, (UNS) svPtr->Rargs[i], (UNS) tmp, svPtr); 
		} 
		} 
	strmove((UNS) _ReturnVal, (UNS) ""); 
	if (_doStackN[_doStx]) {  _doStackN[_doStx] = 0; } // Q1001 
	if (_doStx > 0) { longjmp(_doStack[_doStx],99); } 
	else ErrorMessage("Too Many Quits", svPtr->LineNumber); 

//=================================================================================
_epilogue: tmp0[0]=0; tmp1[0]=0;  /*  Function Epilogue */
	Mltoa(getpid(),atmp);
	if (svPtr->LockDone) cleanLocks((char *) atmp);
	Mglobal(CLOSE,tmp0,tmp1,svPtr);  /* Close Globals */

} // end of try block 

catch(...) { 
     if (GlobalExceptionCode == INPUT_ERROR) cout << "Input Error" << endl;
     else if (GlobalExceptionCode == INPUT_LENGTH) cout << "Input Length Error" << endl;
     else if (GlobalExceptionCode == SYMTAB_ERROR) cout << "Symbol Table Error" << endl;
     else if (GlobalExceptionCode == GLOBAL_NOT_FOUND) cout << "Global Not Found Error" << endl;
     else if (GlobalExceptionCode == INTERPRETER_ERROR) cout << "Interprerer Error" << endl;
     else if (GlobalExceptionCode == INVALID_CONVERSION) cout << "Invalid Conversion Error" << endl;
     else if (GlobalExceptionCode == DATA_RANGE_ERROR) cout << "Data Range Error" << endl;
     else if (GlobalExceptionCode == NUMERIC_RANGE) cout << "Numeric Range Error" << endl;
     else if (GlobalExceptionCode == UNSPECIFIED) cout << "Unspecified Error" << endl;
	cout << "Uncaught error in or near line " 
	<< svPtr->LineNumber << endl;
	Mglobal(CLOSE,tmp0,tmp1,svPtr);  /* Close Globals */
	} 

return EXIT_SUCCESS; }  /* Terminate */
//=================================================================================


int _label_lookup(char *label) { return -1; }
const char * _text_function(int disp) { return NULL; }

