/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Mumps Bioinformatics Software Library
#+     Copyright (C) 2003, 2004, 2008, 2015, 2017,
#+     2022, 2024  by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     okane@uni.edu
#+     https://threadsafebooks.com/
#+     https://www.cs.uni.edu/~okane
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	May 10, 2024

#include <stdio.h>

#include <mumpsc/memsize.h>

#include <mumpsc/compiler-macros.h>

#include <mumpsc/compiler-globals-ext.h>

int     zcommands_code() {


      p2px++;
      if (xd[p2px] <= 90)
            xd[p2px] += 32;  //lower case

      if (xd[p2px] == 'n') {
            fprintf (Out, "	svPtr->gpad=1; // pad btree numeric subscript to the left\n");
            return NEXT_LINE; // goto next_line;
            }

      if (xd[p2px] == 'a') {
            fprintf (Out, "	svPtr->gpad=0; // nopad btree numeric subscript to the left\n");
            return NEXT_LINE; // goto next_line;
            }

      if (xd[p2px] == 'm') {  // ZMAIN subroutine

            if (MAIN_flg) {
                  printf ("*** in line %d Multiple Main programs\n", lines);
                  ExitCode = 99;
                  return ABRTX; // goto abrtx;
                  }

            else if (FCN_flg) {
                  EP(1,ExecName, pid);
                  F_flg = 0;
                  FCN_flg = 0;
                  }

            Sysout ( "\nint main(int argc, char *argv[]) {\n\n");

            cvarx=0;
            fcninit(output_file, pid);

            fprintf(Out, "__label_lookup = _label_lookup;\n");
            fprintf(Out, "__text_function = _text_function;\n\n");


            Sysout("$SymPut(\"%%\",argv[0]); \n\n");

            Sysout("if (argc > 0) { \n");
            Sysout("	for (int i = 0; i < argc; i++) { \n");
            Sysout("		char t[STR_MAX]; \n");
            Sysout("		sprintf(t,\"%%%%%%d\", i); \n");
            Sysout("		$SymPut(t, argv[i]); \n");
            Sysout("		} \n");
            Sysout("	} \n");

            fprintf(Out,"\ntry { \n");

            MAIN_flg = 1;

            return NEXT_LINE; // goto next_line;
            }

      if (xd[p2px] == 'f') { // function subroutine

            if (MAIN_flg) {
                  epi (ExecName, pid);
                  MAIN_flg = 0;
                  }

            else if (FCN_flg) {
                  fprintf (Out, "\n\n");
                  linepad (fprintf (Out, "	return EXIT_SUCCESS; }"), "Terminate Function");

                  fprintf( Out, "\n} // end of try block\n");
                  fprintf( Out, "	catch(...) { \n");

#include <mumpsc/errors.h>

                  fprintf( Out, "		cout << \"Uncaught error in or near line \" "
                           "<< svPtr->LineNumber << endl;\n");

                  linepad (fprintf (Out, "	Mglobal(CLOSE,tmp0,tmp1,svPtr);"), "Close Globals");
                  fprintf( Out, "		}\n");

                  FCN_flg = 0;
                  F_flg = 0;
                  Sysout (
                        "//=============================================================================\n\n");
                  }

            fprintf (Out, "char * %s() {\n\n", &xd[xpx]);
            Sysout ("//*** This module generated by Mumps Compiler ");
            Sysout ("\n");
            Sysout ("/*** This code is unverified - use at your own risk */\n\n");

            fcninit(output_file, pid);

            FCN_flg = 1;
            return NEXT_LINE; // goto next_line;
            }

      if (xd[p2px] == 'd') { // write remainder of line to output
            fprintf (Out, "	%s\n", &xd[xpx]);
            return NEXT_LINE; // goto next_line;
            }

      if (xd[p2px] == 'r') { // zreturn
            fprintf (Out, "	return %s;\n", &xd[xpx]);
            return NEXT_LINE; // goto next_line;
            }

      if (xd[p2px] == 's') { // zseek
            long i;
            t2 = 1;
            if ((ierr = parse_ ())) return PARSE_ERROR; // goto parse_err;
            i = atol (&pd1[sdlim]);
            return 0; // goto next_cmnd;
            }

      if (xd[p2px] == 'c') { // zclose
            linepad (fprintf (Out, "	tmp0[0]=0; tmp1[0]=0;"), "Function Epilogue");
            linepad (fprintf (Out, "	Mglobal(CLOSE,tmp0,tmp1,svPtr);"), "Close Globals");
            return 0; // goto next_cmnd;
            }

      if (xd[p2px] == 'e') { // zexit

            if (MAIN_flg) {
                  epi (ExecName, pid);
                  MAIN_flg = 0;
                  }
            else {
                  if (FCN_flg) {
                        EP(1,ExecName, pid);
                        F_flg = 0;
                        FCN_flg = 0;
                        }
                  else {
                        fprintf (Out, "\n\n/********************** Function Epilogue ********************/\n");
                        F_flg = 0;
                        fprintf (Out, "	_epilogue: return EXIT_SUCCESS\"\";\n}\n");
                        MAIN_flg = 0;
                        }
                  }
            }
      return 0; // goto next_cmnd;

      }
