/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018, 2019, 2020, 2021, 2022, 2023, 2024, 2025
#+     by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	February 2, 2025

#include "includes.h"
#include "defines.h"
#include "common-externs.h"
#include "common-fcn-headers.h"

#include <vlc/libvlc.h>
#include <vlc/libvlc_renderer_discoverer.h>
#include <vlc/libvlc_media.h>
#include <vlc/libvlc_media_player.h>

#define SLASH '/'

//---------------------------------------
//	Show message with Dismiss button
//---------------------------------------

void	zippy_says(char *msg) {

	static char zip[10000] = "";
	char msg1[16000];
	int j;

	if (strlen(msg) == 0) {
		zip[0] = 0;
		return;
		}

	strcpy(msg1, msg);

	if (strlen(msg1) > 80) {
		char msg3[16000];
		strcpy(msg3, msg1);
		msg3[80] = '\n';
		msg3[81] = 0;
		strcpy(&msg3[82], &msg1[80]);
		strcpy(msg1, msg3);
		}

	if (msg1[0] != '\n') {

		strncat(zip, msg1, 9999);

		j = strlen(zip);
		if (j > 1000) {
			strcpy(zip, &zip[j - 1000]);
			}

		TextBuffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW(dbox4_tv));

		GtkTextIter it;

		gtk_text_buffer_set_text (TextBuffer, zip, -1);

		gtk_window_set_title(GTK_WINDOW(g_dbox4),"Zippy Says");

		}

	if (strlen(msg) == 0) {
		printf("\m");
		}

	else {

		msg1[0] = '\n';
		strncpy(&msg1[1], msg, 15999);
		printf("zippy_says(): %s", msg);
		}

	if (strlen(msg) > 100 ) printf("\n");

	gtk_widget_show(g_dbox4);  // show dialog

	}

