/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018 - 2025 Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     okane@uni.edu
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	Julyy 5, 2025

#include "includes.h"
#include "defines.h"
#include "common-externs.h"
#include "common-fcn-headers.h"


#include <vlc/libvlc.h>
#include <vlc/libvlc_renderer_discoverer.h>
#include <vlc/libvlc_media.h>
#include <vlc/libvlc_media_player.h>

#define SLASH '/'

// ----------------------------------------------------------------
//	Window has been closed
//	Cleanup dependent windows
// ----------------------------------------------------------------

gboolean	on_window_main_delete_event(GtkWidget *w, GdkEvent *e) {
	}

void on_window_main_destroy() {

	char tmp[4096];

	sprintf(tmp, "rm -f \"%s/frames/\"*.jpg", Code_Home, tmp);
	printf("%s\n", tmp);
	system(tmp);

	sprintf(tmp, "rm -f %s/myimage1.jpg", Code_Home, tmp);
	printf("%s\n", tmp);
	system(tmp);
	sprintf(tmp, "rm -f %s/myimage2.jpg", Code_Home, tmp);
	printf("%s\n", tmp);
	system(tmp);
	sprintf(tmp, "rm -f %s/myimage3.jpg", Code_Home, tmp);
	printf("%s\n", tmp);
	system(tmp);
	sprintf(tmp, "rm -f %s/myimage4.jpg", Code_Home, tmp);
	printf("%s\n", tmp);
	system(tmp);

	sprintf(tmp, "rm -f \"%s/stills/\"* ", Music_Home_Directory);
	printf("%s\n", tmp);
	system(tmp);

//	save_program();

	system("pulseaudio --cleanup-shm");
	system("killall -q --signal SIGTERM vlc 2> /dev/null");
	system("killall -q --signal SIGTERM cam-bin 2> /dev/null");
	system("killall -q -s INT ffmpeg");
	system("killall -q -s INT ffplay");

	system("killall -q --signal SIGTERM sgr-zippy");

	gtk_main_quit();
	}


void	on_window_main_check_resize (GtkWidget *w) {
	return;
	}


gboolean	on_window_main_configure(GtkWindow *window, GdkEvent *event) {

	static int first = 3, last_width = 0, last_height = 0, last_x = 0, last_y = 0;
	int width1, width2, height1, height2;

	if (first) {
		first--;    // first few calls are meaningless
		return FALSE;
		}

//---------------------------
//	get current window
//---------------------------

	gtk_window_get_size (GTK_WINDOW(window), &width1, &height1);

	if (width1 < 1090) width1 = 1090; // min
	if (height1 < 610) height1 = 610; // min

//-------------------------------------------------------
//	no change in size - possible change in position
//-------------------------------------------------------

	if (last_width == width1 && last_height == height1) return FALSE;

	last_width = width1;
	last_height = height1;

	gtk_widget_show(fixed1);
	return FALSE;
	}

