/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018  - 2025
#+     by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	July 25, 2025

//------------------------------------------------------------------
//	This is the root file for the Linux version of the player
//------------------------------------------------------------------

#define _GNU_SOURCE

#include "includes.h"
#include "common-externs.h"
#define SLASH '/'

//extern GtkWidget *plug;	// socket video
//extern unsigned int sockId;	// socket video

//---------------------
//	Play a file
//---------------------

int	vlc_start() {

//--------------------------------------------
//	socket video interface
//--------------------------------------------
//
//
//	if (ft == MP4 || ft == DVD) {
//		mpv_socket_running = 1;
//		EmbedVideo();
//		return 1;
//		}
//--------------------------------------------

	/*	compressor interface does not work on the VLC side

		const char *argv1[] = {"--verbose=-2", "--height=188", "--width=334",
	            "--audio-filter=compressor",
	            "--compressor-rms-peak=5.00",
	            "--compressor-attack=24.00",
	            "--compressor-release=250.00",
	            "--compressor-threshold=-25.00",
	            "--compressor-ratio=2.00",
	            "--compressor-knee=4.50",
	            "--compressor-makeup-gain=17.00" };
	*/

//avcodec-hw=none - problems with older nvidia drivers

	const char *argv1[] = {"--verbose=-2", "--avcodec-hw=none"};
	int argc = 2;

	const char *argv[] = {"--no-video", "--verbose=0", "--avcodec-hw=none"};  // audio only

	int i;
	char tmp[2048];

	clip_start = 0;
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(full_speed), TRUE) ;
	advance_flg = 0;

	if ( strncmp(SP->playThis, "http:", 5) !=0 &&
	        strncmp(SP->playThis, "https:", 6) !=0 &&
	        strncmp(SP->playThis, "file:", 5) !=0 ) {
		// not a special file link

		if (SP->playThis == NULL ) {
			printf("*** file name null\n");
			return EXIT_FAILURE;
			}

		if (SP->playThis[0] != '/' ) {
			printf("*** File name does not begin with a / character\n\t%s\n",
			       SP->playThis);
			return EXIT_FAILURE;
			}

		if ( access(SP->playThis, R_OK) ) {   // returns non zero if bad
			printf("*** %s not found.\n", SP->playThis);
			return EXIT_FAILURE;
			}
		}

	if (inst) vlc_stop();

	int type = filetype(SP->playThis);

	if (type == GIF) {
		zippy_says("VLC player used by Zippy does not play GIF files.\n");
		return EXIT_FAILURE;
		}

	strcpy(SP->CurrentPlay, SP->playThis);
	DisplayProgramButtons();

//-----------------------
//	create an inst
//-----------------------

	if (!inst) {

		printf("New VLC instance created\n");

//-----------------------------
//		video setup
//-----------------------------

		if (SP->showVideo) {  // VIDEO

			inst = libvlc_new (argc, (const char * const *) argv1);

//---------------------------------------------------
//			display modules available
//---------------------------------------------------

			libvlc_module_description_t* vlc_mods = libvlc_video_filter_list_get(inst);

//--------------------------------------------------------------------------
//	uncomment to see video modules available
//--------------------------------------------------------------------------
//
//			printf("Video modules available \n");
//			while(vlc_mods != NULL) { // module list
//				printf("	modules available %s\n",
//					vlc_mods->psz_name);
//				vlc_mods = vlc_mods->p_next;
//				}
//
//--------------------------------------------------------------------------

			libvlc_module_description_list_release(vlc_mods);

			vlc_mods = libvlc_audio_filter_list_get(inst);

//--------------------------------------------------------------------------------
//	uncomment to se audio modules available
//--------------------------------------------------------------------------------
//
//			printf("Audio modules available \n");
//			while(vlc_mods != NULL) { // module list
//				printf("	modules available %s\n",
//					vlc_mods->psz_name);
//				vlc_mods = vlc_mods->p_next;
//				}
//
//--------------------------------------------------------------------------------

			libvlc_module_description_list_release(vlc_mods);
			}

//----------------------------------
//		audio only setup
//----------------------------------

		else {  // AUDIO ONLY

			inst = libvlc_new (2, (const char * const*) &argv);

//---------------------------------------------------
//			display modules available
//---------------------------------------------------

			libvlc_module_description_t* vlc_mods = libvlc_audio_filter_list_get(inst);

//-------------------------------------------------------------------------------------
//	Uncomment the following to see display of audio modules available
//-------------------------------------------------------------------------------------
//
//
//			printf("	Audio modules available \n");
//
//			while(vlc_mods != NULL) { // module list
//				printf("	modules available %s\n",
//					vlc_mods->psz_name);
//				vlc_mods = vlc_mods->p_next;
//				}
//
//-------------------------------------------------------------------------------------

			libvlc_module_description_list_release(vlc_mods);
			}

		}

	if (media) {
		libvlc_media_release (media);
		media = NULL;
		}

	else {

//-----------------------------------
//	regular file path reference
//	connect media to path
//-----------------------------------

//strcpy(SP->playThis, "https://threadsafebooks.com/ZippyHowToVids/01%20make-clip-from-a-larger-video.mp4");


		if ( strncmp(SP->playThis, "http:", 5) == 0 ||
		        strncmp(SP->playThis, "https:", 6) == 0)

#ifdef VLC4
			media = libvlc_media_new_location(SP->playThis);
		else  media = libvlc_media_new_path (SP->playThis);
#else
			media = libvlc_media_new_location(inst, SP->playThis);
		else  media = libvlc_media_new_path (inst, SP->playThis);
#endif
		}


//libvlc_media_new_location("https://threadsafebooks.com/ZippyHowToVids/01%20make-clip-from-a-larger-video.mp4");

	if (!media) {
		vlc_stop();    // fail
		return EXIT_FAILURE;
		}


//-------------------------------------------------
//	Create a media player playing environement
//-------------------------------------------------

	if (mediaPlayer) {
		libvlc_media_player_release (mediaPlayer);
		mediaPlayer = NULL;
		}

#ifdef VLC4
	mediaPlayer = libvlc_media_player_new_from_media (inst, media); // create media player
#else
	mediaPlayer = libvlc_media_player_new_from_media (media); // create media player
#endif

//	libvlc_video_set_mouse_input(mediaPlayer, 0); // attempt to capture mouse clicks - not working
//	libvlc_video_set_key_input(mediaPlayer, 0);

//--------------------------
//	show video?
//--------------------------

	gtk_widget_hide(drawV);

	if ( (type != MP3 && type != WAV && type != FLAC))  { // must be a video

//		GtkWidget *prior_stack = current_stack;

		video_file = 1;

//--------------------------------------------------------------------------
//		Embed video in video_draw widget - does not work in Wayland
//		First make video stack panel visible. Must be visible when
//		video initialized or seg fault.
//--------------------------------------------------------------------------

		libvlc_media_player_set_xwindow(mediaPlayer,
		                                GDK_WINDOW_XID(gtk_widget_get_window(GTK_WIDGET(drawV))));

		libvlc_media_add_option(media, ":avcodec-hw=none"); // bad vlc codec update fix


		}

//----------------------------------
//	No video - Audio only
//----------------------------------

	else {
		video_file = 0;
		}

	printf("VLC player created from media\n");

//---------------------------------------
//	No need to keep the media now
//---------------------------------------

	if (media) {
		libvlc_media_release (media);
		media = NULL;
		}

//---------------------------------
//	start the media player
//---------------------------------

	gtk_widget_hide(zippy_toy);


	int iplay = libvlc_media_player_play (mediaPlayer); // start playing media file

	clip_end = 0;

	ignore_me = 1;
	gtk_adjustment_set_value(adjustment22, 0.0);

	ignore_me = 1;
	gtk_adjustment_set_value(adjustment23, clip_end/1000.0);

	if (video_file) gtk_widget_show(drawV);
	else gtk_widget_show(zippy_toy);

	if (programData[SP->NowPlaying]->last_location) {
		t_position = programData[SP->NowPlaying]->last_location;
#ifdef VLC4
		libvlc_media_player_set_time(mediaPlayer, t_position, FALSE);
#else
		libvlc_media_player_set_time(mediaPlayer, t_position);
#endif
		}

	else t_position = 0;

//----------------------------
//	cell phone rotation
//
//	0  <	left
//	90 ^	normal
//	180 >	right
//	270 v	upside down
//----------------------------

	rotation = 0;

	char *meta = mediaProbe(SP->playThis);

	printf("meta data\n%s\n", meta);

	char *p1 = strstr(meta, "rotation=");

	if (p1 == NULL) return EXIT_SUCCESS;

	rotation = atol(p1+9);

	rotation = labs(rotation);

	printf("rotation = %d\n", rotation);

	return EXIT_SUCCESS;
	}

