/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018 - 2025 by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	September 10, 2025

#include "includes.h"
#include "defines.h"
#include "common-externs.h"
#include "common-fcn-headers.h"
#include "global-extern-variables.h"


#include <vlc/libvlc.h>
#include <vlc/libvlc_renderer_discoverer.h>
#include <vlc/libvlc_media.h>
#include <vlc/libvlc_media_player.h>

#define SLASH '/'


void    on_adjust_video_toggled(GtkWidget *w) {	// open overlay box

	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w))) { // toggled

		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(frame_next), TRUE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(overlay_clip), FALSE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(overlay_clip1), FALSE);

		gtk_widget_hide(Top1);
		gtk_widget_hide(ovl_fixed);
		gtk_widget_hide(ovl_fixed1);
		gtk_widget_show(opt_panel);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(crop_video), FALSE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(overlay_clip), FALSE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(overlay_clip1), FALSE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(insert_text), FALSE);

		gtk_widget_hide(insert_panel);
		gtk_widget_hide(crop_adj);

		gtk_widget_hide(draw2);
		gtk_widget_hide(join_group17);

		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(crop_video), FALSE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(overlay_clip), FALSE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(overlay_clip1), FALSE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(insert_text), FALSE);

		}

	else { // not toffled
		gtk_widget_hide(ovl_fixed);
		gtk_widget_hide(ovl_fixed1);
		gtk_widget_hide(opt_panel);
		gtk_widget_show(top1_back1);
		gtk_widget_show(Top1);

		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(frame_next))) {
			gtk_widget_show(draw2);
			gtk_widget_show(join_group17);
			}
		}

	}

