/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018 - 2925 by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	September 10, 2025

#include "includes.h"
#include "defines.h"
#include "common-externs.h"
#include "common-fcn-headers.h"


#include <vlc/libvlc.h>
#include <vlc/libvlc_renderer_discoverer.h>
#include <vlc/libvlc_media.h>
#include <vlc/libvlc_media_player.h>

#define SLASH '/'

void	vid_fmt_std(char *result, char *file_in, char *fileout, char *type) {

//---------------------------------------
//	create standard file format line
//---------------------------------------

	char scale[1024], tmp1[1024], tmp2[128]="";

	strcpy(tmp1, type);

	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(vid_640x480))) {
		strcpy(scale, "scale=640x480");
		strcat(tmp1, "-640x480");
		strcpy(tmp2, "640:480");
		}

	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(vid_720x480))) {
		strcpy(scale, "scale=720x480");
		strcat(tmp1, "-720x480");
		strcpy(tmp2, "720:480");
		}

	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(vid_1280x720))) {
		strcpy(scale, "scale=1280x720");
		strcat(tmp1, "-1280x720");
		strcpy(tmp2, "1280:720");
		}

	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(vid_1920x1080))) {
		strcpy(scale, "scale=1920x1080");
		strcat(tmp1, "-1920x1080");
		strcpy(tmp2, "1920:1080");
		}

	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(vid_3840x2160))) {
		strcpy(scale, "scale=3840x2160");
		strcat(tmp1, "-3840x2160");
		strcpy(tmp2, "3840:2160");
		}

	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(vid_custom))) {
		double scale_percent = (int)gtk_adjustment_get_value(adjustment37) / 100.0;
		char tmp3[128];
		sprintf(tmp3, "-custom-%.2f", scale_percent);
		strcat(tmp1, tmp3);
		sprintf(scale, "scale=iw*%f:ih*%f", scale_percent, scale_percent);
		new_name(fileout, file_in, tmp1);
		sprintf(result,
		        " -vf \"fps=%d,format=yuv420p,%s:force_original_aspect_ratio=decrease,"
		        "yadif\"  ",
		        25, scale, tmp2);
		return;
		}

	new_name(fileout, file_in, tmp1);

	sprintf(result,
	        " -vf \"fps=%d,format=yuv420p,%s:force_original_aspect_ratio=decrease,"
	        "pad=%s:(ow-iw)/2:(oh-ih)/2,yadif\"  ",
	        25, scale, tmp2);

	return;
	}

