/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018 - 2025 by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	August 31, 2025

#include "includes.h"
#include "common-externs.h"

#define SLASH '/'


void    updateTimes(int pa_nbr, int show_nbr) {

	char clip[64], TimeStart[64], TimeEnd[64], length[64],
	     tmp[512], length2[64], length3[32];
	int i, j, lngth;

	static int p1L, p2L, p3L, p4L, p5L, p6L, p7L, p8L, p9L,
	       p10L, p11L, p12L;

//-----------------------------------------------------------------------
//      GetTime() returns an int with the nbr of seconds in the file
//-----------------------------------------------------------------------

	if (strlen(ProgramArray[pa_nbr]) != 0) {

		if (programTime[pa_nbr] < 0) {
			int ft = filetype(ProgramArray[pa_nbr]);
			if (ft == JPG || ft == PNG || ft == WEBP) lngth = programTime[pa_nbr] = 5;
			else programTime[pa_nbr] = lngth = GetTime(ProgramArray[pa_nbr]);
			}
		else lngth = programTime[pa_nbr];

		sprintf(length, "len=%d", lngth);
		sprintf(length3, "%d", lngth);
		sprintf(length2, "%d", lngth); // entry box version
		}

	else {
		strcpy(length, "-1");
		strcpy(length3, "-1");
		}

	sprintf(clip, "clip %d", pa_nbr);

	int tx = 0, it;
	for (it = 0; it < pa_nbr && programTime[it] > 0; it++)
		tx = tx + programTime[it];

	if (programTime[it] < 0) tx = -1;

	sprintf(TimeStart, "start=%d", tx);
	sprintf(length2, "%d", tx + lngth); // entry box version

	if (show_nbr == 1) {
		p1L = lngth;

		if (p1L < 0) {
			strcpy(tmp, "clip=-1 start=-1 len=0 end=0");
			gtk_label_set_text(GTK_LABEL(p1Clip), tmp);
			}
		else {
			sprintf(TimeEnd, "end=%s", length2);
			sprintf(tmp, "%s %s %s %s\n", clip, TimeStart, length, TimeEnd);
			gtk_label_set_text(GTK_LABEL(p1Clip), tmp);
			}
		}

	else if (show_nbr == 2) {
		p2L = lngth;
		if (p2L < 0) {
			strcpy(tmp, "clip=-1 start=-1 len=0 end=0");
			gtk_label_set_text(GTK_LABEL(p2Clip), tmp);
			}
		else {
			sprintf(TimeStart, "start=%d", p1L);
			sprintf(TimeEnd, "end=%d", p1L + p2L);
			sprintf(tmp, "%s %s %s %s\n", clip, TimeStart, length, TimeEnd);
			gtk_label_set_text(GTK_LABEL(p2Clip), tmp);
			}
		}
	else if (show_nbr == 3)  {
		p3L = lngth;
		if (p3L < 0) {
			strcpy(tmp, "clip=-1 start=-1 len=0 end=0");
			gtk_label_set_text(GTK_LABEL(p3Clip), tmp);
			}
		else {
			sprintf(TimeStart, "start=%d", p1L + p2L);
			sprintf(TimeEnd, "end=%d", p1L + p2L +p3L);
			sprintf(tmp, "%s %s %s %s\n", clip, TimeStart, length, TimeEnd);
			gtk_label_set_text(GTK_LABEL(p3Clip), tmp);
			}
		}
	else if (show_nbr == 4) {
		p4L = lngth;
		if (p4L < 0) {
			strcpy(tmp, "clip=-1 start=-1 len=0 end=0");
			gtk_label_set_text(GTK_LABEL(p4Clip), tmp);
			}
		else {
			sprintf(TimeStart, "start=%d", p1L + p2L + p3L);
			sprintf(TimeEnd, "end=%d", p1L + p2L +p3L + p4L);
			sprintf(tmp, "%s %s %s %s\n", clip, TimeStart, length, TimeEnd);
			gtk_label_set_text(GTK_LABEL(p4Clip), tmp);
			}
		}
	else if (show_nbr == 5) {
		p5L = lngth;
		if (p5L < 0) {
			strcpy(tmp, "clip=-1 start=-1 len=0 end=0");
			gtk_label_set_text(GTK_LABEL(p5Clip), tmp);
			}
		else {
			sprintf(TimeStart, "start=%d", p1L + p2L + p3L + p4L);
			sprintf(TimeEnd, "end=%d", p1L + p2L +p3L + p4L + p5L);
			sprintf(tmp, "%s %s %s %s\n", clip, TimeStart, length, TimeEnd);
			gtk_label_set_text(GTK_LABEL(p5Clip), tmp);
			}
		}
	else if (show_nbr == 6) {
		p6L = lngth;
		if (p6L < 0) {
			strcpy(tmp, "clip=-1 start=-1 len=0 end=0");
			gtk_label_set_text(GTK_LABEL(p6Clip), tmp);
			}
		else {
			sprintf(TimeStart, "start=%d", p1L + p2L + p3L + p4L + p5L);
			sprintf(TimeEnd, "end=%d", p1L + p2L +p3L + p4L + p5L + p6L);
			sprintf(tmp, "%s %s %s %s\n", clip, TimeStart, length, TimeEnd);
			gtk_label_set_text(GTK_LABEL(p6Clip), tmp);
			}
		}
	else if (show_nbr == 7) {
		p7L = lngth;
		if (p7L < 0) {
			strcpy(tmp, "clip=-1 start=-1 len=0 end=0");
			gtk_label_set_text(GTK_LABEL(p7Clip), tmp);
			}
		else {
			sprintf(TimeStart, "start=%d", p1L + p2L + p3L + p4L + p5L + p6L);
			sprintf(TimeEnd, "end=%d", p1L + p2L +p3L + p4L + p5L + p6L + p7L);
			sprintf(tmp, "%s %s %s %s\n", clip, TimeStart, length, TimeEnd);
			gtk_label_set_text(GTK_LABEL(p7Clip), tmp);
			}
		}
	else if (show_nbr == 8) {
		p8L = lngth;
		if (p8L < 0) {
			strcpy(tmp, "clip=-1 start=-1 len=0 end=0");
			gtk_label_set_text(GTK_LABEL(p8Clip), tmp);
			}
		else {
			sprintf(TimeStart, "start=%d", p1L + p2L + p3L + p4L + p5L + p6L + p7L);
			sprintf(TimeEnd, "end=%d", p1L + p2L +p3L + p4L + p5L + p6L + p7L + p8L);
			sprintf(tmp, "%s %s %s %s\n", clip, TimeStart, length, TimeEnd);
			gtk_label_set_text(GTK_LABEL(p8Clip), tmp);
			}
		}
	else if (show_nbr == 9) {
		p9L = lngth;
		if (p9L < 0) {
			strcpy(tmp, "clip=-1 start=-1 len=0 end=0");
			gtk_label_set_text(GTK_LABEL(p9Clip), tmp);
			}
		else {
			sprintf(TimeStart, "start=%d", p1L + p2L + p3L + p4L + p5L + p6L + p7L + p8L);
			sprintf(TimeEnd, "end=%d", p1L + p2L +p3L + p4L + p5L + p6L + p7L + p8L + p9L);
			sprintf(tmp, "%s %s %s %s\n", clip, TimeStart, length, TimeEnd);
			gtk_label_set_text(GTK_LABEL(p9Clip), tmp);
			}
		}
	else if (show_nbr == 10) {
		p10L = lngth;
		if (p10L < 0) {
			strcpy(tmp, "clip=-1 start=-1 len=0 end=0");
			gtk_label_set_text(GTK_LABEL(p10Clip), tmp);
			}
		else {
			sprintf(TimeStart, "start=%d", p1L + p2L + p3L + p4L + p5L + p6L + p7L + p8L + p9L);
			sprintf(TimeEnd, "end=%d", p1L + p2L +p3L + p4L + p5L + p6L + p7L + p8L + p9L + p10L);
			sprintf(tmp, "%s %s %s %s\n", clip, TimeStart, length, TimeEnd);
			gtk_label_set_text(GTK_LABEL(p10Clip), tmp);
			}
		}
	else if (show_nbr == 11) {
		p11L = lngth;
		if (p11L < 0) {
			strcpy(tmp, "clip=-1 start=-1 len=0 end=0");
			gtk_label_set_text(GTK_LABEL(p11Clip), tmp);
			}
		else {
			sprintf(TimeStart, "start=%d", p1L + p2L + p3L + p4L + p5L + p6L + p7L + p8L + p9L + p10L);
			sprintf(TimeEnd, "end=%d", p1L + p2L +p3L + p4L + p5L + p6L + p7L + p8L + p9L + p10L + p11L);
			sprintf(tmp, "%s %s %s %s\n", clip, TimeStart, length, TimeEnd);
			gtk_label_set_text(GTK_LABEL(p11Clip), tmp);
			}
		}
	else if (show_nbr == 12) {
		p12L = lngth;
		if (p12L < 0) {
			strcpy(tmp, "clip=-1 start=-1 len=0 end=0");
			gtk_label_set_text(GTK_LABEL(p12Clip), tmp);
			}
		else {
			sprintf(TimeStart, "start=%d", p1L + p2L + p3L + p4L + p5L + p6L + p7L + p8L + p9L + p10L + p11L);
			sprintf(TimeEnd, "end=%d", p1L + p2L +p3L + p4L + p5L + p6L + p7L + p8L + p9L + p10L + p11L + p12L);
			sprintf(tmp, "%s %s %s %s\n", clip, TimeStart, length, TimeEnd);
			gtk_label_set_text(GTK_LABEL(p12Clip), tmp);
			}
		}

	}


void	on_update_times_clicked(GtkWidget *w) {
	updateTimes(SP->begin+0,  1);
	updateTimes(SP->begin+1,  2);
	updateTimes(SP->begin+2,  3);
	updateTimes(SP->begin+3,  4);
	updateTimes(SP->begin+4,  5);
	updateTimes(SP->begin+5,  6);
	updateTimes(SP->begin+6,  7);
	updateTimes(SP->begin+7,  8);
	updateTimes(SP->begin+8,  9);
	updateTimes(SP->begin+9,  10);
	updateTimes(SP->begin+10, 11);
	updateTimes(SP->begin+11, 12);
	}

