/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018, 2019, 2020, 2021, 2022, 2023, 2024
#+     by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	August 10, 2024

#include "includes.h"
#include "defines.h"
#include "common-externs.h"
#include "common-fcn-headers.h"


#include <vlc/libvlc.h>
#include <vlc/libvlc_renderer_discoverer.h>
#include <vlc/libvlc_media.h>
#include <vlc/libvlc_media_player.h>

#define SLASH '/'

//---------------------
//	TRIM/CUT CLIP
//---------------------


void    cutclip() {

	char tmp[16000];
	char tmp1[16000];
	int i, j;

	if (!mediaPlayer) {
		zippy_says("Trim/Cut clip: No file currently being played.\n");
		return;
		}

	for (i = strlen(SP->playThis); i > 0; i--) {
		if (SP->playThis[i] == '.') break;
		}

	if (i == 0) strcpy(tmp1, "out.mp4");

	else {
		tmp1[i--] = 0;
		for (j = i; j >= 0; j--)
			tmp1[j] = SP->playThis[j];
		}


	time_t tmark = time(0);

	libvlc_video_get_size (mediaPlayer, 0, &frame_width, &frame_height);

	char new[16000];

	new_name(new, SP->playThis, "trm");

	if (clip_end == 0 || clip_end - clip_start < 0) {
		clip_end = libvlc_media_player_get_length (mediaPlayer);
		}

//---------------------------------------------------------------------------
//	"taskset -c 0,1,2,3 ffmpeg -y -loglevel info -ss %d -i \"%s\" "
//	limit cpu time to keep from over heating. numbers are cpu core nbrs.
//---------------------------------------------------------------------------

	/******************************
		sprintf(tmp,
			"ffmpeg -y -loglevel info -i \"%s\" -filter_complex "
			"\"[0:v]trim=duration=%f[a]; "
			" [0:v]trim=start=%f,setpts=PTS-STARTPTS[b]; "
			" [a][b]concat[out1]; [out1]fps=25[out2]\" -map [out2]  -c:a libmp3lame -b:a 128k -c:v libx264 -preset veryslow -crf 20  \"%s\"",
			SP->playThis, clip_start / 1000.0, clip_end / 1000.0, new);
	*****************************/

	if (button_flag == RIGHT) {

		sprintf(tmp,
		        "ffmpeg -i \"%s\" -filter_complex "
		        " \"[0:v]trim=end=%f,setpts=N/FRAME_RATE/TB[v0]; "
		        " [0:a]atrim=end=%f,asetpts=N/SR/TB[a0]; "
		        " [0:v]trim=start=%f,setpts=N/FRAME_RATE/TB[v1]; "
		        " [0:a]atrim=start=%f,asetpts=N/SR/TB[a1]; "
		        " [v0][a0][v1][a1]concat=n=2:v=1:a=1[v][a]\" "
		        " -map \"[v]\" -map \"[a]\" -f matroska - | ffplay - -x 640 -y 480 -autoexit &",

		        SP->playThis,
		        clip_start / 1000.0,
		        clip_start / 1000.0,
		        clip_end / 1000.0,
		        clip_end / 1000.0 );

		preview_run(tmp);

		return;

		}


	sprintf(tmp,
	        "ffmpeg -i \"%s\" -filter_complex "
	        " \"[0:v]trim=end=%f,setpts=N/FRAME_RATE/TB[v0]; "
	        " [0:a]atrim=end=%f,asetpts=N/SR/TB[a0]; "
	        " [0:v]trim=start=%f,setpts=N/FRAME_RATE/TB[v1]; "
	        " [0:a]atrim=start=%f,asetpts=N/SR/TB[a1]; "
	        " [v0][a0][v1][a1]concat=n=2:v=1:a=1[v][a]\" "
	        " -map \"[v]\" -map \"[a]\" \"%s\" ",

	        SP->playThis,
	        clip_start / 1000.0,
	        clip_start / 1000.0,
	        clip_end / 1000.0,
	        clip_end / 1000.0,
	        new);

	int err_stat = ff_run("Trim", tmp, -1);

	if (err_stat != 0) {
		zippy_says("Trim/Cut clip: An error occurred\n");
		return;
		}

	printf("Created: %s\n", new);

	gtk_widget_show(drawV);

	clear_play();

	on_scan_video_dir_clicked(NULL);


	}



void on_cut_clip_clicked (GtkWidget *w) {

	button_flag = LEFT;
	cutclip();
	return;
	}


void on_cut_clip1_clicked (GtkWidget *w) {

	button_flag = RIGHT;
	cutclip();
	return;
	}

