/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018 - 2025
#+     by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#+	astyle --style=banner --indent=tab load-program.c.in
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	July 31, 2025

#include "includes.h"
#include "common-externs.h"

#define SLASH '/'

gboolean        on_vlcPosition_scroll_event(GtkScrollbar *b, GdkEventScroll *e) {

//--------------------------------------------------------------
//	see GdkEventScroll data structure for valid elements
//	see: gtk_widget_set_events(xxx,GDK_SCROLL_MASK);
//--------------------------------------------------------------

	if (!mediaPlayer) return FALSE;

	t_position = libvlc_media_player_get_time(mediaPlayer);

	if (e->delta_y == 1) { // down
		t_position = t_position - 1000;
		if (t_position < 0) t_position = 0;
		}

	else { // up
		t_position = t_position + 1000;
		}

	frame_update();

	return TRUE;
	}

//---------------------------------------------------------------------------------------
//      on_p1_button_press_event  on_p2_button_press_event  on_p3_button_press_event
//      on_p4_button_press_event  on_p5_button_press_event  on_p6_button_press_event
//      on_p7_button_press_event  on_p8_button_press_event  on_p9_button_press_event
//      on_p10_button_press_event on_p11_button_press_event on_p12_button_press_event
//---------------------------------------------------------------------------------------

#define P_BUTTON_PRESS(NBR) \
        gboolean on_p## NBR ##_button_press_event	\
                (GtkButton *btn, GdkEventButton *event, gpointer user_data) {  \
							\
                if (event->state & GDK_CONTROL_MASK) { /* right-click with CTRL*/ \
                        if (drag_source == -1) { \
                                gtkSetCursor(GDK_HAND1); \
                                drag_source =  SP->begin + NBR - 1;  \
                                return TRUE; /*no further processing*/ }  \
                        else { /* right-click with no CTRL*/ \
                                drag_target = SP->begin + NBR - 1; \
                                gtkSetCursor(GDK_TOP_LEFT_ARROW); \
                                on_p## NBR ##_drag_end (GTK_WIDGET(btn), NULL); \
                                return TRUE; }		\
			return TRUE; \
			} \
							\
                drag_source = drag_target = -1;  \
                gtkSetCursor(GDK_TOP_LEFT_ARROW); \
                if (event->button == 1 ) return FALSE; /* TRUE: quit processing; left click */  \
		/* right click */ 	\
		file_parms(ProgramArray[SP->begin + NBR -1]); \
                return FALSE; \
                }

P_BUTTON_PRESS(1) P_BUTTON_PRESS(2)  P_BUTTON_PRESS(3)  P_BUTTON_PRESS(4)
P_BUTTON_PRESS(5) P_BUTTON_PRESS(6)  P_BUTTON_PRESS(7)  P_BUTTON_PRESS(8)
P_BUTTON_PRESS(9) P_BUTTON_PRESS(10) P_BUTTON_PRESS(11) P_BUTTON_PRESS(12)

void	on_scroll_up_clicked(GtkWidget *w) {

	SP->begin=SP->begin - 12;
	if (SP->begin + PROGRAM_BUTTON_COUNT >= SP->scount) {
		SP->begin = SP->scount - PROGRAM_BUTTON_COUNT;
		}
	if (SP->begin < 0 ) SP->begin = 0;
	DisplayProgramButtons();
	}

void	on_scroll_down_clicked(GtkWidget *w) {

	SP->begin=SP->begin + 12;

	if (SP->begin + PROGRAM_BUTTON_COUNT >= SP->scount) {
		SP->begin = SP->scount - PROGRAM_BUTTON_COUNT;
		}

	if (SP->begin < 0 ) SP->begin = 0;

	DisplayProgramButtons();
	}


void	on_tile_first_clicked(GtkWidget *w) {
	SP->begin = 0;
	DisplayProgramButtons();
	}

void	on_tile_last_clicked(GtkWidget *w) {
	SP->begin=SP->scount - 12;
	if (SP->begin < 0 ) SP->begin = 0;
	DisplayProgramButtons();
	}

void	on_tile_back_clicked(GtkWidget *w) {
	on_scroll_up_clicked(NULL);
	}

void 	on_tile_forward_clicked(GtkWidget *w) {
	on_scroll_down_clicked(NULL);
	}
