/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018 - 2025 by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	August 8, 2025

#include "includes.h"
#include "defines.h"
#include "common-externs.h"
#include "common-fcn-headers.h"


#include <vlc/libvlc.h>
#include <vlc/libvlc_renderer_discoverer.h>
#include <vlc/libvlc_media.h>
#include <vlc/libvlc_media_player.h>

#define SLASH '/'


void	on_two_by_one_pressed(GtkWidget *w) {
	}


void	on_two_by_one_clicked(GtkWidget *w) {

	if (SP->scount < 1) {
		zippy_says("Tiled clips: no clips selected.\n");
		return;
		}

	close_boxes();

	int i, pcount = 0, first = -1, second = -1, third = -1;

	for (i = 0; i< SP->scount; i++) {
		if (programData[i]->play) {
			pcount++;
			if (pcount == 1) first = i;
			if (pcount == 2 ) {
				second = i;
				}
			if (pcount == 3 ) {
				third = i;
				break;
				}
			}
		}

	if (pcount < 2) {
		zippy_says("Tile clips: Not enough clips selected.\n");
		return;
		}

	char tmp[16000], new[4096];

	if (geo_test(ProgramArray[first], ProgramArray[second]) == 0) {
		zippy_says("Tile clips: All videos must have the same internal format / geometry.\n");
		return;
		}

	new_name(new, ProgramArray[first], "split");

	if (pcount == 2)
		sprintf(tmp, "ffmpeg -y -loglevel info "
		        "-i \"%s\" -i \"%s\" -filter_complex hstack=inputs=2,fps=25  -c:a libmp3lame -b:a 128k -c:v libx264 -preset veryslow -crf 20  \"%s\" ",
		        ProgramArray[first], ProgramArray[second], new);

	if (pcount == 3)
		sprintf(tmp, "ffmpeg -y -loglevel info "
		        "-i \"%s\" -i \"%s\" -i \"%s\" -filter_complex "
		        "hstack=inputs=3,fps=25  -c:a libmp3lame -b:a 128k -c:v libx264 -preset veryslow -crf 20  \"%s\" ",
		        ProgramArray[first], ProgramArray[second], ProgramArray[third], new);

	int err_stat= ff_run("2 x 1 Tile", tmp, first);

	zippy_says("Tiled clips: 2 x 1 tile filter finished\n");

	printf("err_stat=%d\n", err_stat);

	if (err_stat != 0) {
		zippy_says("Tiled clips: An error occurred\n");
		return;
		}



	clear_play();

	on_scan_video_dir_clicked(NULL);


	}

void	on_two_by_two_pressed(GtkWidget *w) {
	}

void	on_two_by_two_clicked(GtkWidget *w) {

	if (SP->scount < 1) {
		zippy_says("Tiled clips: No clips slected.\n");
		return;
		}

	close_boxes();

	int i, pcount = 0, first = -1, second = -1, third = -1, fourth = -1;

	for (i = 0; i< SP->scount; i++) {
		if (programData[i]->play) {
			pcount++;
			if (pcount == 1) first = i;
			else if (pcount == 2) second = i;
			else if (pcount == 3) third = i;
			if (pcount == 4 ) {
				fourth = i;
				break;
				}
			}
		}

	if (pcount < 4) {
		zippy_says("Tiled clips: Not enough clips selected.\n");
		return;
		}

	if (geo_test(ProgramArray[first], ProgramArray[second]) == 0) {
		zippy_says("Tiled clips: Videos must have the same internal format / geometry.\n");
		return;
		}

	if (geo_test(ProgramArray[first], ProgramArray[third]) == 0) {
		zippy_says("Tiled clips: Videos must have the same internal format / geometry.\n");
		return;
		}

	if (geo_test(ProgramArray[first], ProgramArray[fourth]) == 0) {
		zippy_says("Tiled clips: Videos must have the same internal format / geometry.\n");
		return;
		}

	char tmp[20000], new[4096];

	new_name(new, ProgramArray[first], "2x2");

	sprintf(tmp, "ffmpeg -y -loglevel info -i \"%s\" -i \"%s\" -i \"%s\" "
	        "-i \"%s\" -filter_complex "
	        "\"[0:v][1:v][2:v][3:v]xstack=inputs=4:layout=0_0|w0_0|0_h0|w0_h0[v]; "
	        "[v]fps=25[v1]\" -map [v1]  -c:a libmp3lame -b:a 128k -c:v libx264 -preset veryslow -crf 20  \"%s\" ",
	        ProgramArray[first], ProgramArray[second],
	        ProgramArray[third], ProgramArray[fourth], new);

	int err_stat = ff_run("2 by 2 Tile", tmp, first);

	zippy_says("Tiled clips: 2 x 2 Tile finished\n");

	if (err_stat != 0) {
		zippy_says("Tiled clips: An error occurred\n");
		sprintf(tmp, "rm \"%s\"", new);
		system(tmp);
		return;
		}

	clear_play();

	on_scan_video_dir_clicked(NULL);


	}

void    tile_button_clicked() { // ok button substitute


	vlc_pause();

	}

