/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018 - 2025 by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	September 10, 2025

#include "includes.h"
#include "defines.h"
#include "common-externs.h"
#include "common-fcn-headers.h"


#include <vlc/libvlc.h>
#include <vlc/libvlc_renderer_discoverer.h>
#include <vlc/libvlc_media.h>
#include <vlc/libvlc_media_player.h>

#define SLASH '/'


//----------------------------------------------
//	if these are missing, GTK complains
//----------------------------------------------

void	on_vid_1280x720_toggled(GtkWidget *w) {
	}

void	on_vid_640x480_toggled(GtkWidget *w) {
	}

void	on_vid_720x480_toggled(GtkWidget *w) {
	}

void	on_vid_1920x1080_toggled(GtkWidget *w) {
	}

void	on_vid_3480x2160_toggled(GtkWidget *w) {
	}

void	on_vid_custom_toggled(GtkWidget *w) {
	}

void	on_scale_videos_clicked(GtkWidget *w) {

	char tmp[16000], filename[4096], filetype[256];
	time_t tmark = time(0);
	int i, j, k, pcount = 0;

//	close_boxes();

	char scale[16000];

	for (i = 0; i < (SP->scount); i++) {

		if (programData[i]->play) {

			programData[i]->play = 0;

			pcount++;

			if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(vid_640x480)))
				strcpy(scale, "640x480");

			if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(vid_720x480)))
				strcpy(scale, "720x480");

			if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(vid_1280x720)))
				strcpy(scale, "1280x720");

			if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(vid_1920x1080)))
				strcpy(scale, "1920x1080");

			if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(vid_3840x2160)))
				strcpy(scale, "3840x2160");

			double scale_percent;

			if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(vid_custom))) {
				scale_percent = (int)gtk_adjustment_get_value(adjustment37) / 100.0;
				sprintf(scale, "custom%f", scale_percent);
				}

			char result[2048];
			vid_fmt_std(result, ProgramArray[i], filename, "scl");

			sprintf(tmp, "ffmpeg -y -loglevel info -i \"%s\" "
			        " %s "
			        "  -c:a libmp3lame -b:a 128k -c:v libx264 -preset veryslow -crf 20  "
			        "\"%s\" ",
			        ProgramArray[i], result, filename);

			int err_stat = ff_run("Scale", tmp, i);

			if (err_stat == 0) {
				printf("Created: %s\n\n", filename);
				}

			else {
				char file[4096];
				sprintf(file, "Error on file %s\n", filename);
				zippy_says(file);
				sprintf(tmp, "rm \"%s\"", filename);
				system(tmp);
				}

			}
		}

	if (!pcount) {
		zippy_says("No files selected.\n");
		}

	clear_play();

	on_scan_video_dir_clicked(NULL);

	}

void	on_scale_videos_pressed(GtkWidget *w) {
	}

