/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018 - 2025 by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	August 5, 2025

#include "includes.h"
#include "defines.h"
#include "common-externs.h"
#include "common-fcn-headers.h"

#include <vlc/libvlc.h>
#include <vlc/libvlc_renderer_discoverer.h>
#include <vlc/libvlc_media.h>
#include <vlc/libvlc_media_player.h>

#define SLASH '/'

void	get_tt(GtkTooltip *tooltip, int row) {

	char tmp[8192];
	char tmp1[8192];
	int i;

	if (strncmp(ProgramArray[row], "https:", 6) == 0 ||
	        strncmp(ProgramArray[row], "http:", 5) == 0) {

		gtk_tooltip_set_text (tooltip, ProgramArray[row]);
		return;
		}

	strcpy(tmp, ProgramArray[row]);
	gtk_tooltip_set_text (tooltip, tmp);
	return;

	sprintf(tmp, "du -h \"%s\"", ProgramArray[row]);

	FILE *f1 = popen(tmp, "r");

	if (f1 == NULL) {
		return;
		}

	fgets(tmp, 8192, f1);
	fclose(f1);

	if (strlen(tmp) == 0) return;

	tmp[strlen(tmp) -1] = 0;

	for (i = 0; tmp[i] && !isspace(tmp[i]); i++);
	tmp[i] = 0;

	sprintf(tmp1, "Size: %s\n%s\n", tmp, ProgramArray[row]);

	strcat(tmp1, mediaProbe(ProgramArray[row]));

	gtk_tooltip_set_text (tooltip, tmp1);

	}
