/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018 - 2025 by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	September 10, 2025

#include "includes.h"
#include "common-externs.h"

#define SLASH '/'

//-----------------------------------------------
//	load program file name into buttons
//-----------------------------------------------

char *	ProgramName(char * name, int nbr) {

	int i, j, k, m;
	static char tmp[2048];
	char played[64];
	FILE * f1;
	char *p1;

	if (name[strlen(name)-1] == '/' ) { // file name is a directory
		for (i = strlen(name)-2; name[i] != '/' && i > 0; i--);
		if (i) strcpy(tmp, &name[i+1]);
		else strcpy(tmp,name);
		return tmp;
		}

	for (i = strlen(name); i > 0 && name[i] != '.'; i--);	// find file extension start

	if (i == 0) ;				// no file extension
	else name[i]=0;			// truncate file extension

	for (; i>0 && name[i] != SLASH; i--);	// find last slash character

	if (i) i++;				// i will be zero if no slash found

	for (m = i; name[m] != 0; m++) {
		if (name[m] == '-') name[m] = ' ';
		if (name[m] == '_') name[m] = ' ';
		if (name[m] == '[') name[m] = ' ';
		if (name[m] == ']') name[m] = ' ';
		else name[m] = tolower(name[m]);
		}

	strip(name);

	for (m = i; name[m] != 0; m++) {
		if ( name[m] == ' ' && isalpha(name[m + 1]) )
			name[m + 1] = toupper(name[m + 1]);
		}

	name[i] = toupper(name[i]);

	name[i+PROGRAM_SIZE-7] = 0;	// truncate

//------------------------------------
//	name is shorter than limit
//------------------------------------

	strcpy(tmp, &name[i]);
	return tmp;

	j=strlen(&name[i]);

	if (j > PROGRAM_SIZE) ;
	else {
		for (k = i + j; k < PROGRAM_SIZE + i; k++) name[k] = ' ';	// pad with blanks
		name[k] = 0;
		}

	for (k=0; k<PROGRAM_ROW; k++) {
		tmp[k] = name[i+k];
		if (tmp[k] == ' ' && lastWord(&name[k + i + 1], k)) {
			k--;
			break;
			}
		}

	tmp[k] = name[i + k];
	k++;

	for (; name[i + k] != 0; k++) {
		tmp[k] = name[i + k - 1];
		}

	tmp[k] = name[i + k - 1];
	tmp[k + 1] = 0;

	return tmp;
	}

