/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018 - 2025 by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#+	astyle --style=banner --indent=tab load-program.c.in
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	September 30, 2025


#include "includes.h"
#include "common-externs.h"
#define SLASH '/'

//-----------------------------------------------------------------------------
//      paint colors on tile buttons depending if played, playing or playable
//-----------------------------------------------------------------------------

void    buttonColor(int i, GtkWidget *lbl, int bn) {

//---------------------------------------------
//	i is the ProgramArray index
//	lbl is the tile
//	bn is  button nbr
//---------------------------------------------

	char *p1, name[8192], tmp[8192], tmp1[8192];
	int j;
	static char cur_image[PROGRAM_BUTTON_COUNT][PGM_MAX] = {  };

	GdkPixbuf       *pix_In, *pix;

	if (i < 0) {
		for (int i = 0; i < PROGRAM_BUTTON_COUNT; i++)
			cur_image[i][0] = 0;
		return;
		}

	if (i < SP->scount &&
	        strlen(ProgramArray[i]) &&
	        strcmp(cur_image[bn - 1], ProgramArray[i]) == 0) {
		return; // image already in tile
		}

	if (i >= SP->scount || access(ProgramArray[i], F_OK) == -1) {
		strcpy(tmp1, "/usr/share/sgr-zippy/no_image.jpg");
		pix_In = gdk_pixbuf_new_from_file (tmp1, &err);                      // unscaled pixbuf
		pix = gdk_pixbuf_scale_simple (pix_In, 198, 134, GDK_INTERP_NEAREST); // scaled pixbuf
		gtk_image_set_from_pixbuf (GTK_IMAGE(lbl), pix);
		g_object_unref(pix_In);
		g_object_unref(pix);
		return;
		}

	strncpy(name, ProgramArray[i], PGM_MAX);

	strncpy(tmp, ProgramName(name, i), 8192);

	int ft = filetype(ProgramArray[i]);

	if (strlen(tmp) == 0 || ft == MP3) {

		if (ft == MP3)
			strcpy(tmp1, "/usr/share/sgr-zippy/audio.jpg");
		else
			strcpy(tmp1, "/usr/share/sgr-zippy/no_image.jpg");

		err = 0;
		pix_In = gdk_pixbuf_new_from_file (tmp1, &err);                      // unscaled pixbuf
		pix = gdk_pixbuf_scale_simple (pix_In, 198, 134, GDK_INTERP_NEAREST); // scaled pixbuf
		gtk_image_set_from_pixbuf (GTK_IMAGE(lbl), pix);

		g_object_unref(pix_In);
		g_object_unref(pix);
		return;
		}

	thumbnail_name(tmp1, tmp);

	if (ft != JPG && ft != PNG && ft != WEBP ) {

		if (access(tmp1, F_OK) == -1) { // does not exist - get thumbnail
			sprintf(tmp,
			        "ffmpeg -loglevel error -y -noaccurate_seek -ss %f -i \"%s\"  "
			        "-frames:v 1 -s 198x134 \"%s\"",
			        2.5,		 		// how far into the clip to go to get frame
			        ProgramArray[i],		// name of video file
			        tmp1);				// name of frame image to be created
			system(tmp);
			err = 0;
			pix = gdk_pixbuf_new_from_file (tmp1, &err);
			}
		else {
			err = 0;
			pix = gdk_pixbuf_new_from_file (tmp1, &err);
			}
		}
	else {
		sprintf(tmp, "cp \"%s\" \"%s\"", ProgramArray[i], tmp1);
		system(tmp);

		err = 0;
		pix_In = gdk_pixbuf_new_from_file (tmp1, &err);                      // unscaled pixbuf
		pix = gdk_pixbuf_scale_simple (pix_In, 198, 134, GDK_INTERP_NEAREST); // scaled pixbuf size
		g_object_unref(pix_In);
		}

	strcpy(cur_image[bn - 1], ProgramArray[i]);

	gtk_image_set_from_pixbuf (GTK_IMAGE(lbl), pix);
	g_object_unref(pix);

	while (gtk_events_pending ()) gtk_main_iteration ();
	}



// ----------------------------------------------------------------
// program tiles content load
// ----------------------------------------------------------------

void	DisplayProgramButtons() {

	char name[2048], tmp[2048];

//-------------------------------------------------------------------
//	the bx* vars are used later to remember the ProgramArray
//	indices of of the currently visible tiles when the
//	timing data is superimposed.
//-------------------------------------------------------------------


	programButtonLoad(button3,  bx1 =  SP->begin+0);
	programButtonLoad(button8,  bx2 =  SP->begin+1);
	programButtonLoad(button9,  bx3 =  SP->begin+2);
	programButtonLoad(button10, bx4 =  SP->begin+3);
	programButtonLoad(button11, bx5 =  SP->begin+4);
	programButtonLoad(button12, bx6 =  SP->begin+5);
	programButtonLoad(button13, bx7 =  SP->begin+6);
	programButtonLoad(button14, bx8 =  SP->begin+7);
	programButtonLoad(button2,  bx9 =  SP->begin+8);
	programButtonLoad(button5,  bx10 = SP->begin+9);
	programButtonLoad(button6,  bx11 = SP->begin+10);
	programButtonLoad(button15, bx12 = SP->begin+11);

//----------------
//	upper tray
//----------------

	buttonColor(SP->begin+0,  lbl1,  1);
	buttonColor(SP->begin+1,  lbl2,  2);
	buttonColor(SP->begin+2,  lbl3,  3);
	buttonColor(SP->begin+3,  lbl4,  4);
	buttonColor(SP->begin+4,  lbl5,  5);
	buttonColor(SP->begin+5,  lbl6,  6);
	buttonColor(SP->begin+6,  lbl7,  7);
	buttonColor(SP->begin+7,  lbl8,  8);
	buttonColor(SP->begin+8,  lbl9,  9);
	buttonColor(SP->begin+9,  lbl10, 10);
	buttonColor(SP->begin+10, lbl11, 11);
	buttonColor(SP->begin+11, lbl12, 12);

//------------------------------
//	set 'play' checkboxes
//------------------------------

	if (programData[SP->begin + 0]->play > 0)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(check1),TRUE);
	else	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(check1),FALSE);

	if (programData[SP->begin+1]->play > 0 )
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(check2),TRUE);
	else	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(check2),FALSE);

	if (programData[SP->begin+2]->play > 0 )
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(check3),TRUE);
	else	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(check3),FALSE);

	if (programData[SP->begin+3]->play > 0 )
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(check4),TRUE);
	else	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(check4),FALSE);

	if (programData[SP->begin+4]->play > 0 )
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(check5),TRUE);
	else	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(check5),FALSE);

	if (programData[SP->begin+5]->play > 0 )
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(check6),TRUE);
	else	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(check6),FALSE);

	if (programData[SP->begin+6]->play > 0 )
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(check7),TRUE);
	else	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(check7),FALSE);

	if (programData[SP->begin+7]->play > 0 )
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(check8),TRUE);
	else	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(check8),FALSE);

	if (programData[SP->begin+8]->play > 0 )
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(check9),TRUE);
	else	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(check9),FALSE);

	if (programData[SP->begin+9]->play > 0 )
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(check10),TRUE);
	else	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(check10),FALSE);

	if (programData[SP->begin+10]->play > 0 )
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(check11),TRUE);
	else	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(check11),FALSE);

	if (programData[SP->begin+11]->play > 0 )
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(check12),TRUE);
	else	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(check12),FALSE);


	on_update_times_clicked(NULL);
	}


//---------------------------------------
//	load content into program button
//---------------------------------------

void	programButtonLoad(GtkWidget *button, int nbr) {

	char name[1024] = "", tmp[1024] = "", *p1;

	strncpy(name,ProgramArray[nbr], 1024);

	strncpy(tmp, ProgramName(name, nbr), 1024);

	hexcleaner(tmp);

	}

void	thumbnail_name(char *tmp1, char *tmp) {

	sprintf(tmp1, "%s/frames/%s.jpg", Code_Home, tmp); // name of image frame

	}
