/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018 - 2025 by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	July 31, 2025

#include "includes.h"
#include "common-externs.h"

#define SLASH '/'

int	file_parms(char *file) {

	char tmp[8192];
	char tmp1[8192];

	sprintf(tmp, "ffprobe -loglevel 8 -show_streams -select_streams v \"%s\" | "
	        "grep \"height\\|width\\|frame_rate\\|time_base\\|rotation\\|codec_name\"",
	        file);

	printf("Probe: %s\n\n", tmp);

	FILE *f1 = popen(tmp, "r");

	if (f1 == NULL) {
		printf("*** popen() error file 1\n");
		zippy_says("popen() 1 error.");
		return 0;
		}

	zippy_says("----- Video Format ---\n");
	strcpy(tmp1, file);
	strcat(tmp1, "\n");
	zippy_says(tmp1);

	while (fgets(tmp, 1024, f1) != NULL ) {
		zippy_says(tmp);
		}

	fclose (f1);

	}

