/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018 - 2025 by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	September 10, 2025

#include "includes.h"
#include "common-externs.h"

#include "global-extern-variables.h"

#define SLASH '/'

//-------------------------------------------
//      Play file common code interface
//-------------------------------------------

void    PlayClip (GtkButton *button, GtkEntry *user_data, int Row) {

	gchar * text1 ;

	gtk_widget_hide(insert_panel);
	gtk_widget_hide(crop_adj);
	gtk_widget_hide(ovl_fixed);
	gtk_widget_hide(ovl_fixed1);
	gtk_widget_hide(opt_panel);


	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(crop_video), FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(overlay_clip), FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(overlay_clip1), FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(insert_text), FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(adjust_video), FALSE);

	on_haltProgram_clicked (NULL);

	vlc_no_pause();

	gtk_widget_show(draw2);
	gtk_widget_show(join_group17);

	if (SP->Pause) {
		SP->Pause = 0;
		}

	text1 = (gchar *) user_data;

	if (strlen((char *) text1) == 0) {
		Message("No file specified.");    // update label
		return;
		}

	strcpy(SP->playThis, text1);

	SP->playClip = 1;

	return;
	}

