/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018 - 2025 by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	July 17, 2025

#include "includes.h"
#include "common-externs.h"
#define SLASH '/'


void    on_vlcPosition_value_changed(GtkRange *r) {

//printf("aaaa\n");

	return;
	char tmp[128];

	if (!mediaPlayer) return;

	time_t t2 =
	    libvlc_media_player_get_length(mediaPlayer) ;

	t_position = libvlc_media_player_get_time(mediaPlayer);

	if (clip_end == 0) {
		clip_end = t2;
		ignore_me = 1;
		gtk_adjustment_set_value(adjustment23, clip_end/1000.0);
		}

	t2 = t2 /1000.0;

	sprintf(tmp,"%.02f/%u", (double) t_position / 1000.0, t2);

	gtk_label_set_text(GTK_LABEL(posLbl), tmp);    // update label

	programData[SP->NowPlaying]->last_location = t_position;
	return;
	}


gboolean        on_vlcPosition_change_value(GtkRange *r,
        GtkScrollType type, gdouble value) {

// printf("bbbb %f\n", value);

	if (!mediaPlayer) return FALSE;

	vlc_moved = value;
	return TRUE;

#ifdef VLC4
	libvlc_media_player_set_position(mediaPlayer, value/100.0, FALSE);
#else
	libvlc_media_player_set_position(mediaPlayer, value/100.0);
#endif

	return TRUE;
	t_position = libvlc_media_player_get_time(mediaPlayer);

	update_vlcPosition();

	while (gtk_events_pending ()) gtk_main_iteration ();

	return TRUE;
	}


void    update_vlcPosition() {

	if (!mediaPlayer) {
		return;
		}

	double position =
	    libvlc_media_player_get_position(mediaPlayer); // {0:1}

//------------------------------------------------------------------------
//	code for colored slider trough
//	gtk_range_set_fill_level (GTK_RANGE(vlcPosition), position*100.);
//	gtk_range_set_show_fill_level (GTK_RANGE(vlcPosition), TRUE);
//------------------------------------------------------------------------

	gtk_range_set_value (GTK_RANGE(vlcPosition), position*99.0);

	}

/*****************************************************************
void	on_vlc_up_pressed(GtkWidget *w) {
	gtk_toggle_button_set_active(frame_next, TRUE);
	vlc_up_pressed = 1;
	}

void	on_vlc_up_released(GtkWidget *w) {
	vlc_up_pressed = 0;
	}

void	on_vlc_down_pressed(GtkWidget *w) {
	gtk_toggle_button_set_active(frame_next, TRUE);
	vlc_down_pressed = 1;
	}

void	on_vlc_down_released(GtkWidget *w) {
	vlc_down_pressed = 0;
	}
*****************************************************************/

void	on_frame_up_clicked(GtkWidget *w) {
	forward_move(250);
	}

void	on_frame_down_clicked(GtkWidget *w) {
	back_move(250);
	}

void	on_vlc_up_clicked(GtkWidget *w) {
	forward_move(500);
	}

void	on_vlc_up1_clicked(GtkWidget *w) {
	forward_move(1000);
	}

void	on_vlc_up2_clicked(GtkWidget *w) {
	forward_move(2000);
	}

void	forward_move(int i) {

	if (!mediaPlayer) {
		return;
		}

	if (t_position + i < clip_end)

		t_position = t_position + i;

	else return;

#ifdef VLC4
	libvlc_media_player_set_time(mediaPlayer, t_position, FALSE);
#else
	libvlc_media_player_set_time(mediaPlayer, t_position);
#endif

	while (gtk_events_pending ()) gtk_main_iteration ();

	frame_update();

	}

void	on_vlc_down_clicked(GtkWidget *w) {
	back_move(500);
	}

void	on_vlc_down1_clicked(GtkWidget *w) {
	back_move(1000);
	}

void	on_vlc_down2_clicked(GtkWidget *w) {
	back_move(2000);
	}

void	back_move(int i) {

	if (!mediaPlayer) {
		return;
		}

	if (t_position - i > 0)

		t_position = t_position - i;

	else return;

#ifdef VLC4
	libvlc_media_player_set_time(mediaPlayer, t_position, FALSE);
#else
	libvlc_media_player_set_time(mediaPlayer, t_position);
#endif

	while (gtk_events_pending ()) gtk_main_iteration ();

	frame_update();

	}


void	frame_update() {

#ifdef VLC4
	libvlc_media_player_set_time(mediaPlayer, t_position, FALSE);
#else
	libvlc_media_player_set_time(mediaPlayer, t_position);
#endif

	gtk_range_set_value (GTK_RANGE(vlcPosition), t_position*99.0);

	update_vlcPosition();

	}


