/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018, 2019, 2020, 2021, 2025
#+     by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	February 28, 2025

#include "includes.h"
#include "common-externs.h"

#define SLASH '/'

//--------------- PLAY CHECK BOX TOGGLED signal program rows

//-----------------------------------------------------------------------------------------------
//      on_check1_toggled on_check2_toggled on_check3_toggled
//      on_check4_toggled on_check5_toggled on_check6_toggled
//      on_check7_toggled on_check8_toggled on_check9_toggled
//      on_check10_toggled on_check11_toggled on_check12_toggled
//-----------------------------------------------------------------------------------------------

#define CHECK_TOGGLED(NBR) \
        void on_check## NBR ##_toggled(GtkToggleButton *b) { \
	        if (gtk_toggle_button_get_active(b)) \
			programData[SP->begin + NBR - 1]->play = 1; \
        	else \
			programData[SP->begin + NBR - 1]->play = 0; \
        	DisplayProgramButtons(); }

CHECK_TOGGLED(1) CHECK_TOGGLED(2)  CHECK_TOGGLED(3)  CHECK_TOGGLED(4)
CHECK_TOGGLED(5) CHECK_TOGGLED(6)  CHECK_TOGGLED(7)  CHECK_TOGGLED(8)
CHECK_TOGGLED(9) CHECK_TOGGLED(10) CHECK_TOGGLED(11) CHECK_TOGGLED(12)

