/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018 - 2025 by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	September 10, 2025

#include "includes.h"
#include "defines.h"
#include "common-externs.h"
#include "common-fcn-headers.h"


#include <vlc/libvlc.h>
#include <vlc/libvlc_renderer_discoverer.h>
#include <vlc/libvlc_media.h>
#include <vlc/libvlc_media_player.h>

#define SLASH '/'


int	new_name(char * new, char *old, char *type) {

	char mhd_name[16000], tmp[16000], filename[16000], filetype[256];
	int i, j, k;

	int tmark = 1;

	strcpy(tmp, old); // basename() modifies arg

	strcpy(filename, basename(tmp));

	if (strlen(filename) == 0) {
		char tmp1[16000];
		sprintf(tmp1, "Filename error: %s\n", tmp);
		zippy_says(tmp1);
		printf("*** filename error: %s\n", tmp);
		return 0;
		}

	for (j = strlen(filename); j > 0; j--)
		if (filename[j] == '.') break;

	if (j == 0) {
		char tmp1[16000];
		sprintf(tmp1, "Missing file extension: %s\n", filename);
		zippy_says(tmp1);
		printf("*** Newname: missing file extension: %s\n", filename);
		return 0;
		}

	filename[j] = 0;
	strcpy(filetype, &filename[j+1]);

	while (1) {

		sprintf(tmp, "%s-%s-%02d.mp4",
		        mhd_ref1(filename, mhd_name), type, tmark);

		if (!file_exists(tmp)) break; // does not exist

		tmark ++;

		if (tmark > 100) {
			zippy_says("Too many instances of the base filename.\n");
			printf("*** too many instances of file name\n");
			return 0;
			}
		}

	strcpy(new, tmp);

	return 1;
	}

int	new_name1(char * new, char *old) {

	char tmp[16000], filename[16000], filetype[256], mhd_name[16000];
	int i, j, k;

	int tmark = 1;

	strcpy(tmp, old); // basename() modifies arg

	strcpy(filename, basename(tmp));

	if (strlen(filename) == 0) {
		char tmp1[16000];
		sprintf(tmp1, "Filename error: %s\n", tmp);
		zippy_says(tmp1);
		printf("*** filename error: %s\n", tmp);
		return 0;
		}

	for (j = strlen(filename); j > 0; j--)
		if (filename[j] == '.') break;

	if (j == 0) {
		char tmp1[16000];
		sprintf(tmp1, "Missing file extension: %s\n", filename);
		zippy_says(tmp1);
		printf("*** Newname1: missing file extension: %s\n", filename);
		return 0;
		}

	filename[j] = 0;
	strcpy(filetype, &filename[j+1]);

	while (1) {

		sprintf(tmp, "%s-%02d.png", mhd_ref1(filename, mhd_name), tmark);

		if (!file_exists(tmp)) {	// continue until unused name found
			break;
			}

		tmark ++;

		if (tmark >100) {
			zippy_says("Too many instances of the base filename.\n");
			printf("*** too many instances of file name\n");
			return 0;
			}
		}

	strcpy(new, tmp);

	return 1;
	}

