/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018, 2019, 2020, 2021, 2022, 2023, 2024
#+     by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	August 10, 2024

#include "includes.h"
#include "defines.h"
#include "common-externs.h"
#include "common-fcn-headers.h"


#include <vlc/libvlc.h>
#include <vlc/libvlc_renderer_discoverer.h>
#include <vlc/libvlc_media.h>
#include <vlc/libvlc_media_player.h>

#define SLASH '/'

void	monochrme() {

	char tmp[16000], filename[4096], filetype[256];
	time_t tmark = time(0);
	int i, j, k, pcount = 0;

	close_boxes();

	for (i = 0; i < (SP->scount); i++) {

		if (programData[i]->play) {

			pcount++;

			if (button_flag == RIGHT) {

				sprintf(tmp, "ffmpeg -y -loglevel info -i \"%s\" "
				        "-vf fps=25,\"monochrome\"  -c:a libmp3lame -b:a 128k -c:v libx264 -preset veryslow -crf 20   "
				        " -f rawvideo - | ffplay - -x 640 -y 480 -autoexit &",
				        ProgramArray[i]);

				preview_run(tmp);

				return;

				}

			programData[i]->play = 0;

			new_name(filename, ProgramArray[i], "mono");

			sprintf(tmp, "ffmpeg -y -loglevel info -i \"%s\" "
			        "-vf fps=25,\"monochrome\"  -c:a libmp3lame -b:a 128k -c:v libx264 -preset veryslow -crf 20  \"%s\"",
			        ProgramArray[i], filename);

			int err_stat = ff_run("Mono", tmp, i);

			if (err_stat != 0) {
				zippy_says("An error occurred\n");
				sprintf(tmp, "rm \"%s\"", filename);
				return;
				}

			printf("Created: %s\n\n", filename);

			}
		}


	if (!pcount) {
		zippy_says("No files selected.\n");
		}

	clear_play();

	on_scan_video_dir_clicked(NULL);

	}


void on_monochrome_clicked (GtkWidget *w) {

	button_flag = LEFT;
	monochrme();
	return;
	}


void on_monochrome1_clicked (GtkWidget *w) {

	button_flag = RIGHT;
	monochrme();
	return;
	}

