/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018, 2019, 2020, 2021, 2022, 2023, 2024
#+      by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

// Feb 18, 2024

#include "includes.h"
#include "common-externs.h"

void	memory_alloc() {

//---------------------------------------------------------------------
//      Allocate shared memory used to communicate with other threads.
//---------------------------------------------------------------------

	SP = (struct shared_memory *) malloc ( sizeof(struct shared_memory));

//----------------------------------------------------------------
//      program list row data arrays
//----------------------------------------------------------------

	ProgramArray = (char **) malloc(PROGRAM_MAX * 8);

	programData =  (struct ST **) malloc( PROGRAM_MAX * 8);

	programPlayed = (int *) malloc(PROGRAM_MAX * sizeof(int) );

	programTime = (int *) malloc(PROGRAM_MAX * sizeof(int));

	AlbumArray = (char **) malloc(ALBUM_MAX * 8);

	strcpy(SP->TimeNext,"");
	strcpy(SP->playThis,"");
	SP->t1 = 0;
	SP->VlcPauseFlg = 0;
	SP->begin = 0;
	SP->Xbegin = 0;
	SP->scount = 0;
	SP->acount = 0;
	SP->Pause = 0;
	SP->Clock = 0;
	strcpy(SP->CurrentPlay, "");
	SP->NowPlaying = -1;
	SP->showVideo = 1;
	SP->skipCurrent = 0;
	SP->playProgram = 0;
	SP->playClip = 0;
	SP->videoPlaying=0;
	SP->skip = 0;  // skip next
	strcpy(SP->next_random,"Cue:");
	SP->OrgPlay = 1;
	SP->x60 = 0.0;
	SP->x170 = 0.0;
	SP->x310 = 0.0;
	SP->x600 = 0.0;
	SP->x1000 = 0.0;
	SP->x3000 = 0.0;
	SP->x6000 = 0.0;
	SP->x12000 = 0.0;
	SP->x14000 = 0.0;
	SP->x16000 = 0.0;

	}
