/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018 - 2025 by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	July 19, 2025

#include "includes.h"
#include "common-externs.h"
#define SLASH '/'


int     vlc_playing() {

	if (!mediaPlayer) return 0;
	if (libvlc_media_player_is_playing(mediaPlayer))
		return 1; // pause means play
	return 0;
	}

void    vlc_pause() {

	if (!mediaPlayer) return;

//--------------------------
//	pause if not zero
//--------------------------

	libvlc_media_player_set_pause(mediaPlayer, 1);
	SP->VlcPauseFlg = 1; // play is paused
	return;
	}

void    vlc_no_pause() {

	if (!mediaPlayer) return;

//--------------------------
//	pause if not zero
//--------------------------

	libvlc_media_player_set_pause(mediaPlayer, 0);
	SP->VlcPauseFlg = 0; // play is not paused
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(frame_next), FALSE);
	return;
	}


//--------------------------------------------------------------
//      Pause at end of current media file if in program mode
//--------------------------------------------------------------

int     vlc_stop() {

	char tmp[4096];

	sprintf(tmp,"cp  \"%s/sgv.jpg\" \"%s/myimage.jpg\" ", "/usr/share/sgr-zippy", Code_Home);
	printf("%s\n", tmp);
	system(tmp);

	sprintf(tmp,"cp \"%s/sgv.jpg\" \"%s/myimage1.jpg\" ", "/usr/share/sgr-zippy", Code_Home);
	printf("%s\n", tmp);
	system(tmp);

	gtk_widget_show(zippy_toy);

	gtk_widget_hide(drawV);
	while (gtk_events_pending ()) gtk_main_iteration ();
	strcpy(SP->CurrentPlay, "");
	gtk_label_set_text(GTK_LABEL(posLbl), "");    // update label

//----------------------
//	Stop playing
//----------------------

	if (mediaPlayer) {
		vlc_no_pause();
#ifdef VLC4
		libvlc_media_player_stop_async (mediaPlayer);
#else
		libvlc_media_player_stop (mediaPlayer);
#endif

//----------------------------
//	Free the media_player
//----------------------------

		libvlc_media_player_release (mediaPlayer);
		}

	if (inst) {
		libvlc_release (inst);
		inst = (libvlc_instance_t *) 0;
		}

	mediaPlayer = (libvlc_media_player_t *) 0; // wipe the pointer

	return EXIT_SUCCESS;
	}

