/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018 - 2025 by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	September 10, 2025

#include "includes.h"
#include "defines.h"
#include "common-externs.h"
#include "common-fcn-headers.h"


#include <vlc/libvlc.h>
#include <vlc/libvlc_renderer_discoverer.h>
#include <vlc/libvlc_media.h>
#include <vlc/libvlc_media_player.h>

#define SLASH '/'

void	makeClip(int);

//-------------------
//	MAKE CLIP
//-------------------

void	on_make_clip_clicked(GtkWidget *w) {

	makeClip(0);

	}

void	makeClip(int preview) {

	char tmp[16000];
	char tmp1[16000];
	char mhdr[16000];
	char mhdr1[16000];
	int err_stat = 0;
	int i, j;

	if (!mediaPlayer) {
		zippy_says("No file being played.\n");
		return;
		}

	if (!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(frame_next)))
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(frame_next), TRUE);

	int file_code = filetype(SP->playThis);

//---------------------------------------
//	make a clip from an audio file
//---------------------------------------

	if (file_code == MP3 ||
	        file_code == WMA ||
	        file_code == OGG ||
	        file_code == WAV ||
	        file_code == FLAC ||
	        file_code == WMV) {

		char tmp[4096];

		outfade = gtk_spin_button_get_value(GTK_SPIN_BUTTON(out_fade));
		infade = gtk_spin_button_get_value(GTK_SPIN_BUTTON(in_fade));

//------------------------------------------------------------
//	static image for video file created from audio file
//------------------------------------------------------------

		sprintf(tmp,"cp \"%s/sgv.jpg\" \"%s/myimage1.jpg\" ",
		        "/usr/share/sgr-zippy", Code_Home);

		err_stat = err_stat + ff_run("copy image for audio clip", tmp, -1);

//---------------------------------------------
//	copy / extract audio file to temp.flac
//---------------------------------------------

		sprintf(tmp,
		        "ffmpeg -y -loglevel info -i \"%s\" -ss %d -to %d %s ",
		        SP->playThis,
		        clip_start / 1000,
		        (clip_end) / 1000,
		        mhd_ref("tmp.flac", mhdr));

		err_stat = err_stat + ff_run("make flac file", tmp, -1);

//----------------------------------------
//	make video from flac file extract
//----------------------------------------

		sprintf(tmp,
		        "ffmpeg -y -loglevel info "
		        "-i %s "
		        "-loop 1 -i \"%s/sgv.jpg\" "
		        "-shortest  -c:a libmp3lame -b:a 128k -c:v libx264 -preset veryslow -crf 20  -tune stillimage  "
		        "-pix_fmt yuv420p %s ",
		        mhd_ref("tmp.flac", mhdr),
		        "/usr/share/sgr-zippy",
		        mhd_ref("tmp1.mp4", mhdr1));

		err_stat = err_stat + ff_run("create video from audio", tmp, -1);

		outfade = gtk_spin_button_get_value(GTK_SPIN_BUTTON(out_fade));
		infade = gtk_spin_button_get_value(GTK_SPIN_BUTTON(in_fade));

		if (infade < 0.1 && outfade < 0.1) sprintf(tmp,
			        "ffmpeg -y -loglevel info -i %s -to %d "
			        "%s ",
			        mhd_ref("tmp1.mp4", mhdr1),
			        (clip_end - clip_start) / 1000,
			        mhd_ref("tmp.mp4", mhdr));

		else if (infade < 0.1 && outfade > 0.0) sprintf(tmp,
			        "ffmpeg -y -loglevel info -i %s -to %d "
			        "-af \"afade=t=out:st=%d:d=%d\" "
			        "%s ",
			        mhd_ref("tmp1.mp4", mhdr1),
			        (clip_end - clip_start) / 1000,
			        (int) (((clip_end - clip_start) / 1000) - outfade),
			        (int) outfade,					// audio outfade
			        mhd_ref("tmp.mp4", mhdr));

		else if (infade > 0.0 && outfade < 0.1) sprintf(tmp,
			        "ffmpeg -y -loglevel info -i %s -to %d "
			        "-af \"afade=t=in:st=0:d=%d \" "
			        "%s ",
			        mhd_ref("tmp1.mp4", mhdr1),
			        (clip_end - clip_start) / 1000,
			        (int) infade, 					// audio infade
			        mhd_ref("tmp.mp4", mhdr));

		else sprintf(tmp,
			             "ffmpeg -y -loglevel info -i %s -to %d "
			             "-af \"afade=t=in:st=0:d=%d, afade=t=out:st=%d:d=%d\" "
			             "%s ",
			             mhd_ref("tmp1.mp4", mhdr1),
			             (clip_end - clip_start) / 1000,
			             (int) infade, 					// audio infade
			             (int) (((clip_end - clip_start) / 1000) - outfade),
			             (int) outfade,					// audio outfade
			             mhd_ref("tmp.mp4", mhdr));

		err_stat = err_stat + ff_run("trim video to size", tmp, -1);

		}




//--------------------------------------
//	make a clip from a video file
//--------------------------------------

	else {

		if (rotation == 0)

			libvlc_video_get_size (mediaPlayer, 0, &frame_width, &frame_height);

		else if (rotation == 90)

			libvlc_video_get_size (mediaPlayer, 0, &frame_height, &frame_width);

		else {
			zippy_says("Error: only cell phone rotations 0 and 90 accepted at this time.\n");
			}

		printf("\n");
		printf("width = %d height = %d\n", frame_width, frame_height);

		char new[16000];

		if (clip_end == 0 || clip_end - clip_start < 0) {
			clip_end = libvlc_media_player_get_length (mediaPlayer);
			}

		outfade = gtk_spin_button_get_value(GTK_SPIN_BUTTON(out_fade));
		infade = gtk_spin_button_get_value(GTK_SPIN_BUTTON(in_fade));

		if (infade < 0.1 && outfade < 0.1)

			sprintf(tmp,
			        "ffmpeg -y -loglevel info -ss %d -i \"%s\" "
			        "-to %d -c:a aac -vf fps=25,\"crop=w=%d:h=%d:x=%d:y=%d \" "
			        " -c:a libmp3lame -b:a 128k -c:v libx264 -preset veryslow -crf 20   ",

			        clip_start / 1000,
			        SP->playThis,
			        (clip_end - clip_start) / 1000,

			        (int) (frame_width - (cropLeft+cropRight)),
			        (int) (frame_height - (cropBottom+cropTop)),

			        (int) cropLeft, (int) cropTop);

		else if (infade < 0.1 && outfade > 0.0)

			sprintf(tmp,
			        "ffmpeg -y -loglevel info -ss %d -i \"%s\" "
			        "-to %d -c:a aac -vf fps=25,\"crop=w=%d:h=%d:x=%d:y=%d, "
			        " fade=out:st=%d:d=%d\" "
			        "-af \"afade=t=out:st=%d:d=%d\" "
			        " -c:a libmp3lame -b:a 128k -c:v libx264 -preset veryslow -crf 20   ",

			        clip_start / 1000,
			        SP->playThis,
			        (clip_end - clip_start) / 1000,

			        (int) (frame_width - (cropLeft+cropRight)),
			        (int) (frame_height - (cropBottom+cropTop)),

			        (int) cropLeft, (int) cropTop,
			        (int) (((clip_end - clip_start) / 1000) - outfade),
			        (int) outfade,					// video outfade
			        (int) (((clip_end - clip_start) / 1000) - outfade),
			        (int) outfade);				// audio outfade

		else if (infade > 0.0 && outfade < 0.1)

			sprintf(tmp,
			        "ffmpeg -y -loglevel info -ss %d -i \"%s\" "
			        "-to %d -c:a aac -vf fps=25,\"crop=w=%d:h=%d:x=%d:y=%d, "
			        "fade=in:st=0:d=%d \" "
			        "-af \"afade=t=in:st=0:d=%d \" "
			        " -c:a libmp3lame -b:a 128k -c:v libx264 -preset veryslow -crf 20  ",

			        clip_start / 1000,
			        SP->playThis,
			        (clip_end - clip_start) / 1000,

			        (int) (frame_width - (cropLeft+cropRight)),
			        (int) (frame_height - (cropBottom+cropTop)),

			        (int) cropLeft, (int) cropTop,
			        (int) infade,					// video infade
			        (int) infade); 					// audio infade

		else {
			sprintf(tmp,
			        "ffmpeg -y -loglevel info -ss %d -i \"%s\" "
			        "-to %d -c:a aac -vf fps=25,\"crop=w=%d:h=%d:x=%d:y=%d, "
			        "fade=in:st=0:d=%d, fade=out:st=%d:d=%d\" "
			        "-af \"afade=t=in:st=0:d=%d, afade=t=out:st=%d:d=%d\" "
			        " -c:a libmp3lame -b:a 128k -c:v libx264 -preset veryslow -crf 20  ",

			        clip_start / 1000,
			        SP->playThis,
			        (clip_end - clip_start) / 1000,

			        (int) (frame_width - (cropLeft+cropRight)),
			        (int) (frame_height - (cropBottom+cropTop)),

			        (int) cropLeft, (int) cropTop,
			        (int) infade,					// video infade
			        (int) (((clip_end - clip_start) / 1000) - outfade),
			        (int) outfade,					// video outfade
			        (int) infade, 					// audio infade
			        (int) (((clip_end - clip_start) / 1000) - outfade),
			        (int) outfade);				// audio outfade

			}

		if (!preview)  {
			strcat(tmp, mhd_ref("tmp.mp4", mhdr));
			err_stat = ff_run("Clip", tmp, -1);
			}
		else {
			strcat(tmp, " -f matroska  - | ffplay - -x 640 -y 480 -autoexit &");

			preview_run(tmp);

			return;

			}

		}


	if (err_stat == 0) {

		char rslt[8192];
		char tmp2[16000];

		file_probe(mhd_ref("tmp.mp4", mhdr), SP->playThis, rslt);

//------------------------------
//	rename tmp file to rslt
//------------------------------

		sprintf(tmp2, "mv %s \"%s\"",
		        mhd_ref("tmp.mp4", mhdr), rslt);

		system(tmp2);
		printf("\n%s\n", tmp2);

//-------------------------
//	remove temp files
//-------------------------

		sprintf(tmp2, "rm -f %s %s %s",
		        mhd_ref("tmp.flac", mhdr),
		        mhd_ref("tmp1.mp4", mhdr),
		        mhd_ref("tmp.mp4", mhdr) );

		system(tmp2);
		printf("\n%s\n", tmp2);

		}

	else {
		char tmp2[16000];

		zippy_says("An error occured\n");

		sprintf(tmp2, "rm -f %s %s %s",
		        mhd_ref("tmp.flac", mhdr),
		        mhd_ref("tmp1.mp4", mhdr),
		        mhd_ref("tmp.mp4", mhdr) );

		system(tmp2);
		printf("\n%s\n", tmp2);
		}

	clear_play();

	on_scan_video_dir_clicked(NULL);

	}


void    on_play_clip1_clicked(GtkWidget *w) {

	printf("*****************************************************************\n");
	makeClip(1);
	return;

	char cmd[16000];
	double lft, rgt, top, bot;
	int width, height, x, y;

	if (!mediaPlayer) return;

	if (!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(frame_next)))
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(frame_next), TRUE);

	lft = gtk_spin_button_get_value (GTK_SPIN_BUTTON(crop_left));
	rgt = gtk_spin_button_get_value (GTK_SPIN_BUTTON(crop_right));
	top = gtk_spin_button_get_value (GTK_SPIN_BUTTON(crop_top));
	bot = gtk_spin_button_get_value (GTK_SPIN_BUTTON(crop_bottom));

	width = frame_width - rgt - lft;
	height = frame_height - bot - top;
	x = lft ;
	y = top;

	printf("Play clip: %s\n", SP->CurrentPlay);

	printf("crop field (w:h:x:y %d:%d:%d:%d\n", width, height, x, y);

//      width:height:x:y

	sprintf(cmd,
	        "ffplay -i \"%s\" -loop 0 -ss %dms -t %dms -x 640 -y 480 -autoexit -vf 'crop=%d:%d:%d:%d' &",
	        SP->CurrentPlay, clip_start, clip_end - clip_start, width, height, x, y );

	printf("*** %s\n", cmd);
	system(cmd);

	}


