/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018, 2019, 2020, 2021, 2022, 2023
#+     by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	Nov 7, 2023

#include "includes.h"
#include "defines.h"
#include "common-externs.h"
#include "common-fcn-headers.h"


#include <vlc/libvlc.h>
#include <vlc/libvlc_renderer_discoverer.h>
#include <vlc/libvlc_media.h>
#include <vlc/libvlc_media_player.h>

#define SLASH '/'

void	on_loop_stream_clicked(GtkWidget *w) {

	char tmp[16000], filename[4096], filetype[256];
	time_t tmark = time(0);
	int i, j, k, pcount = 0;

	close_boxes();

	gdouble x = (int) gtk_adjustment_get_value(adjustment21);

	if (x < 0) {
		zippy_says("Loop value must be 0 or greater.\n");
		return;
		}

	for (i = 0; i < (SP->scount); i++) {

		if (programData[i]->play) {

			programData[i]->play = 0;

			pcount++;

			new_name(filename, ProgramArray[i], "loop");

			sprintf(tmp, "ffmpeg -y -loglevel info -stream_loop %d -i \"%s\" "
			        "  -c:a libmp3lame -b:a 128k -c:v libx264 -preset veryslow -crf 20  \"%s\"",
			        (int) x, ProgramArray[i], filename);

			int err_stat = ff_run("Loop", tmp, -1);

			if (err_stat != 0) {
				zippy_says("An error occurred\n");
				sprintf(tmp, "rm \"%s\"", filename);
				return;
				}

			printf("Created: %s\n\n", filename);

			}
		}


	if (!pcount) {
		zippy_says("No files selected.\n");
		}

	clear_play();

	on_scan_video_dir_clicked(NULL);

	}

void	on_loop_stream_pressed(GtkWidget *w) {
	}
