/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018 - 2025 by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#+ astyle --style=banner --indent=tab load-program.c.in
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	Nov 22, 2025

#include "includes.h"
#include "common-externs.h"

//----------------------------------------------------------------
//	load program.lst
//----------------------------------------------------------------

void	LoadProgram(char * file) {

	FILE *s1;
	char cmd[1024];
	int i, ft;

	int Album = 0, Track = 0;

	for (int i = 0; i < PROGRAM_MAX; i++) {
		strcpy(ProgramArray[i], "");
		programData[i]->play = 0;
		programTime[i] = -1;
		}

//----------------------------------------------------------------
//	load program entries
//----------------------------------------------------------------

	if (file[0] == '\"') {
		int i;
		for (i = 1; file[i] != 0; i++) file[i - 1] = file[i];
		file[i] = 0;
		}

	if (file[strlen(file) - 1] == '\"') file[strlen(file) - 1] = 0;
	if (file[strlen(file) - 1] == '\"') file[strlen(file) - 1] = 0;

	s1 = fopen(file,"r");

	if (s1 == NULL) {		// no program.lst file
		SP->scount = 0;	// program list is empty
		printf("*** File not found: %s\n", file);
		i = 0;
		while (i < PROGRAM_MAX) { // finish list
			strcpy(ProgramArray[i],"");
			programTime[i] = -1;
			i++;
			}
		return;
		}

//----------------------------
//	program.lst exists
//----------------------------

	char tmp[2048],tme[32];
	SP->scount=0;

	printf("\n*** checking incoming file names ...\n");

	while (1) {

		tmp[0] = 0;

		if (fgets(tmp, 2048, s1) == NULL) break; // read program.lst line
		if (strlen(tmp) < 3) continue;
		if (tmp[0] == '#') continue;

		for (i = 0; tmp[i] != 0; i++) { // no non-ascii or $. $ causes problems with bash
			if (tmp[i] == '$') break;
			if (isascii(tmp[i])) continue;
			}

		if (tmp[i] != 0) {
			printf("*** Non ASCII character in file name %s\n", tmp);
			continue;
			}

		tmp[strlen(tmp)-1] = 0; // remove newline char

		if (file_exists(tmp) == 0) continue;

		programData[SP->scount]->play = 0;
		programData[SP->scount]->last_location = 0;
		strcpy(cmd, tmp);
		programTime[SP->scount] = -1;

		if ((ft = filetype(cmd)) == UNRECOGNIZED) continue;
		if (ft == DIR) continue;

		if ( ! (ft == MP4 || ft == DVD || ft == AVI || ft == MPG || ft == URL ||
		        ft == WMV || ft == MOV || ft == MPV || ft == MKV || ft == JPG ||
		        ft == WEBP || ft == PNG || ft == MP3) ) continue;

		if (strlen(cmd) >= PGM_MAX) {
			printf("*** File reference too long: **%s**\n",cmd);
			continue; // does not exist
			}

		strcpy(ProgramArray[SP->scount], cmd);	// record file name

		if (ft != URL && ft != JPG && ft != PNG && ft != WEBP)
			programTime[SP->scount] = GetTime(cmd);

		else programTime[SP->scount] == -1;

		(SP->scount)++;
		if (SP->scount > PROGRAM_MAX-20) {
			(SP->scount)--;
			printf("*** More than %d lines in program.lst \n", PROGRAM_MAX);
			break;
			}
		}

	i = SP->scount;

	while (i < PROGRAM_MAX) { // finish list
		strcpy(ProgramArray[i], "");
		programTime[i] = -1;
		programData[i]->last_location = 0;
		i++;
		}

	fclose (s1);
	printf("*** Program loader\n");

//------------------------------------------
//	scount is count of actual entries
//	PROGRAM_MAX is size of array
//------------------------------------------

	printf("SP->scount=%d PROGRAM_MAX=%d\n", SP->scount,PROGRAM_MAX);
	printf("\n");

	SP->begin = 0;

	on_date_sort_clicked(NULL);

	DisplayProgramButtons();

	}

int	empty_dir(char *dir_name) {

	char tmp[8192];
	int i;

	sprintf(tmp, "ls %s | wc", dir_name);

	FILE *f1 = popen(tmp, "r");

	if (f1 == NULL) return 0;

	fscanf(f1, "%d", &i);

	fclose(f1);

	if (i == 0) return 0;

	return 1;
	}
