/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018 - 2025 by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	September 10, 2025

#include "includes.h"
#include "defines.h"
#include "common-externs.h"
#include "common-fcn-headers.h"
#include "global-extern-variables.h"

#include <vlc/libvlc.h>
#include <vlc/libvlc_renderer_discoverer.h>
#include <vlc/libvlc_media.h>
#include <vlc/libvlc_media_player.h>

#define SLASH '/'

#define TEXT_X 104
#define TEXT_Y 150

void	on_dbox5Entry_changed(GtkEntry  *entry, gchar *preedit, gpointer user_data, GtkButton *b) {

	marquee_show();

	}

void    on_dxb1_clicked(GtkButton *b) { // ok button for text box

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(insert_text), FALSE);

	close_boxes();

	const gchar *sentry = gtk_entry_get_text( g_dbox5Entry );

	if (strlen(sentry) == 0) {
		Message("Invalid response");
		zippy_says("Invalid response.\n");
		return;
		}

	int i, j, k, pcount = 0;

	gdouble b_trans =  gtk_adjustment_get_value(adjustment13); // text trans
	gdouble start =  gtk_adjustment_get_value(adjustment16); // text_start
	gdouble end =  gtk_adjustment_get_value(adjustment15); // text_end
	gdouble size =  gtk_adjustment_get_value(adjustment14); // text_size
	GdkRGBA rgba;
	gtk_color_button_get_rgba(text_color, &rgba);

	gtk_widget_hide(insert_panel);

	char tmp[16000], filename[4096], filetype[256];
	time_t tmark = time(0);

	char scale[16000];

	for (i = 0; i < (SP->scount); i++) {

		if (programData[i]->play) {

			programData[i]->play = 0;

			pcount++;

//------------------------------------------------------------------
//	ffmpeg -i input.mp4 -vf scale=320:240,setsar=1:1 output.mp4
//------------------------------------------------------------------

			if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(vid_640x480)))
				strcpy(scale, "640x480");

			else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(vid_720x480)))
				strcpy(scale, "720x480");

			else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(vid_1280x720)))
				strcpy(scale, "1280x720");

			else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(vid_1920x1080)))
				strcpy(scale, "1920x1080");

			else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(vid_3840x2160)))
				strcpy(scale, "3840x2160");

			else {
				Message("Scale must be a pre-set scale.");
				zippy_says("Scale must be a pre-set scale.\n");
				return;
				}

			new_name(filename, ProgramArray[i], "txt");

			time_t start_time = libvlc_media_player_get_time(mediaPlayer) / 1000; // milliseconds

			time_t end_time = start_time + gtk_spin_button_get_value(GTK_SPIN_BUTTON(duration_spin));

			sprintf(tmp, "ffmpeg -y -loglevel info -i \"%s\" -vf fps=25,"
			        "\"drawtext=text=\'%s\':enable=\'between(t,%d,%d)\':font=\'Times New Roman\':"
			        "x='%.2f':y='%.2f':fontsize=%d:fontcolor=#%02x%02x%02x:box=0:shadowcolor=black:shadowx=2:shadowy=2"
			        "\"  -c:a libmp3lame -b:a 128k -c:v libx264 -preset veryslow -crf 20  \"%s\"",

			        ProgramArray[i],
			        sentry,
			        start_time,
			        end_time,
			        (double) start,
			        (double) end,
			        (int) size,

			        (int) (rgba.red * 255),
			        (int) (rgba.green * 255),
			        (int) (rgba.blue * 255),

			        filename);

			int err_stat = ff_run("Text", tmp, i);

			if (err_stat != 0) {
				zippy_says("An error occurred\n");
				sprintf(tmp, "rm \"%s\"", filename);
				system(tmp);
				return;
				}

			printf("Created: %s\n\n", filename);

			}
		}


	if (!pcount) {
		zippy_says("No files selected.\n");
		}

	clear_play();

	on_scan_video_dir_clicked(NULL);

	}


void    on_insert_text_toggled(GtkWidget *w) {

	gint x, y, width, height;

	gtk_widget_hide(crop_adj);

	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)) ) {
		gtk_widget_show(insert_panel);  // show dialog
		gtk_widget_hide(crop_adj);
		gtk_widget_hide(ovl_fixed);
		gtk_widget_hide(ovl_fixed1);
		gtk_widget_hide(opt_panel);

		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(crop_video), FALSE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(overlay_clip), FALSE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(overlay_clip1), FALSE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(adjust_video), FALSE);

		gtk_widget_hide(draw2);
		gtk_widget_hide(join_group17);
		}

	else {
		gtk_widget_hide(insert_panel);
//                gtk_widget_hide(moving_label);  // show dialog

		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(frame_next))) {
			gtk_widget_show(draw2);
			gtk_widget_show(join_group17);
			}

		return;
		}

	if (mediaPlayer == NULL) {
		zippy_says("No media player currently in use.\n");
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(insert_text), FALSE);
//                gtk_widget_hide(moving_label);  // show dialog
		return;
		}

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(frame_next), TRUE); // vlc_pause();
	while (gtk_events_pending ()) gtk_main_iteration ();

	text_x = 0;
	text_y = 0;

	gtk_spin_button_set_value (GTK_SPIN_BUTTON(text_start), (gdouble) text_x);
	gtk_spin_button_set_value (GTK_SPIN_BUTTON(text_end), (gdouble) text_y);

	marquee_show();

	}

void	marquee_show() {

	const gchar *sentry = gtk_entry_get_text( g_dbox5Entry );

//--------------------------------------
//	colors are returned as gdouble
//--------------------------------------

	GdkRGBA rgba;
	int for_red, for_green, for_blue;

	gtk_color_button_get_rgba(text_color, &rgba);

	for_red = rgba.red * 255;
	for_green=rgba.green * 255;
	for_blue=rgba.blue * 255;

	int clx = for_blue + (for_green << 8) + (for_red << 16);

	int sz =  gtk_adjustment_get_value(adjustment14); // text_size

	text_x = gtk_spin_button_get_value (GTK_SPIN_BUTTON(text_start));
	text_y = gtk_spin_button_get_value (GTK_SPIN_BUTTON(text_end));

	int opx = 255 * gtk_adjustment_get_value(adjustment13); // opacity

//----------------------------------------------------------------
//	https://wiki.videolan.org/Documentation:Modules/marq/

//	0 libvlc_marquee_Enable
//	1 libvlc_marquee_Text
//	2 libvlc_marquee_Color 	string argument
//	3 libvlc_marquee_Opacity
//	4 libvlc_marquee_Position
//	5 libvlc_marquee_Refresh
//	6 libvlc_marquee_Size
//	7 libvlc_marquee_Timeout
//	8 libvlc_marquee_X
//	9 libvlc_marquee_Y
//----------------------------------------------------------------

	libvlc_video_set_marquee_string(mediaPlayer, libvlc_marquee_Text, sentry);

	libvlc_video_set_marquee_int(mediaPlayer, libvlc_marquee_Color, clx);

	libvlc_video_set_marquee_int(mediaPlayer, libvlc_marquee_Opacity, opx);

	libvlc_video_set_marquee_int(mediaPlayer, libvlc_marquee_Size, sz);

	libvlc_video_set_marquee_int(mediaPlayer, libvlc_marquee_X, text_x);
	libvlc_video_set_marquee_int(mediaPlayer, libvlc_marquee_Y, text_y);

	libvlc_video_set_marquee_int(mediaPlayer, libvlc_marquee_Timeout, 10000);

	libvlc_video_set_marquee_int(mediaPlayer, libvlc_marquee_Enable, 1);       /* enable marquee */

	}


//--------------------------
//	vertical control
//--------------------------

void    on_text_end_value_changed(GtkSpinButton *s) {

	marquee_show();

	}


void    on_back_trans_value_changed(GtkSpinButton *s) {

	marquee_show();

	}

//--------------------------
//	horizontal control
//--------------------------

void    on_text_start_value_changed(GtkSpinButton *s) {

	marquee_show();

	}

void	on_text_color_color_set(GtkWidget *w) {

	marquee_show();

	}


void	on_text_size_value_changed(GtkWidget *w) {

	marquee_show();

	}

