/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018  - 2025
#+     by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	September 10, 2025

#include "includes.h"
#include "defines.h"
#include "common-externs.h"
#include "common-fcn-headers.h"

#include "global-extern-variables.h"

#include <vlc/libvlc.h>
#include <vlc/libvlc_renderer_discoverer.h>
#include <vlc/libvlc_media.h>
#include <vlc/libvlc_media_player.h>

#define SLASH '/'

//----------------------------------
//      halt & clear program
//----------------------------------

void    on_haltProgram_clicked (GtkButton *button) {

	char cmd[1024];

	if (!mediaPlayer) return;

	video_file = 0;

	vlc_stop();

	SP->Clock = 0;
	SP->NowPlaying = -1;
	// SP->begin=0;
	SP->Pause=0;
	SP->OrgPlay = 1;
	strcpy(SP->CurrentPlay, "");
	SP->t1 = 0;
	frame_width = 0;
	frame_height = 0;

	SP->videoPlaying = 0;
	mouse_ul_x = -1;


	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(full_speed), TRUE) ;
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(insert_text), FALSE) ;

	advance_flg = 0;

	if (mediaPlayer) {
		libvlc_media_player_release (mediaPlayer);
		mediaPlayer = NULL;
		}

	gtk_widget_hide(drawV);

	gtk_widget_hide(insert_panel);
	gtk_widget_hide(crop_adj);
	gtk_widget_hide(ovl_fixed);
	gtk_widget_hide(ovl_fixed1);
	gtk_widget_hide(opt_panel);
	gtk_widget_hide(draw2);
	gtk_widget_hide(join_group17);

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(crop_video), FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(overlay_clip), FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(overlay_clip1), FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(insert_text), FALSE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(adjust_video), FALSE);

	DisplayProgramButtons();

	reset_clipper();

	}
