/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018, 2019, 2020, 2021, 2022, 2023, 2024
#+     by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	Feb 21, 2024

#include "includes.h"
#include "defines.h"
#include "common-externs.h"
#include "common-fcn-headers.h"


#include <vlc/libvlc.h>
#include <vlc/libvlc_renderer_discoverer.h>
#include <vlc/libvlc_media.h>
#include <vlc/libvlc_media_player.h>

#define SLASH '/'

void	no_crlf(char *txt) {

	for (int i = 0; txt[i] != 0; i++)
		if (txt[i] < ' ') txt[i] = ' ';

	}


int	geo_test(char *first, char *second) {

	char tmp[16000];
	int first_height = 1, first_width = 1;
	char first_time_base[128] = "first", first_avg_frame_rate[128] = "first";
	int second_height = 0, second_width = 0;
	char second_time_base[128] = "second", second_avg_frame_rate[128]="second";
	FILE *f1;

	sprintf(tmp, "ffprobe -loglevel 8 -show_streams -select_streams v \"%s\" | "
	        "grep \"height\\|width\\|frame_rate\\|time_base\\|codec_name\"",
	        first);

	printf("\nProbe: %s\n\n", tmp);

	f1 = popen(tmp, "r");

	if (f1 == NULL) {
		printf("*** popen() error file 1\n");
		zippy_says("popen() 1 error.");
		return 0;
		}

	while (1) {
		char *p = fgets(tmp, 1024, f1);

		if (p == NULL) {
			break;
			}

		if (strncmp(p, "width=", 6) == 0) {
			first_width = atoi(&tmp[6]);
			continue;
			}

		if (strncmp(p, "height=", 7) == 0) {
			first_height = atoi(&tmp[7]);
			continue;
			}

		if (strncmp(p, "time_base=", 10) == 0) {
			strcpy(first_time_base, &tmp[10]);
			continue;
			}

		if (strncmp(p, "avg_frame_rate=", 15) == 0) {
			strcpy(first_avg_frame_rate, &tmp[15]);
			continue;
			}
		}

	fclose (f1);

//--------------------------

	sprintf(tmp, "ffprobe -loglevel 8 -show_streams -select_streams v \"%s\" | "
	        "grep \"height\\|width\\|frame_rate\\|time_base\\|codec_name\"",
	        second);

	printf("Probe: %s\n\n", tmp);

	f1 = popen(tmp, "r");

	if (f1 == NULL) {
		printf("*** popen() error file 1\n");
		zippy_says("popen() 1 error.\n");
		return 0;
		}

	while (1) {
		char *p = fgets(tmp, 1024, f1);

		if (p == NULL) {
			break;
			}

		if (strncmp(p, "width=", 6) == 0) {
			second_width = atoi(&tmp[6]);
			continue;
			}

		if (strncmp(p, "height=", 7) == 0) {
			second_height = atoi(&tmp[7]);
			continue;
			}

		if (strncmp(p, "time_base=", 10) == 0) {
			strcpy(second_time_base, &tmp[10]);
			continue;
			}

		if (strncmp(p, "avg_frame_rate=", 15) == 0) {
			strcpy(second_avg_frame_rate, &tmp[15]);
			continue;
			}
		}

	fclose (f1);

	char msg[16000];

	strcpy(msg, "");

	strcpy(msg, "1 ");
	strcat(msg, first);
	strcat(msg, "\n");
	strcat(msg, "2 ");
	strcat(msg, second);
	strcat(msg, "\n\n");

	if (first_height != second_height) {
		strcat(msg, "Video heights are not the same\n");
		sprintf(tmp, " -> first_height = %d second_height = %d\n\n",
		        first_height, second_height);
		strcat(msg, tmp);
		}

	if (first_width != second_width) {
		strcat(msg, "Video widths are not the same.\n");
		sprintf(tmp, "-> first_width = %d second_width = %d\n\n",
		        first_width, second_width);
		strcat(msg, tmp);
		}

	if (strcmp(first_time_base, second_time_base) != 0) {
		strcat(msg, "Video time base mis-match\n");
		no_crlf(first_time_base);
		no_crlf(second_time_base);
		sprintf(tmp, "-> first_time_base = %s second_time_base = %s\n\n",
		        first_time_base, second_time_base);
		strcat(msg, tmp);
		}

	if (strcmp(first_avg_frame_rate, second_avg_frame_rate) !=0) {
		strcat(msg, "Video frame rate mis-match.\n");
		no_crlf(first_avg_frame_rate);
		no_crlf(second_avg_frame_rate);
		sprintf(tmp, "-> first_avg_frame_rate = %s second_avg_frame_rate = %s\n\n",
		        first_avg_frame_rate, second_avg_frame_rate);
		strcat(msg, tmp);
		printf(msg);
		}

	if (	first_height != second_height ||
	        first_width != second_width ||
	        strcmp(first_time_base, second_time_base) != 0 ||
	        strcmp(first_avg_frame_rate, second_avg_frame_rate) !=0) {
		zippy_says(msg);
		return 0;
		}

	return 1;
	}

