/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018 - 2025 by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#+	astyle --style=banner --indent=tab load-program.c.in
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	September 10, 2025

#include "includes.h"
#include "common-externs.h"

#include "global-extern-variables.h"

#define SLASH '/'

void	on_frame_next_toggled(GtkWidget *w) {

	if (!mediaPlayer) { // fail
		if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(frame_next)))
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(frame_next), FALSE);
		return;
		}

	if (!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(frame_next))) { // resume play

#ifdef VLC4
		libvlc_media_player_set_time(mediaPlayer, t_position, FALSE);
#else
		libvlc_media_player_set_time(mediaPlayer, t_position);
#endif

		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(crop_video), FALSE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(overlay_clip), FALSE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(overlay_clip1), FALSE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(insert_text), FALSE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(adjust_video), FALSE);

		gtk_widget_show(drawV);

		gtk_widget_hide(insert_panel);
		gtk_widget_hide(crop_adj);
		gtk_widget_hide(ovl_fixed);
		gtk_widget_hide(ovl_fixed1);
		gtk_widget_hide(opt_panel);

		gtk_widget_show(draw2);
		gtk_widget_show(join_group17);


		libvlc_media_player_set_pause(mediaPlayer, NOPAUSE); // play

		return;
		}

//------------
//	pause
//------------

	libvlc_media_player_set_pause(mediaPlayer, PAUSE); // pause

	t_position = libvlc_media_player_get_time(mediaPlayer);

	return;
	}


int     albumImage(GtkWidget *image, char * file, int width, int height) {

	char fileName[4096];

	strcpy(fileName, file);

	showImage(image, fileName, width, height);

	return 1;

	}


#define SLIDE_IMAGE_WIDTH 720    // slide size
#define SLIDE_IMAGE_HEIGHT 480

int     showImage(GtkWidget *image, char * file, int width, int height) {

	char tmp1[2048], cmd[2048];
	int j,k,h,h1,v,v1,tmpFlg=0;
	FILE *f1, *p1;
	char fileName[4096] = {0};
	int ver, hor;

	strcpy(fileName, file);

	err = NULL;

	pixbuf = gdk_pixbuf_new_from_file_at_scale
	         (fileName, width, height, TRUE, &err);

	if (!pixbuf) {
		g_printerr("%s\n", err->message);
		g_error_free(err);
		return 1;
		}

	pwidth = gdk_pixbuf_get_width(pixbuf);
	pheight = gdk_pixbuf_get_height(pixbuf);

	gtk_image_set_from_pixbuf(GTK_IMAGE(image), pixbuf);

//	gtk_widget_hide(drawV);
	gtk_widget_show(image);

	g_object_unref(pixbuf); /* no longer needed - free it */

	gint horx, verx, winheight, winwidth;

	return 1;

	winwidth = SLIDE_IMAGE_WIDTH;
	winheight = SLIDE_IMAGE_HEIGHT;

	horx = (winwidth) / 2.0 - (pwidth / 2.0);
	verx = (winheight) / 2.0 - (pheight / 2.0);

	if (verx < 0 ) verx = 0;
	if (horx < 0 ) horx = 0;

	horx = horx + 150;
	verx = verx + 100;

	return 1;

	}

