/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018, 2019, 2020, 2021, 2022, 2023, 2024, 2025
#+      by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	Jan 27, 2025

#include "includes.h"
#include "common-externs.h"

#define SLASH '/'


//--------------------------
//      determine filetype
//--------------------------

int     filetype(char *Xname) {

//---------------------------------------------
//      Known file extensions acceptable to be played.
//      Add more as needed.
//---------------------------------------------

	unsigned char name[2048]; // special chars show as negative
	strcpy(name, (unsigned char *) Xname);

	int j, i = strlen(name);

	if (i == 0) return UNRECOGNIZED;

	if (strncmp(name,"https:", 6) == 0) return URL;
	if (strncmp(name,"http:", 5) == 0) return URL;

	if (name[i-1] == '\"') {
		name[i-1] = 0;
		}

	i = strlen(name);

	for (int k=i; k>0; k--) if (name[k] < 32)  name[k] = 0;

	int type;

	type = file_stat(name);

	if (type == UNRECOGNIZED) return UNRECOGNIZED;
	if (type == S_IFDIR) return DIR; // see inode (7) for define symbols

	for (j = i; j > 0 && name[j] != '.'; j--); // important return value

	if (j <= 0) return UNRECOGNIZED;

	if (strcasecmp(&name[j], ".mp4") == 0)  return MP4;
	if (strcasecmp(&name[j], ".mp3") == 0)  return MP3;
	if (strcasecmp(&name[j], ".mpg") == 0)  return MPG;
	if (strcasecmp(&name[j], ".dvd") == 0)  return DVD;
	if (strcasecmp(&name[j], ".wma") == 0)  return WMA;
	if (strcasecmp(&name[j], ".ogg") == 0)  return OGG;
	if (strcasecmp(&name[j], ".wav") == 0)  return WAV;
	if (strcasecmp(&name[j], ".webm") == 0) return WEB;
	if (strcasecmp(&name[j], ".mov") == 0) return MOV;
	if (strcasecmp(&name[j], ".flac") == 0) return FLAC;
	if (strcasecmp(&name[j], ".m3u") == 0)  return PLAY;
	if (strcasecmp(&name[j], ".pls") == 0)  return PLAY;
	if (strcasecmp(&name[j], ".wmv") == 0)  return WMV;
	if (strcasecmp(&name[j], ".avi") == 0)  return AVI;
	if (strcasecmp(&name[j], ".mpv") == 0)  return MPV;
	if (strcasecmp(&name[j], ".jpg") == 0)  return JPG;
	if (strcasecmp(&name[j], ".jpeg") == 0)  return JPG;
	if (strcasecmp(&name[j], ".webp") == 0)  return WEBP;
	if (strcasecmp(&name[j], ".tif") == 0)  return TIFF;
	if (strcasecmp(&name[j], ".tiff") == 0)  return TIFF;
	if (strcasecmp(&name[j], ".png") == 0)  return PNG;
	if (strcasecmp(&name[j], ".gif") == 0)  return GIF;
	if (strcasecmp(&name[j], ".mkv") == 0)  return MKV;
	return UNRECOGNIZED;
	}
