/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018, 2019, 2020, 2021, 2022, 2023, 2024
#+      by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//      Feb 5, 2024

#include "includes.h"

#include "defines.h"

//---------------------------------------
//	see inode(7) for define symbols
//---------------------------------------

int	file_stat(char *file) {

	struct stat fileStat;

	if(stat(file, &fileStat) < 0) {
		char tmp[4096];
//		printf("*** file_stat() error on file \"%s\"\n", file);
		return UNRECOGNIZED;
		}

	if (! (fileStat.st_mode & S_IRUSR) ) return 0; // not readable
	if (fileStat.st_mode & S_IFREG) return S_IFREG; // regular file
	if (fileStat.st_mode & S_IFDIR) return S_IFDIR; // directory
	return UNRECOGNIZED; // other unsusable file type

	}

int	file_exists(char *file) {

	if (strncmp(file, "https:", 6) == 0) return 1;
	if (strncmp(file, "http:", 5) == 0) return 1;

	FILE *f1 = fopen(file, "r");
	if (f1 == NULL) return 0;
	fclose(f1);
	return 1;
	}
