/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018, 2019, 2020, 2021, 2022, 2023
#+     by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	Jan 26, 2024

#include "includes.h"
#include "defines.h"
#include "common-externs.h"
#include "common-fcn-headers.h"


#include <vlc/libvlc.h>
#include <vlc/libvlc_renderer_discoverer.h>
#include <vlc/libvlc_media.h>
#include <vlc/libvlc_media_player.h>

#define SLASH '/'

//----------------------------------------------------------------------
//	probe in_file
//	use source_file as pattern (may be same as in_file)
//	create rslt
//----------------------------------------------------------------------

int	file_probe(char * in_file, char * source_file, char *geo_rslt) {

	char tmp[16000];

//--------------------------------------------------------------------------
//	ffprobe -loglevel -8 -show_streams zippy1.mp4 | grep "height\|width"
//	width=760
//	height=546
//	coded_width=760
//	coded_height=546
//----------------------------------------------------------------------------

	sprintf(tmp, "ffprobe -loglevel -8 -show_streams \"%s\" | grep \"height\\|width\"",
	        in_file);

	printf("\nProbe: %s\n", tmp);

	FILE *f1 = popen(tmp, "r");

	if (f1 == NULL) {
		printf("*** popen() error file 1\n");
		zippy_says("popen() 1 error.\n");
		return EXIT_FAILURE;
		}

	char *p = fgets(tmp, 16000, f1);

	if (p == NULL || strncmp(tmp, "width=", 6) != 0) {
		printf("*** popen() width error\n");
		if (p != NULL) printf("*** %s\n", tmp);
		else printf("*** pointer NULL\n");
		zippy_says(tmp);
		return EXIT_FAILURE;
		}

	printf("** %s", tmp); // tmp has newline

	int first_width = atoi(&tmp[6]);

	p = fgets(tmp, 1024, f1);

	if (p == NULL || strncmp(tmp, "height=", 7) != 0) {
		printf("*** popen() height error\n");
		zippy_says("File error.\n");
		return EXIT_FAILURE;
		}

	printf("** %s", tmp); // tmp has newline

	int first_height = atoi(&tmp[7]);

	fclose (f1);

	sprintf(geo_rslt, "%dx%d", first_width, first_height);

	char fileout[8192];

	new_name(fileout, source_file, geo_rslt);
	strcpy(geo_rslt, fileout);

	return EXIT_SUCCESS;

	}
