/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018 - 2025  by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	August 8, 2025

#include "includes.h"
#include "defines.h"
#include "common-externs.h"
#include "common-fcn-headers.h"


#include <vlc/libvlc.h>
#include <vlc/libvlc_renderer_discoverer.h>
#include <vlc/libvlc_media.h>
#include <vlc/libvlc_media_player.h>

#define SLASH '/'


void	run_command(char *note, char *cmd) {

	int i = 0, j = 0;

	printf("\n\n-----------------------------------------------------------------\n");
	printf("-----------------------------------------------------------------\n");
	printf("%s\n%s\n", note, cmd);
	printf("-----------------------------------------------------------------\n");
	printf("-----------------------------------------------------------------\n\n");

	}


//-------------------------------------
//	run ffmpeg with windowed output
//-------------------------------------

int     ff_run(char *note, char *tmp, int row) {

	char file[8192], cmd[8192], tmp1[8192], tmp2[8192];

	run_command(note, tmp);	// message to console

	strcpy(cmd, tmp);
	strcat(cmd, " 2>&1"); // stderr is unbuffered, stdin is buffered

	setvbuf(stdin, NULL, _IONBF, 0); // make stdin unbuffered

	time_t begin_time = time(NULL);

	FILE *f1 = popen(cmd, "r");	// run command

	if (f1 == NULL) return 1;

	int c, i = 0, len;
	char *p1;

	int flip = 1;

	while((c = fgetc(f1)) != EOF) {
		if (c== 10 || c == 13) { // <cr> <lf>
			file[i] = 0;
			i = 0;

			strncpy(tmp2, file, 1000);	// line result

			strcat(tmp2, "\n");

			zippy_says(tmp2);

			if (strlen(tmp2) > 100) zippy_says("\n");

			while (gtk_events_pending()) gtk_main_iteration(); // force it
			}
		else {
			file[i] = c;
			if (i < 4096) i++;
			}
		}

	putchar ('\n');

	int ierr = pclose(f1);

	sprintf(cmd, "*** command time: %d seconds.\n", time(NULL) - begin_time);

	printf(cmd);

	zippy_says(cmd);


	setvbuf(stdin, NULL, _IOLBF, 0); // re-start buffering

	return ierr;

	}

