/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018 - 2025 by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	July 31, 2025

#include "includes.h"
#include "defines.h"
#include "common-externs.h"
#include "common-fcn-headers.h"

#include <vlc/libvlc.h>
#include <vlc/libvlc_renderer_discoverer.h>
#include <vlc/libvlc_media.h>
#include <vlc/libvlc_media_player.h>

#define SLASH '/'

int     delDialog(char * msg) {

	GtkDialogFlags flags = (GtkDialogFlags) (GTK_DIALOG_DESTROY_WITH_PARENT |
	                       GTK_MESSAGE_ERROR | GTK_DIALOG_MODAL |
	                       GTK_DIALOG_USE_HEADER_BAR) ;

	char tmp[8192];
	if (msg != NULL) sprintf(tmp, "Delete: \"%s\" ?", msg);
	else strcpy(tmp, "Delete selected?");

	GtkWidget *dialog = gtk_dialog_new_with_buttons  (tmp,
	                    GTK_WINDOW(window),
	                    flags,
	                    "Cancel", 200, "File Delete", 300,
	                    "Remove Entry", 100, NULL);

//-------------------------------------------
//      Expect 200 for NO and 100 for YES
//-------------------------------------------

	gtk_window_set_keep_above(GTK_WINDOW(dialog), TRUE);

	gint r = gtk_dialog_run (GTK_DIALOG (dialog));

	gtk_widget_hide(dialog);

	gtk_widget_destroy (dialog);

	return (int) r;
	}

void	on_delete_selected_clicked(GtkWidget *w) {

	char tmp[16000], filename[4096], filetype[256], mhd_name[16000];
	time_t tmark = time(0);
	int i, j, k, pcount = 0, code = 0;;

	if ((code = delDialog(NULL)) == 200) return; // yes or no

	if (code < 0 ) return; // WSL case when destroy clicked

more:

	for (i = 0; i < (SP->scount); i++) {

		if (programData[i]->play) {

			programData[i]->play = 0;

			pcount++;

			if (code == 300) { // full delete

				for (k = strlen(ProgramArray[i]); k > 0; k--)
					if (ProgramArray[i][k] == '/') break;

				if (k == 0 ) continue;

				sprintf(tmp, "rm %s ", mhd_ref(&ProgramArray[i][k], mhd_name));
				printf("%s\n", tmp);
				int err_stat = system(tmp);

				}

			delRow(i);
			goto more;
			}
		}

	if (!pcount) {
		zippy_says("No files selected.\n");
		}

	else {
		}

	clear_play();
	on_haltProgram_clicked (NULL);
	on_update_times_clicked(NULL);
	}

