/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018 - 2025 by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	June 19, 2025

#ifndef DEFINES_H
#define DEFINES_HRC 2

#if 0
#define VLC4
#endif

#if 0
#define VLC4
#endif

#define PAUSE 1
#define NOPAUSE 0

#define LEFT 0
#define RIGHT 1

//----------------------------
//	Pulse Audio Interface
//----------------------------

#define PULSE_SINK_NAME sink_name()
#define PULSE_SOURCE_NAME source_name()

// #define MUSIC_HOME_DIRECTORY strcpy(Music_Home_Directory, getenv("HOME"));\
strcat(Music_Home_Directory,"/Desktop/Zippy");

//------------------------------------------------------------------
//      ALB_MAX is the maximum length of a line in the album list
//      ALBUM_MAX is count of entries
//------------------------------------------------------------------

#define ALB_MAX 2048 // max length char string file ref

#define SPECTRUM 1
#define GAIN 2
#define BARGRAPH 1
#define STR_MAX 512 // various strings

//---------------------------------------------------
//      maximum text length of a program list entry
//---------------------------------------------------

#define PGM_MAX 2048 // max length file ref in the program list

//----------------------------------------------------
//      max number of characters in a button or line
//----------------------------------------------------

#define PROGRAM_ROW 32

//--------------------------------
//      program buttons per page
//      don't change this
//--------------------------------

#define PROGRAM_BUTTON_COUNT 12

//---------------------------------------------
//      sgr player always on top? (1 = yes)
//---------------------------------------------

#define PLAYER_ON_TOP 0

//---------------------------------------------------
// max number of characters of file title in button
//---------------------------------------------------

#define PROGRAM_SIZE 128

//---------------
//	Meters
//---------------

#define VU_METER 0
#define DIGITAL_METER 1
#define FAN_METER 2
#define BAR_METER 3

// Uncomment to make the arcs in the digital
// VU meters solid:

// #define SOLID_DIGI_ARCS

#define LEFT 0
#define RIGHT 1
#define MIC 2

//-------------------------------
//	display size constants
//-------------------------------


#define SMALL_DISPLAY 0
#define FULL_DISPLAY 1
#define MEDIUM_DISPLAY 2
#define REALLY_SMALL_DISPLAY 3
#define METERS_ONLY_DISPLAY 4
#define TABLET_DISPLAY 5
#define CLEAR_DISPLAY 6
#define SEAMLESS_DISPLAY 7
#define CASCADE_DISPLAY 8

//---------------------------------------------------
//      return codes for file types from filetype()
//      if a file does not have one of these, it
//      will not play.
//---------------------------------------------------

#define UNRECOGNIZED 0
#define MP4 1
#define MP3 2
#define MPG 3
#define DVD 4
#define OGG 5
#define WAV 6
#define FLAC 7
#define PLAY 8
#define WEB 9
#define WMV 10
#define AVI 11
#define MPV 12
#define OGV 13
#define WMA 14
#define MKV 15
#define MOV 16
#define DIR 30
#define URL 31
#define JPG 100
#define PNG 101
#define GIF 102
#define TIFF 103
#define WEBP 104

#define INIT_VOLUME 110

// position of vu meters

#define DigitalVuVer 294
#define ClassicVuVer 312

#define SPECTRUM_FREQ_VERTICAL DRAW_HEIGHT - 6.0

#define         WIDE_SPECTRUM 5
#define         NARROW_SPECTRUM 6
#define         VERY_NARROW_SPECTRUM 7

#define         SMALL_PANEL 0
#define         LARGE_PANEL 1
#define         CLIP_LEVEL 72.0 // level at which clip detected or 103.0
#define         RED 1
#define         YELLOW 2
#define         DRAWS 0
#define         DRAWS1 1
#define         UPPER_MAX       DRAW_HEIGHT - DRAW_HEIGHT / 10.0
#define         UPPER_MAX_MAX   DRAW_HEIGHT - DRAW_HEIGHT / 20.0
#define         SCALE_BASELINE_SPECTRUM         DRAW_HEIGHT/120.0
#define         SCALE_MIDLINE_SPECTRUM          DRAW_HEIGHT/250.0
#define         SCALE_VISUAL_SPECTRUM           DRAW_HEIGHT/120.0
#define         SCALE_VISUAL1_SPECTRUM          DRAW_HEIGHT/220.0
#define         SCALE_BASELINE_VOLUME           DRAW_HEIGHT/150.0
#define         SPECTRUM_PEAK DRAW_HEIGHT - 20.0// max level freq spectrum (clamp level)
#define         UPPER_MAX_MAX_COLOR cairo_set_source_rgb(cr, 1.0, 0.0, 1.0);
#define         UPPER_MAX_COLOR cairo_set_source_rgb(cr, 1.0, 0.7, 0.7);
#define         WHITE 3
#define         UPPER 0
#define         LOWER 1
#define         BAR_WIDTH1 2.9

#define                 RMX 5
//#define         SAMPLE_SIZE 400
#define         SAMPLE_SIZE 400

#define BACKGROUND_COLOR_DEFAULT_RED 0x0000
#define BACKGROUND_COLOR_DEFAULT_GREEN 0x0000
#define BACKGROUND_COLOR_DEFAULT_BLUE 0x0000

#define WEB_ROW_BG_COLOR "#444488"
#define PLAYING_ROW_BG_COLOR "#226622"
#define PLAYED_ROW_BG_COLOR "#552222"
#define UNPLAYED_ROW_BG_COLOR "#000055"
#define UNPLAYED_ROW_TEXT_COLOR "#ffff00"
#define UNPLAYED_ROW_FONT_SIZE "14px"
#define PLAYED_ROW_FONT_SIZE "12px"

#define TILE_WEB_RED 0x4444
#define TILE_WEB_GREEN 0x4444
#define TILE_WEB_BLUE 0x8888

#define TILE_UNPLAYED_RED 0x6666
#define TILE_UNPLAYED_GREEN 0xaaaa
#define TILE_UNPLAYED_BLUE 0x6666

#define TILE_PLAYED_RED 0xaaaa
#define TILE_PLAYED_GREEN 0x6666
#define TILE_PLAYED_BLUE 0x6666

#define TILE_PLAYING_RED 0xbbbb
#define TILE_PLAYING_GREEN 0xbbbb
#define TILE_PLAYING_BLUE 0xffff

#define TILE_ALBUM_MARKER_RED 0xffff
#define TILE_ALBUM_MARKER_GREEN 0x2222
#define TILE_ALBUM_MARKER_BLUE 0xffff

#define LOW_TRAY_NOT_PLAYABLE_RED 0x6666
#define LOW_TRAY_NOT_PLAYABLE_GREEN 0x6666
#define LOW_TRAY_NOT_PLAYABLE_BLUE 0xffff

#define ALBUM_IMAGE_SMALL_WIDTH 198
#define ALBUM_IMAGE_SMALL_HEIGHT 170

#define ALBUM_IMAGE_SIDE_WIDTH 400
#define ALBUM_IMAGE_SIDE_HEIGHT 400

#define ALBUM_IMAGE_MEDIUM_WIDTH 650
#define ALBUM_IMAGE_MEDIUM_HEIGHT 550

#define SCAN_LIMIT 20

// horizontal locations

#define CONFIG_WINDOW 2
#define EDIT_WINDOW_BUTTON 50
#define AUDIO_WINDOW_BUTTON 82
#define SLIDES_WINDOW_BUTTON 126
#define FLOAT_PROGRAM 170
#define ALBUM_WINDOW_BUTTON 228
#define TILE_BOX 274
#define SEAMLESS_BUTTON 304
#define RESET_BUTTON 370

// #define SMALL_TOWER_CIRCLE_FACTOR 0.62
// #define LARGE_TOWER_CIRCLE_FACTOR 0.92

#define CONTROL1 1
#define CONTROL 2
#define SHOW_MOVIE 3

#define METERS 4
#define GRAPHS 3
#define BARS 2
#define FILLED_ARC 3
#define ARC 2
#define NEEDLES 1
#define PULSE_TIME 100

#define WIPE_LEFT 1
#define CIRCLE_CLOSE 2
#define DISSOLVE 3
#define SLIDE_DOWN 4
#define RADIAL_WIPE 5
#define WIPEBR 6
#define CIRCLECROP 7
#define PIXELIZE 8
#define SLIDELEFT 9
#define WIPEDOWN 10
#define SLIDEUP 11
#define WIPEUP 12
#define SLIDERIGHT 13
#define WIPERIGHT 14
#define VERTOPEN 15
#define HORZOPEN 16
#define FADE 17
#define SQUEEZEH 18
#define SQUEEZEV 19
#define RANDOMTRAN 20

#define FPS 25

#define START_TO_CURSOR 0
#define CURSOR_TO_END 1

#endif

