/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018 - 2025 by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	August 1, 2025

#include "includes.h"
#include "defines.h"
#include "common-externs.h"
#include "common-fcn-headers.h"


#include <vlc/libvlc.h>
#include <vlc/libvlc_renderer_discoverer.h>
#include <vlc/libvlc_media.h>
#include <vlc/libvlc_media_player.h>

#define SLASH '/'

void    entry_insert(GtkEditable  *entry, gchar *edit) {

	unsigned char *file;
	int i = 0;

	gtk_editable_delete_text (entry, 0, -1 );

	i = strlen( (char *) edit);

	file = (unsigned char *) malloc(i + 1);

	if (file == NULL ) {
		printf("Out of memory in entry_insert\n");
		abort();
		}

	strcpy((char *) file, (char *) edit);

	if (strncmp((char *)file, "file://", 7) == 0)
		strcpy((char *)edit, (char *)&file[7]);

	else strcpy((char *)edit, (char *)file);

	free (file);

	return;
	}



void    paste1(int *Row) {

	int i,j,playedo, id1=0, id2=0;

	if (SP->scount+1 >= PROGRAM_MAX) {
		Message("Maximum number of program slots exceeded");
		return;
		}

	printf("copy to row %d copyClipRow=%d\n",*Row,copyClipRow);
	if (copyClipRow >= 0 ) {
		}
	else {
		}

	for (i = SP->scount + 1; i > *Row; i--) {        // shift entries up one
		strcpy(ProgramArray[i], ProgramArray[i - 1]);
		programData[i]->play = programData[i - 1]->play;
		programPlayed[i] = programPlayed[i-1];
		programTime[i] = programTime[i-1];
		}

	if (copyClipRow == -10) {
		strcpy(ProgramArray[*Row],top1);
		}
	if (copyClipRow == -20) {
		strcpy(ProgramArray[*Row],top2);
		}
	if (copyClipRow == -30) {
		strcpy(ProgramArray[*Row],top3);
		}

	programData[*Row]->play = 1;
	programTime[*Row] = -1;
	(SP->scount)++;

	DisplayProgramButtons();
	}



//----------------------------
//	entry changed1
//----------------------------

void	entry_changed1 (GtkEntry *entry, gchar *preedit, gpointer  user_data, int Row) {

//--------------------------------------------------------------------
//	Handles multiple paste inserts which appear as long strings
//--------------------------------------------------------------------

	char *file, *file1;
	int i, k, m, flg, flg1 = 0;

	i = gtk_entry_get_text_length (entry);

	file = malloc (i + 9);

	if (file == NULL) {
		printf("Out of memory in entry_changed1\n");
		abort();
		}

	file1 = malloc (i + 9);

	if (file1 == NULL) {
		printf("Out of memory in entry_changed1\n");
		abort();
		}

	strcpy(file, gtk_entry_get_text(entry)); // get file name(s)

again:	// multiple names in one string

	flg1 = 0;
	for(k = 0; file[k] != 0; k++) if (file[k] == '\n') {
			flg1 = 1;
			break;
			}
	file[k] = 0;

	if (hexcleaner(file)) { }

//-------------------------------------------------------------------------
//	don't do filetype() on files that don't begin with / as this
//	causes meaningless error messages to be generated.
//-------------------------------------------------------------------------

	if (file[0] == '/' && filetype(file) == DIR) {
		char tmp[4096];
		if (strlen(file) > 4000) return;
		sprintf(tmp,"find \"%s\" -type f > /tmp/player.m3u", file);
		system(tmp);
		printf("Insert directory: %s\n", file);
		strcpy(tmp, "/tmp/player.m3u");
		LoadProgram(tmp);
		return;
		}

//-------------------
//	basename
//-------------------

	i = strlen(file);

	flg = 0;

	if (file[0] == '/') flg=1;
	if (strncmp(file, "smb:", 4) == 0) flg=1;

	for (i = strlen(file); i > 0; i--) if (file[i] == '/') break;

	if (i > 0) strcpy(file1, &file[i + 1]);
	else strcpy(file1, file);

	if (flg) {
		char tmp[1024], *p1;
		FILE *f1;

		strcpy(ProgramArray[Row], file);

		programData[Row]->play = 1; // play it?
		programPlayed[Row] = 0; // play count

		file[i]=0;

		for (i = strlen(file1); i > 0 && file1[i] != '.'; i--);

		if (i == UNRECOGNIZED || i > 99) {
			strcpy(file,"Bad File Type");
			}

		else {
			if (i == 7 || i == 8) file1[strlen(file1) - 5] = 0; // filetype ending removal
			else file1[strlen(file1) - 4] = 0;
			gtk_entry_set_text (GTK_ENTRY(entry), (gchar *) file1);
			while (gtk_events_pending ()) gtk_main_iteration ();
			}
		}

	if ( !flg1 ) goto end;

	if (! strlen(file)) goto end;

	strcpy(file1, &file[k + 1]);

	strcpy(file, file1);
	for (m = 0; file[m] != 0; m++) if (file[m] == '\n') break;
	if (file[m] == 0) goto end; // last row
	paste1(&Row);

	flg1=0;

	if (strncmp(file, "file://", 7) == 0) {
		strcpy(file1, &file[7]);
		strcpy(file, file1);
		}

	if (strlen(file)) {
		goto again;
		}

end:
	free (file);
	free (file1);
	}


// -------------------------------------------------
//	bottom 12 rows of edit panel cut and paste
// -------------------------------------------------

void	paste(int *Row) {

	int i,j,played,playtime, play;
	char time[32],file[512];

	if (strlen(cutRow)) {
		paste1(Row);
		strcpy(ProgramArray[*Row], cutRow);
		programData[*Row]->play = cutPlay;
		programPlayed[*Row] = cutPlayed;
		strcpy(cutRow,"");
		DisplayProgramButtons();
		return;
		}

	if (*Row == copyClipRow) {
		Message("Copy to same row");
		return;
		}

	if (copyClipRow < 0 ) {
		paste1(Row);
		return;
		}

	if (SP->scount + 1 >= PROGRAM_MAX) {
		Message("Maximum number of program slots exceeded");
		return;
		}

	printf("paste() from copyClipRow = %d  to Row = %d scount = %d\n",
	       copyClipRow, *Row, SP->scount ) ;

	strcpy(file, ProgramArray[copyClipRow]);
	play = programData[copyClipRow]->play;
	played = programPlayed[copyClipRow];
	playtime = programTime[copyClipRow];

	delRow(copyClipRow);

	for (i = SP->scount + 1; i > *Row; i--) {        // shift entries up one
		strcpy(ProgramArray[i], ProgramArray[i - 1]);
		programData[i]->play = programData[i - 1]->play;
		programPlayed[i] = programPlayed[i - 1];
		programTime[i] = programTime[i - 1];
		}

	strcpy(ProgramArray[*Row], file);   // insert new entry
	programData[*Row]->play = play;
	programPlayed[*Row] = played;
	programTime[*Row] = playtime;
	(SP->scount)++;
	DisplayProgramButtons();
	copyClipRow = -1;


	}

//--------------- TILE BUTTON DRAG/PRESS EVENT program tiles

//----------------------------------------------------------------------------------------------
//      on_p1_drag_begin on_p2_drag_begin on_p3_drag_begin on_p4_drag_begin
//      on_p5_drag_begin on_p6_drag_begin on_p7_drag_begin on_p8_drag_begin
//      on_p9_drag_begin on_p10_drag_begin on_p11_drag_begin on_p12_drag_begin
//
//      on_p1_drag_drop on_p2_drag_drop on_p3_drag_drop on_p4_drag_drop
//      on_p5_drag_drop on_p6_drag_drop on_p7_drag_drop on_p8_drag_drop
//      on_p9_drag_drop on_p10_drag_drop on_p11_drag_drop on_p12_drag_drop
//
//      on_p1_drag_data_get on_p2_drag_data_get on_p3_drag_data_get on_p4_drag_data_get
//      on_p5_drag_data_get on_p6_drag_data_get on_p7_drag_data_get on_p8_drag_data_get
//      on_p9_drag_data_get on_p10_drag_data_get on_p11_drag_data_get on_p12_drag_data_get
//
//      on_p1_drag_end on_p2_drag_end on_p3_drag_end on_p4_drag_end
//      on_p5_drag_end on_p6_drag_end on_p7_drag_end on_p8_drag_end
//      on_p9_drag_end on_p10_drag_end on_p11_drag_end on_p12_drag_end
//----------------------------------------------------------------------------------------------

#define P_BUTTON_DRAG(NBR) \
        void on_p## NBR ##_drag_begin \
                (GtkWidget *w, GdkDragContext *dc) {  \
                        drag_source =  SP->begin + NBR - 1; \
                        } \
        void on_p## NBR ##_drag_drop \
                (GtkWidget *w, GdkDragContext *dc) {  \
                        drag_target = SP->begin + NBR - 1; \
                        } \
        void on_p## NBR ##_drag_data_get \
                (GtkWidget *w, GdkDragContext *dc) {  } \
			\
        void on_p## NBR ##_drag_end \
                (GtkWidget *w, GdkDragContext *dc) {  \
	                int j = copyClipRow = drag_source ; \
                	int i = drag_target; \
			if (i == 101) { printf("*** Overlay1 \n"); \
				OverlayEntry1_insert_text(j); return; } \
			if (i == 102) { printf("*** Overlay2 \n"); \
				OverlayEntry2_insert_text(j); return; } \
			if (i == 104) { printf("*** Overlay4 \n"); \
				OverlayEntry4_insert_text(j); return; } \
			if (i == 105) { printf("*** Overlay5 \n"); \
				OverlayEntry5_insert_text(j); return; } \
                	if (drag_target < 0 || drag_source < 0 || i > SP->scount || j > SP->scount) { \
                	drag_source = drag_target = -1; return; } \
                	printf("move %d to %d\n\n", drag_source, drag_target); \
                	paste(&i); if (j > i) j++; /*delRow(j);*/ \
                	DisplayProgramButtons(); \
                	drag_source = drag_target = -1; }

void	on_OverlayEntry1_drag_drop(GtkWidget *w, GdkDragContext *dc) {
	drag_target = 101;
	}
void	on_OverlayEntry2_drag_drop(GtkWidget *w, GdkDragContext *dc) {
	drag_target = 102;
	}
void	on_OverlayEntry4_drag_drop(GtkWidget *w, GdkDragContext *dc) {
	drag_target = 104;
	}
void	on_OverlayEntry5_drag_drop(GtkWidget *w, GdkDragContext *dc) {
	drag_target = 105;
	}


P_BUTTON_DRAG(1) P_BUTTON_DRAG(2)  P_BUTTON_DRAG(3)  P_BUTTON_DRAG(4)
P_BUTTON_DRAG(5) P_BUTTON_DRAG(6)  P_BUTTON_DRAG(7)  P_BUTTON_DRAG(8)
P_BUTTON_DRAG(9) P_BUTTON_DRAG(10) P_BUTTON_DRAG(11) P_BUTTON_DRAG(12)

