/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2019 - 2025 by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	September 10, 2025

#include "includes.h"
#include "defines.h"
#include "common-externs.h"
#include "common-fcn-headers.h"
#include "global-extern-variables.h"

#include <vlc/libvlc.h>
#include <vlc/libvlc_renderer_discoverer.h>
#include <vlc/libvlc_media.h>
#include <vlc/libvlc_media_player.h>

#define SLASH '/'

//---------------------------------------------------------------------------------------------
//	libvlc_video_set_crop_border is missing in libvlc version 3 but present in version 4
//	libvlc_video_set_crop_border(mediaPlayer, 111,111,111,111); does not exist in vwersion 3
//	libvlc_video_set_crop_window(mediaPlayer, 111,111,111,111); does not exist in vwersion 3
//---------------------------------------------------------------------------------------------


void    on_crop_left_value_changed( GtkSpinButton *s, GtkScrollType scr) {

	if (!mediaPlayer) return;

	if (rotation != 0) {
		zippy_says("Cropping not supported on cell phone rotations other than 0.\n");
		return;
		}

	gdouble x = (int) gtk_adjustment_get_value(adjustment6);

	if ((int) x > frame_width - 10) {
		gtk_adjustment_set_value(adjustment6, (gdouble) (frame_width - 10));
		return;
		}

	cropLeft = x;

	int rslt = libvlc_video_get_size (mediaPlayer, 0, &frame_width, &frame_height);

	if ((int) cropLeft > frame_width) cropLeft = frame_width;

	gtk_spin_button_set_value (s, x);
	while (gtk_events_pending()) gtk_main_iteration();

#ifdef VLC4
//	libvlc_video_set_crop_window(mediaPlayer, cropLeft, cropTop, cropRight-cropLeft, cropBottom-cropTop);
	libvlc_video_set_crop_border(mediaPlayer, cropLeft, cropRight, cropTop, cropBottom);
#else
	char tmp[64];
	sprintf(tmp, "%d+%d+%d+%d", (int) cropLeft, (int) cropTop,
	        (int) cropRight, (int) cropBottom);
	libvlc_video_set_crop_geometry(mediaPlayer, tmp);
#endif

	}


void    on_crop_right_value_changed( GtkSpinButton *s, GtkScrollType scr) {

	if (!mediaPlayer) return;

	if (rotation != 0) {
		zippy_says("Cropping not supported on cell phone rotations other than 0.\n");
		return;
		}

	gdouble x = (int) gtk_adjustment_get_value(adjustment7);

	if ((int) x > frame_width - 10) {
		gtk_adjustment_set_value(adjustment7, (gdouble) (frame_width - 10));
		return;
		}

	cropRight = x;

	int rslt = libvlc_video_get_size (mediaPlayer, 0, &frame_width, &frame_height);

	if ((int) cropRight > frame_width) cropRight = frame_width;


	gtk_spin_button_set_value (s, x);
	while (gtk_events_pending()) gtk_main_iteration();


#ifdef VLC4
//      libvlc_video_set_crop_window(mediaPlayer, cropLeft, cropTop, cropRight-cropLeft, cropBottom-cropTop);
	libvlc_video_set_crop_border(mediaPlayer, cropLeft, cropRight, cropTop, cropBottom);
#else
	char tmp[64];
	sprintf(tmp, "%d+%d+%d+%d", (int) cropLeft, (int) cropTop,
	        (int) cropRight, (int) cropBottom);
	libvlc_video_set_crop_geometry(mediaPlayer, tmp);
#endif

	}

void    on_crop_top_value_changed( GtkSpinButton *s, GtkScrollType scr) {

	if (!mediaPlayer) return;

	if (rotation != 0) {
		zippy_says("Cropping not supported on cell phone rotations other than 0.\n");
		return;
		}

	gdouble x = (int) gtk_adjustment_get_value(adjustment40);

	if ((int) x > frame_height - 10) {
		gtk_adjustment_set_value(adjustment40, (gdouble) (frame_height - 10));
		return;
		}

	cropTop = x;

	int rslt = libvlc_video_get_size (mediaPlayer, 0, &frame_width, &frame_height);

	if ((int) cropTop > frame_height) cropTop = frame_height;

	gtk_spin_button_set_value (s, x);
	while (gtk_events_pending()) gtk_main_iteration();


#ifdef VLC4
//      libvlc_video_set_crop_window(mediaPlayer, cropLeft, cropTop, cropRight-cropLeft, cropBottom-cropTop);
	libvlc_video_set_crop_border(mediaPlayer, cropLeft, cropRight, cropTop, cropBottom);
#else
	char tmp[64];
	sprintf(tmp, "%d+%d+%d+%d", (int) cropLeft, (int) cropTop,
	        (int) cropRight, (int) cropBottom);
	libvlc_video_set_crop_geometry(mediaPlayer, tmp);
#endif

	}


void    on_crop_bottom_value_changed( GtkSpinButton *s, GtkScrollType scr) {

	if (!mediaPlayer) return;

	if (rotation != 0) {
		zippy_says("Cropping not supported on cell phone rotations other than 0.\n");
		return;
		}

	gdouble x = (int) gtk_adjustment_get_value(adjustment54);

	if ((int) x > frame_height - 10) {
		gtk_adjustment_set_value(adjustment54, (gdouble) (frame_height - 10));
		return;
		}

	cropBottom = x;

	int rslt = libvlc_video_get_size (mediaPlayer, 0, &frame_width, &frame_height);

	if ((int) cropTop > frame_height) cropBottom = frame_height;

	gtk_spin_button_set_value (s, x);
	while (gtk_events_pending()) gtk_main_iteration();


#ifdef VLC4
//      libvlc_video_set_crop_window(mediaPlayer, cropLeft, cropTop, cropRight-cropLeft, cropBottom-cropTop);
	libvlc_video_set_crop_border(mediaPlayer, cropLeft, cropRight, cropTop, cropBottom);
#else
	char tmp[64];
	sprintf(tmp, "%d+%d+%d+%d", (int) cropLeft, (int) cropTop,
	        (int) cropRight, (int) cropBottom);
	libvlc_video_set_crop_geometry(mediaPlayer, tmp);
#endif
	}


void	on_crop_reset_clicked(GtkWidget *w) {

	cropLeft = 0.0;
	cropTop = 0.0;
	cropRight = 0.0;
	cropBottom = 0.0;

	gtk_adjustment_set_value (adjustment40, 0.0);
	gtk_adjustment_set_value (adjustment54, 0.0);
	gtk_adjustment_set_value (adjustment6, 0.0);
	gtk_adjustment_set_value (adjustment7, 0.0);

	}


void	on_crop_video_toggled(GtkWidget *w) {

	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(crop_video)))  {

		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(overlay_clip), FALSE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(overlay_clip1), FALSE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(insert_text), FALSE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(adjust_video), FALSE);
		while (gtk_events_pending ()) gtk_main_iteration ();

		gtk_widget_hide(insert_panel);
		gtk_widget_hide(ovl_fixed);
		gtk_widget_hide(ovl_fixed1);
		gtk_widget_hide(opt_panel);

		gtk_widget_hide(draw2);
		gtk_widget_hide(join_group17);

		gtk_widget_show(crop_adj);

		}
	else {
		gtk_widget_hide(crop_adj);

		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(frame_next))) {
			gtk_widget_show(draw2);
			gtk_widget_show(join_group17);
			}

		return;
		}

	if (mediaPlayer == NULL) {
		zippy_says("No media player currently in use.\n");
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(crop_video), FALSE);
		gtk_widget_hide(crop_adj);
		return;
		}

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(frame_next), TRUE); // vlc_pause();
	while (gtk_events_pending ()) gtk_main_iteration ();


	}
