/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018 - 2025 Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

// December 4, 2025

#ifndef COMMON_FCN_HEADERS
#define COMMON_FCN_HEADERS

int lastWord(char *, int);
int main_vu();
int	file_parms(char *file);
void on_p1_drag_end(GtkWidget *w, GdkDragContext *dc);
void on_p2_drag_end(GtkWidget *w, GdkDragContext *dc);
void on_p3_drag_end(GtkWidget *w, GdkDragContext *dc);
void on_p4_drag_end(GtkWidget *w, GdkDragContext *dc);
void on_p5_drag_end(GtkWidget *w, GdkDragContext *dc);
void on_p6_drag_end(GtkWidget *w, GdkDragContext *dc);
void on_p7_drag_end(GtkWidget *w, GdkDragContext *dc);
void on_p8_drag_end(GtkWidget *w, GdkDragContext *dc);
void on_p9_drag_end(GtkWidget *w, GdkDragContext *dc);
void on_p10_drag_end(GtkWidget *w, GdkDragContext *dc);
void on_p11_drag_end(GtkWidget *w, GdkDragContext *dc);
void on_p12_drag_end(GtkWidget *w, GdkDragContext *dc);
void	memory_alloc();
void    gtkSetCursor(GdkCursorType cursorType);
void    ffmpeg_vid(int pflag);
void    overlay1_vid(int preview);
void	marquee_show();
void	OverlayEntry1_insert_text(int X);
void	OverlayEntry2_insert_text(int X);
void	OverlayEntry3_insert_text(int X);
void	OverlayEntry4_insert_text(int X);
void	OverlayEntry5_insert_text(int X);
void	on_OverlayEntry1_insert_text(GtkEditable  *entry, gchar *edit);
void	on_OverlayEntry2_insert_text(GtkEditable  *entry, gchar *edit);
void	on_OverlayEntry3_insert_text(GtkEditable  *entry, gchar *edit);
void	on_OverlayEntry4_insert_text(GtkEditable  *entry, gchar *edit);
void	on_OverlayEntry5_insert_text(GtkEditable  *entry, gchar *edit);
void    update_vlcPosition();
int	file_probe(char * in_file, char * source_file, char *geo_rslt);
void	on_scroll_down_clicked(GtkWidget *);
void	on_scroll_up_clicked(GtkWidget *);
void	on_halt_ffmpeg_clicked(GtkWidget *);
void	on_start_mark_clicked(GtkWidget *w);
void	on_end_mark_clicked(GtkWidget *w);
void	on_play_clip_clicked(GtkWidget *w);
void	on_clear_clip_clicked(GtkWidget *w);
void on_move_to_start_clicked(GtkWidget *);
void on_move_to_end_clicked(GtkWidget *w);
void	vid_fmt_std(char *, char *, char *, char *);
int	geo_test(char *, char *);
void    on_date_sort_clicked(GtkWidget *);
void    buttonColor(int, GtkWidget *, int);
void	on_update_times_clicked(GtkWidget *);
void	close_boxes();
void	on_scan_video_dir_clicked(GtkWidget *);
void	clear_play();
void     preview_run(char *);
int	file_stat(char *);
int     ff_run(char *, char *, int);
int	showImage(GtkWidget *image, char * file, int width, int height);
int	albumImage(GtkWidget *image, char * file, int width, int height);
int	empty_dir(char *);
int	ffrun(char *);
int	wipe(char *, char *, char *, int);
int	filetype(char *);
int	albumImage(GtkWidget *image, char *file, int width, int height);
int	DisplayCover(char *file);
int	filetype(char *);
int	geotest(int, int);
int	new_name(char *, char *, char *);
int	new_name1(char *, char *);
int	file_exists(char *);
int	hexcleaner(char *t);
int	nextSelection();
int	showImage(GtkWidget *image, char *file, int width, int height);
int	vlc_start();
int	vlc_stop();
int	delDialog(char *);
int	mainx (char * srch, int);
int	vlc_playing();

double	GetTime (char *file);

char*	mhd_ref(char *file, char *returned_ref);
char*	mhd_ref1(char *file, char *returned_ref);
char*	mediaProbe(char *);
char* 	shuffle(int, char *);

gboolean	picture_handler(struct APW *widgets);
gboolean	scroll_event(GdkEventScroll *e);
gboolean        timer_handler(struct APW *widgets);
gboolean        on_window_main_configure(GtkWindow *window, GdkEvent *event);

void    remove_prior_thumbnail(char *, int);
void    thumbnail_name(char *, char *);
void	tiled_button_clicked();
void	join_button_clicked();
void	audio_modify();
void	forward_move(int);
void	back_move(int);
void	frame_update();
void	run_command(char *, char *);
void	on_scan_video_dir(GtkWidget *);
void	join_fade_clicked(char *, int);
void	timer_section1();
void	zippy_says(char *);
void	addToTop (char * file);
void	get_meta(libvlc_media_t *media);
void	PauseOff ();
void	programButtonLoad(GtkWidget *, int);
void	SwapProgramElement (int row);
void	vlc_no_pause();
void	vlc_pause();
void	WindowsCallBacks();
void	ClearPlayers();
void	createPresets();
void	entry_changed1 (GtkEntry *entry, gchar *preedit, gpointer  user_data, int Row);
void	entry_insert(GtkEditable  *entry, gchar *edit);
void	FileChooser (GtkFileChooserButton *b);
void	LoadProgram(char *);
void	meters_handler(GtkButton *b);
void	moveOneToBottom (int row);
void	moveOneToTop (int row);
void	paste1(int *Row);
void	delRow(int Row);
void	DisplayProgramButtons(void);
void	Message(char *);
void	moveToBottom (int row);
void	moveToTop (int row);
void	on_haltProgram_clicked (GtkButton *button);
void	on_window_main_destroy();
void	paste(int *Row);
void	PlayClip (GtkButton *, GtkEntry *, int);
void    updateTimes(int pa_nbr, int show_nbr);
void	on_destroy();
void	reset_clipper();

void strip(char* str);
char *  ProgramName(char * name, int nbr);

#endif

