/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018 - 2025 by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#+	astyle --style=banner --indent=tab load-program.c.in
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	December 22, 2025

#include "includes.h"
#include "defines.h"
#include "common-externs.h"
#include "common-fcn-headers.h"

#include "global-extern-variables.h"

#include <vlc/libvlc.h>
#include <vlc/libvlc_renderer_discoverer.h>
#include <vlc/libvlc_media.h>
#include <vlc/libvlc_media_player.h>

#define SLASH '/'

int     hexcleaner(char *t) {

	char *_ftmp;
	int m, n = 0, p,f = 0;

	int i = strlen(t);

	_ftmp = (char *) malloc(i + 1);

	if (_ftmp == NULL ) {
		printf("Out of memory in hexcleaner\n");
		abort();
		}

	for(m=0; t[m]; m++) {

		if (t[m] == '\n' ) {
			f = 1;
			continue;
			}
		if (t[m] == '\r' ) {
			f = 1;
			continue;
			}

		if (t[m] == '%') {

			f = 1;
			if (t[m+1] >= 'a' && t[m+1] <= 'z') t[m+1] = t[m+1]-32;
			if (t[m+1] >= '0' && t[m+1] <= '9') p=( t[m+1]-'0' ) * 16;
			else p=(t[m+1]-'A'+10)*16;

			if (t[m+2] >= 'a' && t[m+2] <= 'z') t[m+2] = t[m+2]-32;
			if (t[m+2] >= '0' && t[m+2] <= '9') p = p+(t[m+2]-'0');
			else p = p + (t[m+2] - 'A' + 10);

			_ftmp[n] = p;  /* insert value into output string */
			n++;
			m = m + 2;
			}

		else {
			_ftmp[n++] = t[m];
			}
		}

	_ftmp[n]=0;
	strcpy(t,_ftmp);
	free(_ftmp);
	return f;
	}


void on_dialog_response (GtkWidget *dialog, gint response_id) {
	gtk_window_set_keep_above(GTK_WINDOW(dialog), FALSE);
	gtk_widget_destroy (dialog);
	return;
	}


void    Message(char * msg) {

	return; // unknow errors - won't destroy dislog
	if (strlen(msg) == 0) return;

	GdkColor color1;
	color1.red = 0x1111;
	color1.green = 0x1111;
	color1.blue = 0x9999;

	GdkColor color2;
	color2.red = 0xFFFF;
	color2.green = 0xFFFF;
	color2.blue = 0x0000;

	GtkDialogFlags flags = GTK_DIALOG_DESTROY_WITH_PARENT ;

	GtkWidget *dialog = gtk_dialog_new_with_buttons ("Message", GTK_WINDOW(window),
	                    flags,
	                    "_OK", GTK_RESPONSE_CLOSE,
	                    NULL);

//	gtk_signal_connect (dialog, "close",

	g_signal_connect (dialog, "close",
	                    G_CALLBACK (on_dialog_response), NULL);

	gtk_widget_modify_bg(dialog, GTK_STATE_NORMAL, &color1);
	gtk_widget_modify_fg(dialog, GTK_STATE_NORMAL, &color2);

	gtk_window_set_keep_above(GTK_WINDOW(dialog), TRUE);

	gtk_dialog_run (GTK_DIALOG (dialog));

	gtk_widget_destroy (dialog);
	}


void	gtk_widget_destroy(GtkWidget *w) { }

gboolean on_clip_markers_draw (GtkDrawingArea *widget, cairo_t *cr) {

	time_t 	len;
	double begin, end;

	if (mediaPlayer == NULL) return FALSE;

//---------------------
//	total length
//---------------------

	len = libvlc_media_player_get_length (mediaPlayer); // milliseconds

	end = clip_end;

	gint da_width, da_height;
	gtk_widget_get_size_request (GTK_WIDGET(widget), &da_width, &da_height);

	begin =
	    ((double) clip_start / (double) len) * (double) da_width; // da_width width of draw window

	end = ((double)(end) / (double) len) * (double) da_width;

	if (begin < end) {

		cairo_set_source_rgba(cr, 1.0, 0.2, 0.8, 1.0);
		cairo_rectangle (cr, begin, 0.0, end - begin, 10.);

		cairo_fill(cr); // fill in arc
		cairo_stroke (cr);

		}

	return FALSE;
	}

void	on_clear_clip_clicked(GtkWidget *w) {
	if (!mediaPlayer) return;
	vlc_no_pause();
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(full_speed), TRUE) ;
	clip_start = clip_end = 0;

#ifdef VLC4
	libvlc_media_player_set_time(mediaPlayer, 0, FALSE);
#else
	libvlc_media_player_set_time(mediaPlayer, 0);
#endif

	programData[SP->NowPlaying]->last_location = 0;
	frame_width = 0;
	frame_height = 0;
	mouse_ul_x = -1;
	vlc_start();
	gtk_widget_queue_draw(clip_markers);
	}


void    on_in_fade_value_changed(GtkSpinButton *s) {
	infade = gtk_spin_button_get_value(s);
	}

void    on_clip_duration_spinner_value_changed(GtkSpinButton *s) {
	clip_duration = gtk_spin_button_get_value(s);
	}

void    on_trans_duration_value_changed( GtkSpinButton *s) {
	trans_duration = gtk_spin_button_get_value(s);
	}

void    on_out_fade_value_changed( GtkSpinButton *s) {
	outfade = gtk_spin_button_get_value(s);
	}

void	reset_clipper() {
	cropLeft = 0.0, cropRight = 0.0;
	cropTop = 0.0, cropBottom = 0.0;
	outfade = gtk_spin_button_get_value(GTK_SPIN_BUTTON(out_fade));
	infade = gtk_spin_button_get_value(GTK_SPIN_BUTTON(in_fade));
	frame_height = 0;
	frame_width = 0;
	gtk_adjustment_set_value (adjustment40, 0.0);
	gtk_adjustment_set_value (adjustment54, 0.0);
	gtk_adjustment_set_value (adjustment6, 0.0);
	gtk_adjustment_set_value (adjustment7, 0.0);
	gtk_adjustment_set_value (adjustment1, 0.0);
	x_offset = 0;
	y_offset = 0;
	}

void	on_snapshot_clicked(GtkWidget *w) {

	close_boxes();

	if (!mediaPlayer) {
		zippy_says("No media playing.\n");
		return;
		}

	char tmp[16000];
	time_t t = time(0);
	new_name1(tmp, "snapshot.png");
	sprintf(tmp, "%s", tmp);
	printf("Snapshot:  %s\n",tmp);
	libvlc_video_take_snapshot(mediaPlayer,0, tmp, 0, 0);

	clear_play();

	on_scan_video_dir_clicked(NULL);

	}


void	on_full_speed_clip_pressed(GtkWidget *w) { // radio button
	}

void	on_half_speed_clip_pressed(GtkWidget *w) {
	}


void	clear_play() {
	for (int i = 0; i < SP->scount; i++)
		programData[i]->play = 0;
	DisplayProgramButtons();
	}

void    on_dxb8_clicked(GtkButton *b) { // clear button
	zippy_says("");
	TextBuffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW(dbox4_tv));
	gtk_text_buffer_set_text (TextBuffer, (const gchar *) "", (gint) -1);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(view_log), TRUE);
	gtk_widget_hide(g_dbox4);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(view_log), FALSE);
	}

void    on_dxb7_clicked(GtkButton *b) { // ok button
	gtk_widget_hide(g_dbox4);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(view_log), FALSE);
	}

void	on_scan_video_dir_clicked(GtkWidget *w) {

	char tmp[8192];

	printf("Scan video directory\n");

	sprintf(tmp, "rm -f \"%s/frames/\"*.jpg", Code_Home);
	printf("%s\n", tmp);
	system(tmp);

	SP->scount = 0;

	buttonColor(-1, NULL, 0); // clear current image array

	DisplayProgramButtons();
	while (gtk_events_pending()) gtk_main_iteration();

//	sprintf(tmp, "\"%s/frames/\"*.jpg", Code_Home);
//	int i = empty_dir(tmp);
	int i = empty_dir(Music_Home_Directory);

//-------------------------------------------------------
//	populate program.lst
//	full addresses of files
//	system("readlink -f videos/* > program.lst");
//-------------------------------------------------------

	if (i == 0)
		sprintf(tmp, "cat /dev/null > \"%s\"", Program_List);
	else
		sprintf(tmp, "readlink -f \"%s/\"* > \"%s\"",
		        Music_Home_Directory, Program_List);

	printf("Directory Scan: %s\n", tmp);

	int err_stat = system(tmp);

	if (err_stat != 0) {
		zippy_says("An error occurred\n");
		return;
		}

	LoadProgram(Program_List);
	on_date_sort_clicked(NULL);

	DisplayProgramButtons( );
	on_update_times_clicked(NULL);

	}

void	on_view_log_toggled(GtkWidget *w) {

	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)) )
		gtk_widget_show(g_dbox4);  // show dialog
	else
		gtk_widget_hide(g_dbox4);  // hide dialog

	}

void	on_halt_ffmpeg_clicked(GtkWidget *w) {

	system("killall -q -s INT ffmpeg");
	system("killall -q -s INT ffplay");

	DisplayProgramButtons();

	}

void	on_clear_all_clicked(GtkWidget *w) {

	int i;

	for (i = 0; i < (SP->scount); i++) {
		programData[i]->play = 0;
		}
	DisplayProgramButtons( );
	}

void	on_select_all_clicked(GtkWidget *w) {

	int i;

	for (i = 0; i < (SP->scount); i++) {
		programData[i]->play = 1;
		}

	DisplayProgramButtons( );
	}

void	on_play_clip_clicked(GtkWidget *w) {

	if (!mediaPlayer) return;

#ifdef VLC4
	libvlc_media_player_set_time(mediaPlayer, clip_start, FALSE);
#else
	libvlc_media_player_set_time(mediaPlayer, clip_start);
#endif

	vlc_no_pause();

	}


void    on_granularity_value_changed( GtkSpinButton *s, GtkScrollType scr) {

	gdouble x = (int) gtk_adjustment_get_value(adjustment20);

	gtk_adjustment_set_step_increment (adjustment6, x);
	gtk_adjustment_set_step_increment (adjustment7, x);
	gtk_adjustment_set_step_increment (adjustment54, x);
	gtk_adjustment_set_step_increment (adjustment40, x);

	}

void    on_frame_forward2_value_changed(GtkSpinButton *r) { // start clip

	if (!mediaPlayer) return;

	if (ignore_me) {
		ignore_me = 0;
		return;
		}

	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(frame_next)))
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(frame_next), FALSE);

	gdouble x = gtk_spin_button_get_value(r);

	t_position = x * 1000;

	clip_start = t_position;

	ignore_me = 1;

	frame_update();

	gtk_widget_queue_draw(clip_markers);

	}

void    on_frame_forward1_value_changed(GtkSpinButton *r) { // end clip

	if (!mediaPlayer) return;

	if (ignore_me) {
		ignore_me = 0;
		return;
		}

	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(frame_next)))
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(frame_next), FALSE);

	gdouble x = gtk_spin_button_get_value(r);

	t_position = x * 1000;

	clip_end = t_position;

	ignore_me = 1;

	frame_update();

	gtk_widget_queue_draw(clip_markers);

	}

void	on_frame_reset_clicked(GtkWidget *w) {

	if (!mediaPlayer) return;
	clip_start = 0;
	clip_end = 0;
	ignore_me = 1;
	gtk_adjustment_set_value(adjustment22, 0.0);
	while (gtk_events_pending()) gtk_main_iteration();
	ignore_me = 1;
	gtk_adjustment_set_value(adjustment23, 0.0);
	while (gtk_events_pending()) gtk_main_iteration();
	}

void	on_check_format_clicked(GtkWidget *w) {

	int i, first = -1, second = -1;

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(frame_next), TRUE);

	for (i = 0; i < SP->scount; i++) {
		if (programData[i]->play) {
			first = i;
			break;
			}
		}

	if (first < 0) {
		zippy_says("No checked rows found\n");
		return;
		}

	for (i = first + 1; i < SP->scount; i++) {
		if (programData[i]->play) {
			second = i;
			int t = geo_test(ProgramArray[first], ProgramArray[second]);
			if (t == 0 ) {
				return;
				}
			first = second;
			}
		}

	zippy_says("No problems\n");

	}

void	close_boxes() {

	if (!mediaPlayer)
		if (!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(frame_next)))
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(frame_next), TRUE);

	}

//------------------------------------------------------
//	The following should not occur under Linux but
//	do, at present, under WSL2 Linux.
//------------------------------------------------------

gboolean on_merge_fixed_delete_event ( GtkWidget* w) {
	gtk_widget_hide(w);
	return TRUE;
	}


gboolean on_dbox4_delete_event ( GtkWidget* w) {
	gtk_widget_hide(w);
	return TRUE;
	}


void    strip(char* str) {
	int i, x;
	for(i = x = 0; str[i]; ++i)
		if( !isspace(str[i] ) || (i > 0 && !isspace(str[i - 1])))
			str[x++] = str[i];
	str[x] = '\0';
	}


//-----------------------------------------------------------------
//      cursors can be found here:
//      http://developer.gimp.org/api/2.0/gdk/gdk-Cursors.html
//-----------------------------------------------------------------

void    gtkSetCursor(GdkCursorType cursorType) {

	GdkScreen * screen = gdk_screen_get_default();
	GdkWindow * win = gdk_screen_get_root_window(screen);
	GdkCursor * cursor = gdk_cursor_new(cursorType);
	gdk_window_set_cursor(win, cursor);
	while (gtk_events_pending()) gtk_main_iteration();
	}

void    on_audio_ok_clicked(GtkButton *b) { // ok button dbx9

	close_boxes();

	audio_modify();

	clear_play();
	}

int	lastWord(char *x, int y) { 
	zippy_says("lastWord function error.\n");
	abort();
	return 0; 
	};
