/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018 - 2025 by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//      September 10, 2025

#include "includes.h"
#include "defines.h"
#include "common-externs.h"
#include "common-fcn-headers.h"


#include <vlc/libvlc.h>
#include <vlc/libvlc_renderer_discoverer.h>
#include <vlc/libvlc_media.h>
#include <vlc/libvlc_media_player.h>

#define SLASH '/'


void	on_start_mark_clicked(GtkWidget *w) {

	if (!mediaPlayer) return;

	if (!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(frame_next)))
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(frame_next), TRUE);

	clip_start = libvlc_media_player_get_time(mediaPlayer);

	ignore_me = 1;

	gtk_adjustment_set_value(adjustment22, clip_start/1000.0);

	gtk_widget_queue_draw (clip_markers);

	while (gtk_events_pending ()) gtk_main_iteration ();

	}


void	on_end_mark_clicked(GtkWidget *w) {

	if (!mediaPlayer) return;

	ignore_me = 1;

	clip_end = libvlc_media_player_get_time(mediaPlayer);

	gtk_adjustment_set_value(adjustment23, clip_end/1000.0);

	if (!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(frame_next)))
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(frame_next), TRUE);

	gtk_widget_queue_draw (clip_markers);

	while (gtk_events_pending ()) gtk_main_iteration ();
	}


void	on_move_to_start_clicked(GtkWidget *w) {

	if (!mediaPlayer) return;

#ifdef VLC4
	libvlc_media_player_set_time(mediaPlayer, clip_start, FALSE);
#else
	libvlc_media_player_set_time(mediaPlayer, clip_start);
#endif

	double position =
	    libvlc_media_player_get_position(mediaPlayer); // {0:1}

	gtk_range_set_value (GTK_RANGE(vlcPosition), position*99.0);

	t_position = clip_start;

	}


void	on_move_to_end_clicked(GtkWidget *w) {

	if (!mediaPlayer) return;

	t_position = clip_end;

#ifdef VLC4
	libvlc_media_player_set_time(mediaPlayer, clip_end, FALSE);
#else
	libvlc_media_player_set_time(mediaPlayer, clip_end);
#endif

	double position =
	    libvlc_media_player_get_position(mediaPlayer); // {0:1}

	gtk_range_set_value (GTK_RANGE(vlcPosition), position*99.0);

	t_position = clip_end;

	}

