/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+
#+     Internet Radio Automation & Encoding Toolkit
#+
#+     Copyright (C) 2018  - 2025 by Kevin C. O'Kane
#+
#+     Kevin C. O'Kane
#+     kc.okane@gmail.com
#+     https://www.cs.uni.edu/~okane
#+     https://threadsafebooks.com/
#+
#+ This program is free software; you can redistribute it and/or modify
#+ it under the terms of the GNU General Public License as published by
#+ the Free Software Foundation; either version 2 of the License, or
#+ (at your option) any later version.
#+
#+ This program is distributed in the hope that it will be useful,
#+ but WITHOUT ANY WARRANTY; without even the implied warranty of
#+ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#+ GNU General Public License for more details.
#+
#+ You should have received a copy of the GNU General Public License
#+ along with this program; if not, write to the Free Software
#+ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#+
#+	astyle --style=banner --indent=tab Zippy.c.in
#+
#++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

//	Nov 22, 2025

//------------------------------------------------------------------
//	This is the root file for the Linux version of the player
//------------------------------------------------------------------

#define _GNU_SOURCE

#include "common/includes.h"
#include "common/structures.h"
#include "common/defines.h"
#include "common/common-fcn-headers.h"
#include "common/global-vars.h"
#include "common/common-widgets.h"
#include "common/common-externs.h"

#define WSL2 0
#define DEBIAN

void    sigint(int s) {
	printf("\nSignal received: %d %d\n\n", s, SIGUSR1);
	on_scan_video_dir_clicked(NULL);
	}

// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// main main main main main main main main main main main main main
// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

int main(int argc, char *argv[]) {

	char cmd[2048], tmp[8196];
	int i, j, k, m, n;

//--------------------------------------------------------------
//	Following must be called before any other X11 calls
//	Needed in order to enable vdpau in vlc in Windows WSL2
//--------------------------------------------------------------

	setenv("GDK_BACKEND", "x11", 1);
	setenv("AV_LOG_FORCE_NOCOLOR", "1", 1);

	XInitThreads();

	printf("\n-------- S T A R T-------------------------------\n");

//-----------------------------------------------------------------------------
//	The setting of the GDK_BACKEND above to x11 appears to solve the
//	Wayland problem the following was written to address but the code
//	is retained in case the problem comes back.
//
//	{	char *p = getenv("XDG_SESSION_TYPE");
//		if (p == NULL) {
//			p = getenv("GDK_BACKEND");
//			if (p == NULL) {
//				strcpy(session_type, "NULL");
//				}
//			else strcpy(session_type, p);
//			}
//
//		else strcpy(session_type, p);
//		}
//
//	printf("*** session type: %s\n", session_type);
//-----------------------------------------------------------------------------

	srand( (unsigned int) time(0) );

	vlc_moved = -1.0;

//------------------
//      Tile colors
//------------------

	cover.red = TILE_ALBUM_MARKER_RED;
	cover.green = TILE_ALBUM_MARKER_GREEN;
	cover.blue = TILE_ALBUM_MARKER_BLUE;

	webplay.red = TILE_WEB_RED;
	webplay.green = TILE_WEB_GREEN;
	webplay.blue = TILE_WEB_BLUE;

	unplayed.red = TILE_UNPLAYED_RED;
	unplayed.green = TILE_UNPLAYED_GREEN;
	unplayed.blue = TILE_UNPLAYED_BLUE;

	played.red = TILE_PLAYED_RED;
	played.green = TILE_PLAYED_GREEN;
	played.blue = TILE_PLAYED_BLUE;

	notplayable.red = LOW_TRAY_NOT_PLAYABLE_RED;
	notplayable.green = LOW_TRAY_NOT_PLAYABLE_GREEN;
	notplayable.blue = LOW_TRAY_NOT_PLAYABLE_BLUE;

	playing.red = TILE_PLAYING_RED;
	playing.green = TILE_PLAYING_GREEN;
	playing.blue = TILE_PLAYING_BLUE;

	low_tray.red = 0x0000;
	low_tray.green = 0x9999;
	low_tray.blue = 0x0000;

//---------------------------------------
//	ffmpeg interface
//	must be called here - do not move.
//---------------------------------------

	memory_alloc();

//----------------------------------------------------------------------
//	Establish the location for the code directory
//	The files 'program.lst' and 'sounders.config' should be here.
//	'program.lst' contains the references to the music files.
//----------------------------------------------------------------------

	char *home_env = getenv("HOME");

	if (Code_Home == NULL) {
		printf("*** Unable to locate HOME envirnment variable.\n");
		return EXIT_FAILURE;
		}

	strcpy(Code_Home, home_env);

	strcat(Code_Home, "/sgr-zippy");

	strcpy(tmp, "mkdir -p \"");
	strcat(tmp, Code_Home);
	strcat(tmp, "\"");
	system(tmp);

	strcpy(tmp, "mkdir -p \"");
	strcat(tmp, Code_Home);
	strcat(tmp, "/videos\"");
	system(tmp);

	strcpy(tmp, "mkdir -p \"");
	strcat(tmp, Code_Home);
	strcat(tmp, "/videos/stills\"");
	system(tmp);

	strcpy(tmp, "mkdir -p \"");
	strcat(tmp, Code_Home);
	strcat(tmp, "/frames\"");
	system(tmp);

	strcpy(tmp, "echo \"SGR Zippy\" > ");
	strcat(tmp, Code_Home);
	strcat(tmp, "/title.txt");
	system(tmp);

	printf("Code home directory: %s\n", Code_Home);

	strcpy(Program_List, "\"");
	strcat(Program_List,Code_Home);
	strcat(Program_List,"/videos/program.lst");	// file address of tmp.lst
	strcat(Program_List, "\"");

	printf("Code Home: %s\n", Code_Home);

	strcpy(Music_Home_Directory, Code_Home);
	strcat(Music_Home_Directory, "/videos");

	printf("Music Home Directory: %s\n", Music_Home_Directory);

	printf("Sounder Max: %d\n", PROGRAM_MAX);
	printf("Program List: %s\n\n", Program_List);

//------------------------
//      init constants
//------------------------

	copyClipRow=-1;
	strcpy(cutRow,"");
	strcpy(top1,"");
	strcpy(top2,"");
	strcpy(top3,"");
	cutPlayed=0;
	cutPlay=0;

//----------------------------------------------------------------
//      allocate memory for program entries
//----------------------------------------------------------------

	for (i=0; i < PROGRAM_MAX; i++ ) {

//-------------------------------------
//	allocate shared memory for ST
//-------------------------------------

		programData[i] = (struct ST *) malloc(sizeof(struct ST));

		programData[i]->play = 0; // play it?
		programData[i]->last_location = 0; // last point played
		programPlayed[i] = 0; // play count
		programTime[i] = -1;
		}

//------------------------------------------------------------------
//      PGM_MAX is the maximum length of a line in the program list
//------------------------------------------------------------------

	SP->scount = 0;

	while(SP->scount < PROGRAM_MAX) { // blank out entire list

		ProgramArray[SP->scount] = (char *) malloc(PGM_MAX);
		strcpy(ProgramArray[SP->scount],"");
		programData[SP->scount]->play = 0;
		programPlayed[SP->scount] = 0; // play count
		(SP->scount)++;
		}

	widgets = (struct APW*) malloc(sizeof(struct APW));

	gtk_init(&argc, &argv);

//---------------------------------------------------------------------
// establish contact with xml code used to adjust widget settings
//---------------------------------------------------------------------

	builder = gtk_builder_new_from_resource ("/part1/Zippy.glade");

	window = GTK_WIDGET(gtk_builder_get_object(builder, "window_main"));

	gtk_builder_connect_signals(builder, NULL);

	g_signal_connect(window, "destroy", G_CALLBACK(on_window_main_destroy), NULL);

	gtk_widget_add_events(GTK_WIDGET(window), GDK_CONFIGURE);
	g_signal_connect(window, "configure-event", G_CALLBACK(on_window_main_configure), NULL);

//---------------------------------------------------------------------
// get the definitions of the major components / widgets
//---------------------------------------------------------------------

#include "common/common-objects.h"

//-------------------------------------
//
//	import GTK theme for the Editor
//
//-------------------------------------

	GtkCssProvider  *cssProviderMain;
	cssProviderMain  = gtk_css_provider_new();
	gtk_css_provider_load_from_resource(cssProviderMain, "/part1/css/gtk.css");
	gtk_style_context_add_provider_for_screen(gdk_screen_get_default(),
	        GTK_STYLE_PROVIDER(cssProviderMain),
	        GTK_STYLE_PROVIDER_PRIORITY_USER);

//------------------------------------------------------------------------
//	future reference
//	gtk_entry_set_width_chars (GTK_ENTRY(searchEntry2), entryWidth);
//------------------------------------------------------------------------

	gtk_widget_set_events(window, GDK_POINTER_MOTION_MASK);
	gtk_widget_set_events(vlcPosition, GDK_SCROLL_MASK);

	gtk_widget_set_events(window, GDK_POINTER_MOTION_MASK);

//---------------------------------------------------------------------
// load the first 24 program buttons with content
//---------------------------------------------------------------------

	SP->begin = 0;	// next window begins here
	SP->Xbegin = 0;	// next window begins here

	g_object_unref(builder);

	gtk_widget_show(window);

	chdir(Music_Home_Directory);

//---------------------------
//      Background colors
//---------------------------

	background_color.red   = 0;
	background_color.green = 0;
	background_color.blue  = 0;

	gtk_widget_modify_bg(window, GTK_STATE_NORMAL, &background_color);

//-----------------------------
//      attch to this window
//-----------------------------

//	log window

	gtk_window_set_transient_for (GTK_WINDOW(g_dbox4), GTK_WINDOW(window));

	SP->Pause = 0;

//--------------------------------------------------
//      set maximum limit of program scroll bar
//      set increment of program scroll bars
//--------------------------------------------------

	GdkColor frames;

	frames.red       = 0x9999;
	frames.green     = 0x9999;
	frames.blue      = 0xbbbb;

	gtk_widget_modify_bg(join_group15, GTK_STATE_NORMAL, &frames);

	frames.red       = 0x3333;
	frames.green     = 0x3333;
	frames.blue      = 0x6666;

	frames.red       = 0x6666;
	frames.green     = 0x6666;
	frames.blue      = 0x7777;

	gtk_widget_modify_bg(join_group, GTK_STATE_NORMAL, &frames);
	gtk_widget_modify_bg(join_group1, GTK_STATE_NORMAL, &frames);
	gtk_widget_modify_bg(join_group2, GTK_STATE_NORMAL, &frames);
	gtk_widget_modify_bg(join_group3, GTK_STATE_NORMAL, &frames);
	gtk_widget_modify_bg(join_group5, GTK_STATE_NORMAL, &frames);
	gtk_widget_modify_bg(join_group6, GTK_STATE_NORMAL, &frames);
	gtk_widget_modify_bg(join_group7, GTK_STATE_NORMAL, &frames);
	gtk_widget_modify_bg(join_group8, GTK_STATE_NORMAL, &frames);
	gtk_widget_modify_bg(join_group9, GTK_STATE_NORMAL, &frames);
	gtk_widget_modify_bg(join_group10, GTK_STATE_NORMAL, &frames);
	gtk_widget_modify_bg(join_group11, GTK_STATE_NORMAL, &frames);
	gtk_widget_modify_bg(join_group12, GTK_STATE_NORMAL, &frames);
	gtk_widget_modify_bg(join_group13, GTK_STATE_NORMAL, &frames);
	gtk_widget_modify_bg(join_group14, GTK_STATE_NORMAL, &frames);
	gtk_widget_modify_bg(join_group16, GTK_STATE_NORMAL, &frames);
	gtk_widget_modify_bg(join_group18, GTK_STATE_NORMAL, &frames);
	gtk_widget_modify_bg(join_group20, GTK_STATE_NORMAL, &frames);
	gtk_widget_modify_bg(join_group21, GTK_STATE_NORMAL, &frames);
	gtk_widget_modify_bg(join_group22, GTK_STATE_NORMAL, &frames);
	gtk_widget_modify_bg(join_group23, GTK_STATE_NORMAL, &frames);

	frames.red       = 0x0000;
	frames.green     = 0x0000;
	frames.blue      = 0x0000;

	gtk_widget_modify_bg(join_group17, GTK_STATE_NORMAL, &frames);

	frames.red       = 0x6666;
	frames.green     = 0x6666;
	frames.blue      = 0x7777;

	frames.red       = 0x0000;
	frames.green     = 0x0000;
	frames.blue      = 0x0000;

	gtk_widget_modify_bg(top1_back1, GTK_STATE_NORMAL, &frames);
	gtk_widget_modify_bg(pgedit_back1, GTK_STATE_NORMAL, &frames);

#if PLAYER_ON_TOP == 1
	gtk_window_set_keep_above (GTK_WINDOW(window), TRUE); // optional
#endif

	gtk_widget_show_all(window);

	gdk_window = gtk_widget_get_window(GTK_WIDGET(window));

//-----------------------------
// load main panel title text
//-----------------------------

		{
		char tmp[2048];
		strcpy(tmp, Code_Home);
		strcat(tmp, "/title.txt");
		s1 = fopen(tmp, "r");
		if (s1) {
			fgets(tmp, 100, s1);
			tmp[strlen(tmp)-1] = 0;
			gtk_label_set_text(GTK_LABEL(sgrStudio), tmp);
			fclose(s1);
			}
		}


//------------------------------------------------------------
//      enable window display - placement of this is important
//------------------------------------------------------------

	gtk_widget_show_all(window);

	GtkTargetEntry targs[1] = {"target5", GTK_TARGET_SAME_APP, 1};

#define P_BUTTON_DRAG_SETUP(NBR) \
        gtk_drag_source_set(p ##NBR, GDK_BUTTON1_MASK, targs, 1, GDK_ACTION_COPY); \
        gtk_drag_dest_set(p##NBR, GTK_DEST_DEFAULT_ALL, targs, 1, GDK_ACTION_COPY);

	P_BUTTON_DRAG_SETUP(1) P_BUTTON_DRAG_SETUP(2)
	P_BUTTON_DRAG_SETUP(3)  P_BUTTON_DRAG_SETUP(4)
	P_BUTTON_DRAG_SETUP(5) P_BUTTON_DRAG_SETUP(6)
	P_BUTTON_DRAG_SETUP(7)  P_BUTTON_DRAG_SETUP(8)
	P_BUTTON_DRAG_SETUP(9) P_BUTTON_DRAG_SETUP(10)
	P_BUTTON_DRAG_SETUP(11) P_BUTTON_DRAG_SETUP(12)

	gtkSetCursor(GDK_TOP_LEFT_ARROW); // cursor appearance

        gtk_drag_source_set(GTK_WIDGET(OverlayEntry1), GDK_BUTTON1_MASK, targs, 1, GDK_ACTION_COPY); \
        gtk_drag_dest_set(GTK_WIDGET(OverlayEntry1), GTK_DEST_DEFAULT_ALL, targs, 1, GDK_ACTION_COPY);

        gtk_drag_source_set(GTK_WIDGET(OverlayEntry2), GDK_BUTTON1_MASK, targs, 1, GDK_ACTION_COPY); \
        gtk_drag_dest_set(GTK_WIDGET(OverlayEntry2), GTK_DEST_DEFAULT_ALL, targs, 1, GDK_ACTION_COPY);

        gtk_drag_source_set(GTK_WIDGET(OverlayEntry4), GDK_BUTTON1_MASK, targs, 1, GDK_ACTION_COPY); \
        gtk_drag_dest_set(GTK_WIDGET(OverlayEntry4), GTK_DEST_DEFAULT_ALL, targs, 1, GDK_ACTION_COPY);

        gtk_drag_source_set(GTK_WIDGET(OverlayEntry5), GDK_BUTTON1_MASK, targs, 1, GDK_ACTION_COPY); \
        gtk_drag_dest_set(GTK_WIDGET(OverlayEntry5), GTK_DEST_DEFAULT_ALL, targs, 1, GDK_ACTION_COPY);


		{
		GdkColor txtcolor;
		txtcolor.red       = 0xFFFF;
		txtcolor.green     = 0xFFFF;
		txtcolor.blue      = 0x0000;
		gtk_color_button_set_color (GTK_COLOR_BUTTON(text_color), &txtcolor);
		}

	no_move = 1;

#if WSL2 == 0
	gtk_window_move(GTK_WINDOW(window), 94, 0);
#else
	gtk_window_move(GTK_WINDOW(window), 45, 24); // windows misaligns linux windows
#endif

	gtk_file_chooser_set_preview_widget_active ( GTK_FILE_CHOOSER(choose1), FALSE);

	char *p = getenv("HOME");

	gdouble x = (int) gtk_adjustment_get_value(adjustment20);

	gtk_adjustment_set_step_increment (adjustment6, x);
	gtk_adjustment_set_step_increment (adjustment7, x);
	gtk_adjustment_set_step_increment (adjustment54, x);
	gtk_adjustment_set_step_increment (adjustment40, x);

	main_vu();

	gtk_widget_hide(draw1);
	gtk_widget_hide(draw2);
	gtk_widget_hide(join_group17);

	gtk_widget_hide(opt_panel);
	gtk_widget_hide(ovl_fixed);
	gtk_widget_hide(ovl_fixed1);
	gtk_widget_hide(insert_panel);

	gtk_widget_hide(crop_adj);

	mouse_ul_x = -1;

//-----------------------
//	main timer setup
//-----------------------

	DisplayProgramButtons();

//	g_timeout_add_seconds(1, (GSourceFunc) timer_handler, widgets);
	g_timeout_add(50, (GSourceFunc) timer_handler, widgets);

//-----------------------------------------------------
//	From here on, it's all callbacks - main loop
//-----------------------------------------------------

	gtk_main(); // here we go!

	return EXIT_SUCCESS; // bye-bye
	}

